/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import jakarta.ws.rs.core.Response;
import jakarta.xml.soap.SOAPMessage;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.cxf.common.DataFormat;
import org.apache.camel.component.cxf.jaxrs.CxfConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.cxf.message.MessageContentsList;

@DeferredContextBinding
public final class CxfConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
        this.registerFallbackConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        CxfConverterLoader.addTypeConverter(registry, InputStream.class, Response.class, true, (type, exchange, value) -> {
            Object answer = CxfConverter.toInputStream((Response)value, exchange);
            if (answer == null) {
                answer = Void.class;
            }
            return answer;
        });
        CxfConverterLoader.addTypeConverter(registry, InputStream.class, SOAPMessage.class, false, (type, exchange, value) -> {
            InputStream answer = CxfConverter.soapMessageToInputStream((SOAPMessage)value, exchange);
            return answer;
        });
        CxfConverterLoader.addTypeConverter(registry, Object[].class, Object.class, false, (type, exchange, value) -> {
            Object[] answer = CxfConverter.toArray(value);
            return answer;
        });
        CxfConverterLoader.addTypeConverter(registry, String.class, SOAPMessage.class, false, (type, exchange, value) -> {
            String answer = CxfConverter.soapMessageToString((SOAPMessage)value, exchange);
            return answer;
        });
        CxfConverterLoader.addTypeConverter(registry, QName.class, String.class, false, (type, exchange, value) -> {
            QName answer = CxfConverter.toQName((String)value);
            return answer;
        });
        CxfConverterLoader.addTypeConverter(registry, DataFormat.class, String.class, false, (type, exchange, value) -> {
            DataFormat answer = CxfConverter.toDataFormat((String)value);
            return answer;
        });
        CxfConverterLoader.addTypeConverter(registry, MessageContentsList.class, Object[].class, false, (type, exchange, value) -> {
            MessageContentsList answer = CxfConverter.toMessageContentsList((Object[])value);
            return answer;
        });
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        CxfConverterLoader.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> CxfConverter.convertTo(type, exchange, value, registry));
    }

    private static void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) {
        registry.addFallbackTypeConverter((TypeConverter)new SimpleTypeConverter(allowNull, method), canPromote);
    }
}

