/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.catalog.common.CatalogHelper;
import org.apache.camel.language.csimple.CSimpleCodeGenerator;
import org.apache.camel.language.csimple.CSimpleGeneratedCode;
import org.apache.camel.parser.RouteBuilderParser;
import org.apache.camel.parser.XmlRouteParser;
import org.apache.camel.parser.model.CamelCSimpleExpressionDetails;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.exec.AbstractExecMojo;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.JavaClassSource;

@Mojo(name="generate", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateMojo
extends AbstractExecMojo {
    public static final String GENERATED_MSG = "Generated by camel build tools - do NOT edit this file!";
    public static final String RESOURCE_FILE = "META-INF/services/org/apache/camel/csimple.properties";
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File outputDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File outputResourceDir;
    @Parameter(defaultValue="${project.basedir}/src/main/resources")
    protected File resourceDir;
    @Parameter(property="camel.includeJava", defaultValue="true")
    private boolean includeJava;
    @Parameter(property="camel.includeXml", defaultValue="true")
    private boolean includeXml;
    @Parameter(property="camel.includeTest", defaultValue="false")
    private boolean includeTest;
    @Parameter(property="camel.includes")
    private String includes;
    @Parameter(property="camel.excludes")
    private String excludes;
    private final Set<String> imports = new TreeSet<String>();
    private final Map<String, String> aliases = new HashMap<String, String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.loadConfiguration();
        CSimpleCodeGenerator generator = new CSimpleCodeGenerator();
        generator.setAliases(this.aliases);
        generator.setImports(this.imports);
        this.doExecuteRoutes(generator);
    }

    protected void doExecuteRoutes(CSimpleCodeGenerator generator) {
        ArrayList<CamelCSimpleExpressionDetails> csimpleExpressions = new ArrayList<CamelCSimpleExpressionDetails>();
        LinkedHashSet javaFiles = new LinkedHashSet();
        LinkedHashSet xmlFiles = new LinkedHashSet();
        CatalogHelper.findJavaRouteBuilderClasses(javaFiles, (boolean)this.includeJava, (boolean)this.includeTest, (MavenProject)this.project);
        CatalogHelper.findXmlRouters(xmlFiles, (boolean)this.includeXml, (boolean)this.includeTest, (MavenProject)this.project);
        for (File file : javaFiles) {
            this.addJavaFiles(file, csimpleExpressions);
        }
        for (File file : xmlFiles) {
            this.addXmlFiles(file, csimpleExpressions);
        }
        if (!csimpleExpressions.isEmpty()) {
            this.getLog().info((CharSequence)("Discovered " + csimpleExpressions.size() + " csimple expressions"));
            ArrayList<CSimpleGeneratedCode> classes = new ArrayList<CSimpleGeneratedCode>();
            for (CamelCSimpleExpressionDetails cs : csimpleExpressions) {
                this.doGenerate(generator, cs, classes);
            }
            if (!classes.isEmpty()) {
                this.generatePropertiesFile(classes);
            }
        }
    }

    private void generatePropertiesFile(List<CSimpleGeneratedCode> classes) {
        StringBuilder w = new StringBuilder(4096);
        w.append("# ").append(GENERATED_MSG).append("\n");
        classes.forEach(c -> w.append(c.getFqn()).append("\n"));
        String fileName = RESOURCE_FILE;
        this.outputResourceDir.mkdirs();
        boolean saved = GenerateMojo.updateResource(this.outputResourceDir.toPath().resolve(fileName), w.toString());
        if (saved) {
            this.getLog().info((CharSequence)("Generated csimple resource file: " + fileName));
        }
    }

    private void doGenerate(CSimpleCodeGenerator generator, CamelCSimpleExpressionDetails cs, List<CSimpleGeneratedCode> classes) {
        String script = cs.getCsimple();
        String fqn = cs.getClassName();
        if (script != null && fqn == null) {
            fqn = "org.apache.camel.language.csimple.XmlRouteBuilder";
        }
        if (script != null) {
            CSimpleGeneratedCode code = cs.isPredicate() ? generator.generatePredicate(fqn, script) : generator.generateExpression(fqn, script);
            classes.add(code);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Generated source code:\n\n\n" + code.getCode() + "\n\n\n"));
            }
            String fileName = code.getFqn().replace('.', '/') + ".java";
            this.outputDir.mkdirs();
            boolean saved = GenerateMojo.updateResource(this.outputDir.toPath().resolve(fileName), code.getCode());
            if (saved) {
                this.getLog().info((CharSequence)("Generated csimple source code file: " + fileName));
            }
        }
    }

    private void addXmlFiles(File file, List<CamelCSimpleExpressionDetails> csimpleExpressions) {
        if (this.matchRouteFile(file)) {
            try (FileInputStream is = new FileInputStream(file);){
                ArrayList fileSimpleExpressions = new ArrayList();
                String fqn = file.getPath();
                String baseDir = ".";
                XmlRouteParser.parseXmlRouteCSimpleExpressions((InputStream)is, (String)baseDir, (String)fqn, fileSimpleExpressions);
                csimpleExpressions.addAll(fileSimpleExpressions);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Error parsing xml file " + String.valueOf(file) + " code due " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void addJavaFiles(File file, List<CamelCSimpleExpressionDetails> csimpleExpressions) {
        if (this.matchRouteFile(file)) {
            try {
                ArrayList fileCSimpleExpressions = new ArrayList();
                String fqn = file.getPath();
                String baseDir = ".";
                JavaType out = Roaster.parse((File)file);
                if (out instanceof JavaClassSource) {
                    JavaClassSource clazz = (JavaClassSource)out;
                    RouteBuilderParser.parseRouteBuilderCSimpleExpressions((JavaClassSource)clazz, (String)baseDir, (String)fqn, fileCSimpleExpressions);
                    csimpleExpressions.addAll(fileCSimpleExpressions);
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Error parsing java file " + String.valueOf(file) + " code due " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void loadConfiguration() {
        String[] lines;
        String configFile = this.resourceDir.getPath() + "/camel-csimple.properties";
        String loaded = GenerateMojo.load(configFile);
        if (loaded == null) {
            return;
        }
        int counter1 = 0;
        int counter2 = 0;
        for (String line : lines = loaded.split("\n")) {
            if ((line = line.trim()).startsWith("#")) continue;
            if (line.startsWith("import ")) {
                this.imports.add(line);
                ++counter1;
                continue;
            }
            String key = StringHelper.before((String)line, (String)"=");
            String value = StringHelper.after((String)line, (String)"=");
            if (key != null) {
                key = key.trim();
            }
            if (value != null) {
                value = value.trim();
            }
            if (key == null || value == null) continue;
            this.aliases.put(key, value);
            ++counter2;
        }
        if (counter1 > 0 || counter2 > 0) {
            this.getLog().info((CharSequence)("Loaded csimple language imports: " + counter1 + " and aliases: " + counter2 + " from configuration: " + configFile));
        }
    }

    private static String load(String configFile) {
        String loaded;
        FileInputStream is = null;
        try {
            File file = new File(configFile);
            if (file.exists()) {
                is = new FileInputStream(file);
            }
            if (is == null) {
                return null;
            }
            loaded = IOHelper.loadText(is);
        }
        catch (IOException e) {
            throw new RuntimeCamelException("Cannot load " + configFile);
        }
        IOHelper.close((Closeable)is);
        return loaded;
    }

    private boolean matchRouteFile(File file) {
        return CatalogHelper.matchRouteFile((File)file, (String)this.excludes, (String)this.includes, (MavenProject)this.project);
    }

    public static boolean updateResource(Path out, String data) {
        try {
            if (FileUtil.updateFile((Path)out, (String)data)) {
                return true;
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return false;
    }
}

