/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cron;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.cron.CronEndpoint;
import org.apache.camel.component.cron.CronHelper;
import org.apache.camel.component.cron.api.CamelCronConfiguration;
import org.apache.camel.component.cron.api.CamelCronService;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@Component(value="cron")
public class CronComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private String cronService;
    private CamelCronService service;

    public Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CamelCronConfiguration configuration = new CamelCronConfiguration();
        configuration.setName(remaining);
        String schedule = (String)this.getAndRemoveParameter(parameters, "schedule", String.class);
        if (schedule != null) {
            schedule = schedule.replace('+', ' ');
        }
        configuration.setSchedule(schedule);
        CronEndpoint answer = new CronEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)answer, parameters);
        this.validate(configuration);
        Endpoint delegate = this.service.createEndpoint(configuration);
        answer.setDelegate(delegate);
        if (delegate instanceof DefaultEndpoint) {
            DefaultEndpoint de = (DefaultEndpoint)delegate;
            de.setAutowiredEnabled(answer.isAutowiredEnabled());
            de.setBridgeErrorHandler(answer.isBridgeErrorHandler());
            de.setExceptionHandler(answer.getExceptionHandler());
            de.setExchangePattern(answer.getExchangePattern());
        }
        return answer;
    }

    protected void doInit() throws Exception {
        this.initCamelCronService();
    }

    public void initCamelCronService() {
        if (this.service == null) {
            this.service = CronHelper.resolveCamelCronService(this.getCamelContext(), this.cronService);
            if (this.service == null) {
                throw new RuntimeCamelException("Cannot find any CamelCronService: please add a valid implementation, such as 'camel-quartz', in order to use the 'camel-cron' component");
            }
            try {
                this.getCamelContext().addService((Object)this.service, true, false);
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
    }

    public CamelCronService getService() {
        return this.service;
    }

    public String getCronService() {
        return this.cronService;
    }

    public void setCronService(String cronService) {
        this.cronService = cronService;
    }

    private void validate(CamelCronConfiguration configuration) {
        ObjectHelper.notNull((Object)configuration, (String)"configuration");
        ObjectHelper.notNull((Object)configuration.getName(), (String)"name");
        ObjectHelper.notNull((Object)configuration.getSchedule(), (String)"schedule");
        String[] parts = configuration.getSchedule().split("\\s");
        if (parts.length < 5 || parts.length > 7) {
            throw new IllegalArgumentException("Invalid number of parts in cron expression. Expected 5 to 7, got: " + parts.length);
        }
    }
}

