/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="gc", displayName="Garbage Collector", description="Displays Garbage Collector information")
@Configurer(bootstrap=true, extended=true)
public class GarbageCollectorDevConsole
extends AbstractDevConsole {
    public GarbageCollectorDevConsole() {
        super("jvm", "gc", "Garbage Collector", "Displays Garbage Collector information");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        List<GarbageCollectorMXBean> gcs = ManagementFactory.getGarbageCollectorMXBeans();
        if (gcs != null && !gcs.isEmpty()) {
            for (GarbageCollectorMXBean gc : gcs) {
                sb.append(String.format("\n    %s: %s (%s ms)", gc.getName(), gc.getCollectionCount(), gc.getCollectionTime()));
            }
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        JsonArray arr = new JsonArray();
        root.put((Object)"garbageCollectors", (Object)arr);
        List<GarbageCollectorMXBean> gcs = ManagementFactory.getGarbageCollectorMXBeans();
        if (gcs != null && !gcs.isEmpty()) {
            for (GarbageCollectorMXBean gc : gcs) {
                JsonObject jo = new JsonObject();
                arr.add((Object)jo);
                jo.put((Object)"name", (Object)gc.getName());
                jo.put((Object)"collectionCount", (Object)gc.getCollectionCount());
                jo.put((Object)"collectionTime", (Object)gc.getCollectionTime());
                jo.put((Object)"memoryPoolNames", (Object)String.join((CharSequence)",", Arrays.asList(gc.getMemoryPoolNames())));
            }
        }
        return root;
    }
}

