/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.Route;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.throttling.ThrottlingExceptionRoutePolicy;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="circuit-breaker", description="Display circuit breaker information")
public class CircuitBreakerDevConsole
extends AbstractDevConsole {
    public CircuitBreakerDevConsole() {
        super("camel", "circuit-breaker", "Circuit Breaker", "Display circuit breaker information");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        for (Route route : this.getCamelContext().getRoutes()) {
            for (RoutePolicy rp : route.getRoutePolicyList()) {
                if (!(rp instanceof ThrottlingExceptionRoutePolicy)) continue;
                ThrottlingExceptionRoutePolicy cb = (ThrottlingExceptionRoutePolicy)rp;
                String rid = route.getRouteId();
                String state = cb.getStateAsString();
                int sc = cb.getSuccess();
                int fc = cb.getFailures();
                String lastFailure = cb.getLastFailure() > 0L ? TimeUtils.printSince((long)cb.getLastFailure()) : "n/a";
                sb.append(String.format("    %s: %s (success: %d failure: %d last-failure: %s)\n", rid, state, sc, fc, lastFailure));
            }
        }
        return sb.toString();
    }

    protected Map<String, Object> doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        for (Route route : this.getCamelContext().getRoutes()) {
            for (RoutePolicy rp : route.getRoutePolicyList()) {
                if (!(rp instanceof ThrottlingExceptionRoutePolicy)) continue;
                ThrottlingExceptionRoutePolicy cb = (ThrottlingExceptionRoutePolicy)rp;
                JsonObject jo = new JsonObject();
                jo.put((Object)"routeId", (Object)route.getRouteId());
                jo.put((Object)"state", (Object)cb.getStateAsString());
                jo.put((Object)"successfulCalls", (Object)cb.getSuccess());
                jo.put((Object)"failedCalls", (Object)cb.getFailures());
                list.add(jo);
            }
        }
        root.put((Object)"circuitBreakers", list);
        return root;
    }
}

