/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="inflight", displayName="Inflight Exchanges", description="Display inflight exchanges")
public class InflightConsole
extends AbstractDevConsole {
    public static final String FILTER = "filter";
    public static final String LIMIT = "limit";

    public InflightConsole() {
        super("camel", "inflight", "Inflight Exchanges", "Display inflight exchanges");
    }

    protected String doCallText(Map<String, Object> options) {
        String filter = (String)options.get(FILTER);
        String limit = (String)options.get(LIMIT);
        int max = limit == null ? Integer.MAX_VALUE : Integer.parseInt(limit);
        StringBuilder sb = new StringBuilder();
        InflightRepository repo = this.getCamelContext().getInflightRepository();
        sb.append(String.format("\n    Inflight: %s", repo.size()));
        sb.append(String.format("\n    InflightBrowseEnabled: %s", repo.isInflightBrowseEnabled()));
        if (repo.isInflightBrowseEnabled()) {
            for (InflightRepository.InflightExchange ie : repo.browse(filter, max, false)) {
                String age = TimeUtils.printDuration((long)ie.getDuration(), (boolean)true);
                sb.append(String.format("\n    %s (from: %s at: %s/%s remote: %b age: %s)", ie.getExchange().getExchangeId(), ie.getFromRouteId(), ie.getAtRouteId(), ie.getNodeId(), ie.isFromRemoteEndpoint(), age));
            }
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        String filter = (String)options.get(FILTER);
        String limit = (String)options.get(LIMIT);
        int max = limit == null ? Integer.MAX_VALUE : Integer.parseInt(limit);
        JsonObject root = new JsonObject();
        InflightRepository repo = this.getCamelContext().getInflightRepository();
        root.put((Object)"inflight", (Object)repo.size());
        root.put((Object)"inflightBrowseEnabled", (Object)repo.isInflightBrowseEnabled());
        if (repo.isInflightBrowseEnabled()) {
            ArrayList<JsonObject> list = new ArrayList<JsonObject>();
            for (InflightRepository.InflightExchange ie : repo.browse(filter, max, false)) {
                JsonObject props = new JsonObject();
                props.put((Object)"exchangeId", (Object)ie.getExchange().getExchangeId());
                props.put((Object)"fromRouteId", (Object)ie.getFromRouteId());
                props.put((Object)"fromRemoteEndpoint", (Object)ie.isFromRemoteEndpoint());
                props.put((Object)"atRouteId", (Object)ie.getAtRouteId());
                props.put((Object)"nodeId", (Object)ie.getNodeId());
                props.put((Object)"elapsed", (Object)ie.getElapsed());
                props.put((Object)"duration", (Object)ie.getDuration());
                list.add(props);
            }
            root.put((Object)"exchanges", list);
        }
        return root;
    }
}

