/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Map;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="thread", description="Displays JVM Threads information")
@Configurer(bootstrap=true)
public class ThreadDevConsole
extends AbstractDevConsole {
    public ThreadDevConsole() {
        super("jvm", "thread", "Thread", "Displays JVM Threads information");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        boolean st = "true".equals(options.getOrDefault("stackTrace", "false"));
        ThreadMXBean tb = ManagementFactory.getThreadMXBean();
        if (tb != null) {
            sb.append(String.format("Threads: %s\n", tb.getThreadCount()));
            sb.append(String.format("Daemon Threads: %s\n", tb.getDaemonThreadCount()));
            sb.append(String.format("Total Started Threads: %s\n", tb.getTotalStartedThreadCount()));
            sb.append(String.format("Peak Threads: %s\n", tb.getPeakThreadCount()));
            long[] ids = tb.getAllThreadIds();
            Arrays.sort(ids);
            for (long id : ids) {
                ThreadInfo ti;
                ThreadInfo threadInfo = ti = st ? tb.getThreadInfo(id, Integer.MAX_VALUE) : tb.getThreadInfo(id);
                if (ti == null) continue;
                String lock = ti.getLockName() != null ? "locked: " + ti.getLockName() : "";
                sb.append(String.format("\n    Thread %s: %s (%s) %s", id, ti.getThreadName(), ti.getThreadState().name(), lock));
                if (!st) continue;
                for (StackTraceElement e : ti.getStackTrace()) {
                    sb.append(String.format("\n        %s", e));
                }
            }
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        boolean st = "true".equals(options.getOrDefault("stackTrace", "false"));
        ThreadMXBean tb = ManagementFactory.getThreadMXBean();
        if (tb != null) {
            root.put((Object)"threadCount", (Object)tb.getThreadCount());
            root.put((Object)"daemonThreadCount", (Object)tb.getDaemonThreadCount());
            root.put((Object)"totalStartedThreadCount", (Object)tb.getTotalStartedThreadCount());
            root.put((Object)"peakThreadCount", (Object)tb.getPeakThreadCount());
            JsonArray arr = new JsonArray();
            root.put((Object)"threads", (Object)arr);
            long[] ids = tb.getAllThreadIds();
            Arrays.sort(ids);
            for (long id : ids) {
                ThreadInfo ti;
                ThreadInfo threadInfo = ti = st ? tb.getThreadInfo(id, Integer.MAX_VALUE) : tb.getThreadInfo(id);
                if (ti == null) continue;
                JsonObject jo = ThreadDevConsole.toJsonObject(ti, st);
                arr.add((Object)jo);
            }
        }
        return root;
    }

    private static JsonObject toJsonObject(ThreadInfo ti, boolean st) {
        JsonObject jo = new JsonObject();
        jo.put((Object)"id", (Object)ti.getThreadId());
        jo.put((Object)"name", (Object)ti.getThreadName());
        jo.put((Object)"state", (Object)ti.getThreadState().name());
        jo.put((Object)"blockedCount", (Object)ti.getBlockedCount());
        jo.put((Object)"blockedTime", (Object)ti.getBlockedTime());
        jo.put((Object)"waitedCount", (Object)ti.getWaitedCount());
        jo.put((Object)"waitedTime", (Object)ti.getWaitedTime());
        if (ti.getLockName() != null) {
            jo.put((Object)"lockName", (Object)ti.getLockName());
        }
        if (st) {
            JsonArray arr2 = new JsonArray();
            jo.put((Object)"stackTrace", (Object)arr2);
            for (StackTraceElement e : ti.getStackTrace()) {
                arr2.add((Object)e.toString());
            }
        }
        return jo;
    }
}

