/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.io.Closeable;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.impl.console.ConsoleHelper;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="source")
public class SourceDevConsole
extends AbstractDevConsole {
    public static final String FILTER = "filter";
    public static final String LIMIT = "limit";

    public SourceDevConsole() {
        super("camel", "source", "Source", "Display route source code");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        Function<ManagedRouteMBean, Object> task = mrb -> {
            String loc = mrb.getSourceLocation();
            if (loc != null) {
                loc = LoggerHelper.stripSourceLocationLineNumber((String)loc);
                StringBuilder code = new StringBuilder();
                try {
                    Resource resource = PluginHelper.getResourceLoader((CamelContext)this.getCamelContext()).resolveResource(loc);
                    if (resource != null) {
                        String t;
                        if (!sb.isEmpty()) {
                            sb.append("\n");
                        }
                        LineNumberReader reader = new LineNumberReader(resource.getReader());
                        int i = 0;
                        do {
                            if ((t = reader.readLine()) == null) continue;
                            code.append(String.format("\n    #%s %s", ++i, t));
                        } while (t != null);
                        IOHelper.close((Closeable)reader);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sb.append(String.format("    Id: %s", mrb.getRouteId()));
                if (mrb.getSourceLocation() != null) {
                    sb.append(String.format("\n    Source: %s", mrb.getSourceLocation()));
                }
                if (!code.isEmpty()) {
                    sb.append((CharSequence)code);
                }
            }
            sb.append("\n");
            return null;
        };
        this.doCall(options, task);
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        ArrayList list = new ArrayList();
        Function<ManagedRouteMBean, Object> task = mrb -> {
            JsonObject jo = new JsonObject();
            list.add(jo);
            jo.put((Object)"routeId", (Object)mrb.getRouteId());
            jo.put((Object)"from", (Object)mrb.getEndpointUri());
            if (mrb.getSourceLocation() != null) {
                jo.put((Object)"source", (Object)mrb.getSourceLocation());
            }
            String loc = mrb.getSourceLocation();
            List<JsonObject> code = ConsoleHelper.loadSourceAsJson(this.getCamelContext(), loc);
            if (code != null) {
                jo.put((Object)"code", code);
            }
            return null;
        };
        this.doCall(options, task);
        root.put((Object)"routes", list);
        return root;
    }

    protected void doCall(Map<String, Object> options, Function<ManagedRouteMBean, Object> task) {
        String path = (String)options.get("CamelHttpPath");
        String subPath = path != null ? StringHelper.after((String)path, (String)"/") : null;
        String filter = (String)options.get(FILTER);
        String limit = (String)options.get(LIMIT);
        int max = limit == null ? Integer.MAX_VALUE : Integer.parseInt(limit);
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        if (mcc != null) {
            List routes = this.getCamelContext().getRoutes();
            routes.sort((o1, o2) -> o1.getRouteId().compareToIgnoreCase(o2.getRouteId()));
            routes.stream().map(route -> mcc.getManagedRoute(route.getRouteId())).filter(Objects::nonNull).filter(r -> SourceDevConsole.accept(r, filter)).filter(r -> SourceDevConsole.accept(r, subPath)).sorted(SourceDevConsole::sort).limit(max).forEach(task::apply);
        }
    }

    private static boolean accept(ManagedRouteMBean mrb, String filter) {
        if (filter == null || filter.isBlank()) {
            return true;
        }
        return PatternHelper.matchPattern((String)mrb.getRouteId(), (String)filter) || PatternHelper.matchPattern((String)mrb.getEndpointUri(), (String)filter) || PatternHelper.matchPattern((String)mrb.getSourceLocationShort(), (String)filter);
    }

    private static int sort(ManagedRouteMBean o1, ManagedRouteMBean o2) {
        return o1.getRouteId().compareTo(o2.getRouteId());
    }
}

