/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Map;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.StartupStep;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="startup-recorder")
public class StartupRecorderDevConsole
extends AbstractDevConsole {
    public StartupRecorderDevConsole() {
        super("camel", "startup-recorder", "Startup Recorder", "Display startup recording");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        ExtendedCamelContext ecc = this.getCamelContext().getCamelContextExtension();
        StartupStepRecorder recorder = ecc.getStartupStepRecorder();
        if (recorder != null) {
            recorder.steps().forEach(s -> sb.append(this.logStep((StartupStep)s)).append("\n"));
        }
        return sb.toString();
    }

    protected Map<String, Object> doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        JsonArray arr = new JsonArray();
        ExtendedCamelContext ecc = this.getCamelContext().getCamelContextExtension();
        StartupStepRecorder recorder = ecc.getStartupStepRecorder();
        if (recorder != null) {
            recorder.steps().forEach(s -> {
                JsonObject jo = new JsonObject();
                jo.put((Object)"id", (Object)s.getId());
                jo.put((Object)"parentId", (Object)s.getParentId());
                jo.put((Object)"level", (Object)s.getLevel());
                jo.put((Object)"name", (Object)s.getName());
                jo.put((Object)"type", (Object)s.getType());
                jo.put((Object)"description", (Object)s.getDescription());
                jo.put((Object)"beginTime", (Object)s.getBeginTime());
                jo.put((Object)"duration", (Object)s.getDuration());
                arr.add((Object)jo);
            });
        }
        if (!arr.isEmpty()) {
            root.put((Object)"steps", (Object)arr);
        }
        return root;
    }

    protected String logStep(StartupStep step) {
        long delta = step.getDuration();
        String pad = StringHelper.padString((int)step.getLevel());
        String out = String.format("%s", pad + step.getType());
        String out2 = String.format("%6s ms", delta);
        String out3 = String.format("%s(%s)", step.getDescription(), step.getName());
        return String.format("%s : %s - %s", out2, out, out3);
    }
}

