/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="health")
public class HealthDevConsole
extends AbstractDevConsole {
    public HealthDevConsole() {
        super("camel", "health", "Health Check", "Health Check Status");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        String exposureLevel = (String)options.get("exposureLevel");
        Collection results = HealthCheckHelper.invoke((CamelContext)this.getCamelContext(), (String)exposureLevel);
        boolean up = results.stream().allMatch(h -> HealthCheck.State.UP.equals((Object)h.getState()));
        sb.append(String.format("Health Check Status: %s", up ? "UP" : "DOWN"));
        sb.append("\n");
        results.forEach(res -> {
            boolean ok = res.getState().equals((Object)HealthCheck.State.UP);
            if (ok) {
                sb.append(String.format("\n    %s: %s", res.getCheck().getId(), res.getState()));
            } else {
                if (res.getMessage().isPresent()) {
                    sb.append(String.format("\n    %s: %s (%s)", res.getCheck().getId(), res.getState(), res.getMessage()));
                } else {
                    sb.append(String.format("\n    %s: %s", res.getCheck().getId(), res.getState()));
                }
                Throwable cause = res.getError().orElse(null);
                if (cause != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    cause.printStackTrace(pw);
                    sb.append(pw);
                    sb.append("\n\n");
                }
            }
        });
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        String exposureLevel = (String)options.get("exposureLevel");
        Collection readies = HealthCheckHelper.invokeReadiness((CamelContext)this.getCamelContext(), (String)exposureLevel);
        Collection lives = HealthCheckHelper.invokeLiveness((CamelContext)this.getCamelContext(), (String)exposureLevel);
        boolean ready = HealthCheckHelper.isResultsUp((Collection)readies, (boolean)true);
        boolean live = HealthCheckHelper.isResultsUp((Collection)lives, (boolean)false);
        root.put((Object)"up", (Object)(ready && live ? 1 : 0));
        root.put((Object)"ready", (Object)ready);
        root.put((Object)"live", (Object)live);
        JsonArray arr = new JsonArray();
        root.put((Object)"checks", (Object)arr);
        Stream checks = Stream.concat(readies.stream(), lives.stream());
        checks.forEach(res -> {
            JsonObject jo = new JsonObject();
            arr.add((Object)jo);
            boolean ok = res.getState().equals((Object)HealthCheck.State.UP);
            jo.put((Object)"id", (Object)res.getCheck().getId());
            jo.put((Object)"group", (Object)res.getCheck().getGroup());
            if (ok) {
                jo.put((Object)"up", (Object)true);
            } else {
                jo.put((Object)"up", (Object)false);
            }
            jo.put((Object)"state", (Object)res.getState().toString());
            jo.put((Object)"enabled", (Object)res.getCheck().isEnabled());
            jo.put((Object)"readiness", (Object)res.getCheck().isReadiness());
            jo.put((Object)"liveness", (Object)res.getCheck().isLiveness());
            if (!ok) {
                String msg = res.getMessage().orElse("");
                jo.put((Object)"message", (Object)msg);
                Throwable cause = res.getError().orElse(null);
                if (cause != null) {
                    JsonArray arr2 = new JsonArray();
                    StringWriter writer = new StringWriter();
                    cause.printStackTrace(new PrintWriter(writer));
                    writer.flush();
                    String trace = writer.toString();
                    jo.put((Object)"stackTrace", (Object)arr2);
                    Collections.addAll(arr2, trace.split("\n"));
                }
            }
            if (!res.getDetails().isEmpty()) {
                JsonObject details = new JsonObject();
                res.getDetails().forEach((k, v) -> details.put(k, (Object)v.toString()));
                jo.put((Object)"details", (Object)details);
            }
        });
        return root;
    }
}

