/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteGroupMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DevConsole(name="route-group", description="Route Group information")
public class RouteGroupDevConsole
extends AbstractDevConsole {
    private static final Logger LOG = LoggerFactory.getLogger(RouteGroupDevConsole.class);
    public static final String FILTER = "filter";
    public static final String LIMIT = "limit";
    public static final String ACTION = "action";

    public RouteGroupDevConsole() {
        super("camel", "route-group", "Route Group", "Route Group information");
    }

    protected String doCallText(Map<String, Object> options) {
        String action = (String)options.get(ACTION);
        String filter = (String)options.get(FILTER);
        if (action != null) {
            this.doAction(this.getCamelContext(), action, filter);
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Function<ManagedRouteGroupMBean, Object> task = mrg -> {
            String ago;
            Date last;
            String thp;
            if (!sb.isEmpty()) {
                sb.append("\n");
            }
            sb.append(String.format("    Group: %s", mrg.getRouteGroup()));
            sb.append(String.format("\n    Size: %s", mrg.getGroupSize()));
            sb.append(String.format("\n    State: %s", mrg.getState()));
            sb.append(String.format("\n    Uptime: %s", mrg.getUptime()));
            String coverage = this.calculateRouteCoverage((ManagedRouteGroupMBean)mrg, true);
            if (coverage != null) {
                sb.append(String.format("\n    Coverage: %s", coverage));
            }
            String load1 = this.getLoad1((ManagedRouteGroupMBean)mrg);
            String load5 = this.getLoad5((ManagedRouteGroupMBean)mrg);
            String load15 = this.getLoad15((ManagedRouteGroupMBean)mrg);
            if (!(load1.isEmpty() && load5.isEmpty() && load15.isEmpty())) {
                sb.append(String.format("\n    Load Average: %s %s %s", load1, load5, load15));
            }
            if (!(thp = this.getThroughput((ManagedRouteGroupMBean)mrg)).isEmpty()) {
                sb.append(String.format("\n    Messages/Sec: %s", thp));
            }
            sb.append(String.format("\n    Total: %s", mrg.getExchangesTotal()));
            sb.append(String.format("\n    Failed: %s", mrg.getExchangesFailed()));
            sb.append(String.format("\n    Inflight: %s", mrg.getExchangesInflight()));
            long idle = mrg.getIdleSince();
            if (idle > 0L) {
                sb.append(String.format("\n    Idle Since: %s", TimeUtils.printDuration((long)idle)));
            } else {
                sb.append(String.format("\n    Idle Since: %s", ""));
            }
            sb.append(String.format("\n    Mean Time: %s", TimeUtils.printDuration((long)mrg.getMeanProcessingTime(), (boolean)true)));
            sb.append(String.format("\n    Max Time: %s", TimeUtils.printDuration((long)mrg.getMaxProcessingTime(), (boolean)true)));
            sb.append(String.format("\n    Min Time: %s", TimeUtils.printDuration((long)mrg.getMinProcessingTime(), (boolean)true)));
            if (mrg.getExchangesTotal() > 0L) {
                sb.append(String.format("\n    Last Time: %s", TimeUtils.printDuration((long)mrg.getLastProcessingTime(), (boolean)true)));
                sb.append(String.format("\n    Delta Time: %s", TimeUtils.printDuration((long)mrg.getDeltaProcessingTime(), (boolean)true)));
            }
            if ((last = mrg.getLastExchangeCreatedTimestamp()) != null) {
                ago = TimeUtils.printSince((long)last.getTime());
                sb.append(String.format("\n    Since Last Started: %s", ago));
            }
            if ((last = mrg.getLastExchangeCompletedTimestamp()) != null) {
                ago = TimeUtils.printSince((long)last.getTime());
                sb.append(String.format("\n    Since Last Completed: %s", ago));
            }
            if ((last = mrg.getLastExchangeFailureTimestamp()) != null) {
                ago = TimeUtils.printSince((long)last.getTime());
                sb.append(String.format("\n    Since Last Failed: %s", ago));
            }
            sb.append("\n");
            return null;
        };
        this.doCall(options, task);
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        String action = (String)options.get(ACTION);
        String filter = (String)options.get(FILTER);
        if (action != null) {
            this.doAction(this.getCamelContext(), action, filter);
            return new JsonObject();
        }
        JsonObject root = new JsonObject();
        ArrayList list = new ArrayList();
        Function<ManagedRouteGroupMBean, Object> task = mrg -> {
            Date last;
            String thp;
            JsonObject jo = new JsonObject();
            list.add(jo);
            jo.put((Object)"group", (Object)mrg.getRouteGroup());
            jo.put((Object)"size", (Object)mrg.getGroupSize());
            jo.put((Object)"state", (Object)mrg.getState());
            jo.put((Object)"uptime", (Object)mrg.getUptime());
            jo.put((Object)"routeIds", (Object)new JsonArray(Arrays.stream(mrg.getGroupIds()).toList()));
            JsonObject stats = new JsonObject();
            String coverage = this.calculateRouteCoverage((ManagedRouteGroupMBean)mrg, false);
            if (coverage != null) {
                stats.put((Object)"coverage", (Object)coverage);
            }
            String load1 = this.getLoad1((ManagedRouteGroupMBean)mrg);
            String load5 = this.getLoad5((ManagedRouteGroupMBean)mrg);
            String load15 = this.getLoad15((ManagedRouteGroupMBean)mrg);
            if (!(load1.isEmpty() && load5.isEmpty() && load15.isEmpty())) {
                stats.put((Object)"load01", (Object)load1);
                stats.put((Object)"load05", (Object)load5);
                stats.put((Object)"load15", (Object)load15);
            }
            if (!(thp = this.getThroughput((ManagedRouteGroupMBean)mrg)).isEmpty()) {
                stats.put((Object)"exchangesThroughput", (Object)thp);
            }
            stats.put((Object)"idleSince", (Object)mrg.getIdleSince());
            stats.put((Object)"exchangesTotal", (Object)mrg.getExchangesTotal());
            stats.put((Object)"exchangesFailed", (Object)mrg.getExchangesFailed());
            stats.put((Object)"exchangesInflight", (Object)mrg.getExchangesInflight());
            stats.put((Object)"meanProcessingTime", (Object)mrg.getMeanProcessingTime());
            stats.put((Object)"maxProcessingTime", (Object)mrg.getMaxProcessingTime());
            stats.put((Object)"minProcessingTime", (Object)mrg.getMinProcessingTime());
            if (mrg.getExchangesTotal() > 0L) {
                stats.put((Object)"lastProcessingTime", (Object)mrg.getLastProcessingTime());
                stats.put((Object)"deltaProcessingTime", (Object)mrg.getDeltaProcessingTime());
            }
            if ((last = mrg.getLastExchangeCreatedTimestamp()) != null) {
                stats.put((Object)"lastCreatedExchangeTimestamp", (Object)last.getTime());
            }
            if ((last = mrg.getLastExchangeCompletedTimestamp()) != null) {
                stats.put((Object)"lastCompletedExchangeTimestamp", (Object)last.getTime());
            }
            if ((last = mrg.getLastExchangeFailureTimestamp()) != null) {
                stats.put((Object)"lastFailedExchangeTimestamp", (Object)last.getTime());
            }
            jo.put((Object)"statistics", (Object)stats);
            return null;
        };
        this.doCall(options, task);
        root.put((Object)"routeGroups", list);
        return root;
    }

    protected void doCall(Map<String, Object> options, Function<ManagedRouteGroupMBean, Object> task) {
        String path = (String)options.get("CamelHttpPath");
        String subPath = path != null ? StringHelper.after((String)path, (String)"/") : null;
        String filter = (String)options.get(FILTER);
        String limit = (String)options.get(LIMIT);
        int max = limit == null ? Integer.MAX_VALUE : Integer.parseInt(limit);
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        if (mcc != null) {
            List routes = this.getCamelContext().getRoutes();
            routes.sort((o1, o2) -> o1.getRouteId().compareToIgnoreCase(o2.getRouteId()));
            routes.stream().map(route -> mcc.getManagedRouteGroup(route.getGroup())).filter(Objects::nonNull).filter(r -> RouteGroupDevConsole.accept(r, filter)).filter(r -> RouteGroupDevConsole.accept(r, subPath)).distinct().sorted(RouteGroupDevConsole::sort).limit(max).forEach(task::apply);
        }
    }

    private static boolean accept(ManagedRouteGroupMBean mrg, String filter) {
        if (filter == null || filter.isBlank()) {
            return true;
        }
        return PatternHelper.matchPattern((String)mrg.getRouteGroup(), (String)filter);
    }

    private static int sort(ManagedRouteGroupMBean o1, ManagedRouteGroupMBean o2) {
        return o1.getRouteGroup().compareToIgnoreCase(o2.getRouteGroup());
    }

    private String getLoad1(ManagedRouteGroupMBean mrg) {
        String s = mrg.getLoad01();
        s = s.replace(',', '.');
        return s;
    }

    private String getLoad5(ManagedRouteGroupMBean mrg) {
        String s = mrg.getLoad05();
        s = s.replace(',', '.');
        return s;
    }

    private String getLoad15(ManagedRouteGroupMBean mrg) {
        String s = mrg.getLoad15();
        s = s.replace(',', '.');
        return s;
    }

    private String getThroughput(ManagedRouteGroupMBean mrg) {
        String s = mrg.getThroughput();
        s = s.replace(',', '.');
        return s;
    }

    private String calculateRouteCoverage(ManagedRouteGroupMBean mrg, boolean percent) {
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        ArrayList ids = new ArrayList();
        for (String id : mrg.getGroupIds()) {
            ManagedRouteMBean mrb = mcc.getManagedRoute(id);
            try {
                ids.addAll(mrb.processorIds());
            }
            catch (Exception e) {
                return null;
            }
        }
        int total = ids.size();
        int covered = 0;
        for (String id : ids) {
            ManagedProcessorMBean mp = mcc.getManagedProcessor(id);
            if (mp == null || mp.getExchangesTotal() <= 0L) continue;
            ++covered;
        }
        if (percent) {
            double p = total > 0 ? (double)covered / (double)total * 100.0 : 0.0;
            String f = String.format("%.0f", p);
            return covered + "/" + total + " (" + f + "%)";
        }
        return covered + "/" + total;
    }

    protected void doAction(CamelContext camelContext, String command, String filter) {
        if (filter == null) {
            filter = "*";
        }
        String[] patterns = filter.split(",");
        List<String> ids = camelContext.getRoutes().stream().map(Route::getGroup).filter(group -> {
            for (String p : patterns) {
                if (!PatternHelper.matchPattern((String)group, (String)p)) continue;
                return true;
            }
            return false;
        }).distinct().toList();
        for (String id : ids) {
            try {
                if ("start".equals(command)) {
                    if ("*".equals(id)) {
                        camelContext.getRouteController().startAllRoutes();
                        continue;
                    }
                    camelContext.getRouteController().startRouteGroup(id);
                    continue;
                }
                if (!"stop".equals(command)) continue;
                if ("*".equals(id)) {
                    camelContext.getRouteController().stopAllRoutes();
                    continue;
                }
                camelContext.getRouteController().stopRouteGroup(id);
            }
            catch (Exception e) {
                LOG.warn("Error {} route: {} due to: {}. This exception is ignored.", new Object[]{command, id, e.getMessage(), e});
            }
        }
    }
}

