/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.docling.DoclingComponent;
import org.apache.camel.component.docling.DoclingConfiguration;
import org.apache.camel.component.docling.DoclingOperations;

public interface DoclingComponentBuilderFactory {
    public static DoclingComponentBuilder docling() {
        return new DoclingComponentBuilderImpl();
    }

    public static class DoclingComponentBuilderImpl
    extends AbstractComponentBuilder<DoclingComponent>
    implements DoclingComponentBuilder {
        @Override
        protected DoclingComponent buildConcreteComponent() {
            return new DoclingComponent();
        }

        private DoclingConfiguration getOrCreateConfiguration(DoclingComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new DoclingConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((DoclingComponent)component).setConfiguration((DoclingConfiguration)value);
                    return true;
                }
                case "contentInBody": {
                    this.getOrCreateConfiguration((DoclingComponent)component).setContentInBody(((Boolean)value).booleanValue());
                    return true;
                }
                case "enableOCR": {
                    this.getOrCreateConfiguration((DoclingComponent)component).setEnableOCR(((Boolean)value).booleanValue());
                    return true;
                }
                case "includeLayoutInfo": {
                    this.getOrCreateConfiguration((DoclingComponent)component).setIncludeLayoutInfo(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((DoclingComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "ocrLanguage": {
                    this.getOrCreateConfiguration((DoclingComponent)component).setOcrLanguage((String)value);
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((DoclingComponent)component).setOperation((DoclingOperations)value);
                    return true;
                }
                case "outputFormat": {
                    this.getOrCreateConfiguration((DoclingComponent)component).setOutputFormat((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((DoclingComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "doclingCommand": {
                    this.getOrCreateConfiguration((DoclingComponent)component).setDoclingCommand((String)value);
                    return true;
                }
                case "processTimeout": {
                    this.getOrCreateConfiguration((DoclingComponent)component).setProcessTimeout(((Long)value).longValue());
                    return true;
                }
                case "workingDirectory": {
                    this.getOrCreateConfiguration((DoclingComponent)component).setWorkingDirectory((String)value);
                    return true;
                }
                case "maxFileSize": {
                    this.getOrCreateConfiguration((DoclingComponent)component).setMaxFileSize(((Long)value).longValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface DoclingComponentBuilder
    extends ComponentBuilder<DoclingComponent> {
        default public DoclingComponentBuilder configuration(DoclingConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public DoclingComponentBuilder contentInBody(boolean contentInBody) {
            this.doSetProperty("contentInBody", contentInBody);
            return this;
        }

        default public DoclingComponentBuilder enableOCR(boolean enableOCR) {
            this.doSetProperty("enableOCR", enableOCR);
            return this;
        }

        default public DoclingComponentBuilder includeLayoutInfo(boolean includeLayoutInfo) {
            this.doSetProperty("includeLayoutInfo", includeLayoutInfo);
            return this;
        }

        default public DoclingComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public DoclingComponentBuilder ocrLanguage(String ocrLanguage) {
            this.doSetProperty("ocrLanguage", ocrLanguage);
            return this;
        }

        default public DoclingComponentBuilder operation(DoclingOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public DoclingComponentBuilder outputFormat(String outputFormat) {
            this.doSetProperty("outputFormat", outputFormat);
            return this;
        }

        default public DoclingComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public DoclingComponentBuilder doclingCommand(String doclingCommand) {
            this.doSetProperty("doclingCommand", doclingCommand);
            return this;
        }

        default public DoclingComponentBuilder processTimeout(long processTimeout) {
            this.doSetProperty("processTimeout", processTimeout);
            return this;
        }

        default public DoclingComponentBuilder workingDirectory(String workingDirectory) {
            this.doSetProperty("workingDirectory", workingDirectory);
            return this;
        }

        default public DoclingComponentBuilder maxFileSize(long maxFileSize) {
            this.doSetProperty("maxFileSize", maxFileSize);
            return this;
        }
    }
}

