/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.websocket.WebsocketComponent;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.eclipse.jetty.util.thread.ThreadPool;

public interface WebsocketComponentBuilderFactory {
    public static WebsocketComponentBuilder websocket() {
        return new WebsocketComponentBuilderImpl();
    }

    public static class WebsocketComponentBuilderImpl
    extends AbstractComponentBuilder<WebsocketComponent>
    implements WebsocketComponentBuilder {
        @Override
        protected WebsocketComponent buildConcreteComponent() {
            return new WebsocketComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "host": {
                    ((WebsocketComponent)component).setHost((String)value);
                    return true;
                }
                case "port": {
                    ((WebsocketComponent)component).setPort((Integer)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((WebsocketComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "staticResources": {
                    ((WebsocketComponent)component).setStaticResources((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((WebsocketComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((WebsocketComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "enableJmx": {
                    ((WebsocketComponent)component).setEnableJmx(((Boolean)value).booleanValue());
                    return true;
                }
                case "maxThreads": {
                    ((WebsocketComponent)component).setMaxThreads((Integer)value);
                    return true;
                }
                case "minThreads": {
                    ((WebsocketComponent)component).setMinThreads((Integer)value);
                    return true;
                }
                case "subprotocol": {
                    ((WebsocketComponent)component).setSubprotocol((String)value);
                    return true;
                }
                case "threadPool": {
                    ((WebsocketComponent)component).setThreadPool((ThreadPool)value);
                    return true;
                }
                case "sslContextParameters": {
                    ((WebsocketComponent)component).setSslContextParameters((SSLContextParameters)value);
                    return true;
                }
                case "sslKeyPassword": {
                    ((WebsocketComponent)component).setSslKeyPassword((String)value);
                    return true;
                }
                case "sslKeystore": {
                    ((WebsocketComponent)component).setSslKeystore((String)value);
                    return true;
                }
                case "sslPassword": {
                    ((WebsocketComponent)component).setSslPassword((String)value);
                    return true;
                }
                case "useGlobalSslContextParameters": {
                    ((WebsocketComponent)component).setUseGlobalSslContextParameters(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface WebsocketComponentBuilder
    extends ComponentBuilder<WebsocketComponent> {
        default public WebsocketComponentBuilder host(String host) {
            this.doSetProperty("host", host);
            return this;
        }

        default public WebsocketComponentBuilder port(Integer port) {
            this.doSetProperty("port", port);
            return this;
        }

        default public WebsocketComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public WebsocketComponentBuilder staticResources(String staticResources) {
            this.doSetProperty("staticResources", staticResources);
            return this;
        }

        default public WebsocketComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public WebsocketComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public WebsocketComponentBuilder enableJmx(boolean enableJmx) {
            this.doSetProperty("enableJmx", enableJmx);
            return this;
        }

        default public WebsocketComponentBuilder maxThreads(Integer maxThreads) {
            this.doSetProperty("maxThreads", maxThreads);
            return this;
        }

        default public WebsocketComponentBuilder minThreads(Integer minThreads) {
            this.doSetProperty("minThreads", minThreads);
            return this;
        }

        default public WebsocketComponentBuilder subprotocol(String subprotocol) {
            this.doSetProperty("subprotocol", subprotocol);
            return this;
        }

        default public WebsocketComponentBuilder threadPool(ThreadPool threadPool) {
            this.doSetProperty("threadPool", threadPool);
            return this;
        }

        default public WebsocketComponentBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public WebsocketComponentBuilder sslKeyPassword(String sslKeyPassword) {
            this.doSetProperty("sslKeyPassword", sslKeyPassword);
            return this;
        }

        default public WebsocketComponentBuilder sslKeystore(String sslKeystore) {
            this.doSetProperty("sslKeystore", sslKeystore);
            return this;
        }

        default public WebsocketComponentBuilder sslPassword(String sslPassword) {
            this.doSetProperty("sslPassword", sslPassword);
            return this;
        }

        default public WebsocketComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            this.doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    }
}

