/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.mllp.MllpComponent;
import org.apache.camel.component.mllp.MllpConfiguration;
import org.apache.camel.component.mllp.MllpIdleTimeoutStrategy;

public interface MllpComponentBuilderFactory {
    public static MllpComponentBuilder mllp() {
        return new MllpComponentBuilderImpl();
    }

    public static class MllpComponentBuilderImpl
    extends AbstractComponentBuilder<MllpComponent>
    implements MllpComponentBuilder {
        @Override
        protected MllpComponent buildConcreteComponent() {
            return new MllpComponent();
        }

        private MllpConfiguration getOrCreateConfiguration(MllpComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new MllpConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "autoAck": {
                    this.getOrCreateConfiguration((MllpComponent)component).setAutoAck(((Boolean)value).booleanValue());
                    return true;
                }
                case "charsetName": {
                    this.getOrCreateConfiguration((MllpComponent)component).setCharsetName((String)value);
                    return true;
                }
                case "configuration": {
                    ((MllpComponent)component).setConfiguration((MllpConfiguration)value);
                    return true;
                }
                case "hl7Headers": {
                    this.getOrCreateConfiguration((MllpComponent)component).setHl7Headers(((Boolean)value).booleanValue());
                    return true;
                }
                case "requireEndOfData": {
                    this.getOrCreateConfiguration((MllpComponent)component).setRequireEndOfData(((Boolean)value).booleanValue());
                    return true;
                }
                case "stringPayload": {
                    this.getOrCreateConfiguration((MllpComponent)component).setStringPayload(((Boolean)value).booleanValue());
                    return true;
                }
                case "validatePayload": {
                    this.getOrCreateConfiguration((MllpComponent)component).setValidatePayload(((Boolean)value).booleanValue());
                    return true;
                }
                case "acceptTimeout": {
                    this.getOrCreateConfiguration((MllpComponent)component).setAcceptTimeout(((Integer)value).intValue());
                    return true;
                }
                case "backlog": {
                    this.getOrCreateConfiguration((MllpComponent)component).setBacklog((Integer)value);
                    return true;
                }
                case "bindRetryInterval": {
                    this.getOrCreateConfiguration((MllpComponent)component).setBindRetryInterval(((Integer)value).intValue());
                    return true;
                }
                case "bindTimeout": {
                    this.getOrCreateConfiguration((MllpComponent)component).setBindTimeout(((Integer)value).intValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    this.getOrCreateConfiguration((MllpComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lenientBind": {
                    this.getOrCreateConfiguration((MllpComponent)component).setLenientBind(((Boolean)value).booleanValue());
                    return true;
                }
                case "maxConcurrentConsumers": {
                    this.getOrCreateConfiguration((MllpComponent)component).setMaxConcurrentConsumers(((Integer)value).intValue());
                    return true;
                }
                case "reuseAddress": {
                    this.getOrCreateConfiguration((MllpComponent)component).setReuseAddress((Boolean)value);
                    return true;
                }
                case "exchangePattern": {
                    this.getOrCreateConfiguration((MllpComponent)component).setExchangePattern((ExchangePattern)value);
                    return true;
                }
                case "connectTimeout": {
                    this.getOrCreateConfiguration((MllpComponent)component).setConnectTimeout(((Integer)value).intValue());
                    return true;
                }
                case "idleTimeoutStrategy": {
                    this.getOrCreateConfiguration((MllpComponent)component).setIdleTimeoutStrategy((MllpIdleTimeoutStrategy)value);
                    return true;
                }
                case "keepAlive": {
                    this.getOrCreateConfiguration((MllpComponent)component).setKeepAlive((Boolean)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((MllpComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "tcpNoDelay": {
                    this.getOrCreateConfiguration((MllpComponent)component).setTcpNoDelay((Boolean)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((MllpComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "defaultCharset": {
                    ((MllpComponent)component).setDefaultCharset((String)value);
                    return true;
                }
                case "logPhi": {
                    ((MllpComponent)component).setLogPhi((Boolean)value);
                    return true;
                }
                case "logPhiMaxBytes": {
                    ((MllpComponent)component).setLogPhiMaxBytes((Integer)value);
                    return true;
                }
                case "readTimeout": {
                    this.getOrCreateConfiguration((MllpComponent)component).setReadTimeout(((Integer)value).intValue());
                    return true;
                }
                case "receiveBufferSize": {
                    this.getOrCreateConfiguration((MllpComponent)component).setReceiveBufferSize((Integer)value);
                    return true;
                }
                case "receiveTimeout": {
                    this.getOrCreateConfiguration((MllpComponent)component).setReceiveTimeout(((Integer)value).intValue());
                    return true;
                }
                case "sendBufferSize": {
                    this.getOrCreateConfiguration((MllpComponent)component).setSendBufferSize((Integer)value);
                    return true;
                }
                case "idleTimeout": {
                    this.getOrCreateConfiguration((MllpComponent)component).setIdleTimeout((Integer)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface MllpComponentBuilder
    extends ComponentBuilder<MllpComponent> {
        default public MllpComponentBuilder autoAck(boolean autoAck) {
            this.doSetProperty("autoAck", autoAck);
            return this;
        }

        default public MllpComponentBuilder charsetName(String charsetName) {
            this.doSetProperty("charsetName", charsetName);
            return this;
        }

        default public MllpComponentBuilder configuration(MllpConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public MllpComponentBuilder hl7Headers(boolean hl7Headers) {
            this.doSetProperty("hl7Headers", hl7Headers);
            return this;
        }

        default public MllpComponentBuilder requireEndOfData(boolean requireEndOfData) {
            this.doSetProperty("requireEndOfData", requireEndOfData);
            return this;
        }

        default public MllpComponentBuilder stringPayload(boolean stringPayload) {
            this.doSetProperty("stringPayload", stringPayload);
            return this;
        }

        default public MllpComponentBuilder validatePayload(boolean validatePayload) {
            this.doSetProperty("validatePayload", validatePayload);
            return this;
        }

        default public MllpComponentBuilder acceptTimeout(int acceptTimeout) {
            this.doSetProperty("acceptTimeout", acceptTimeout);
            return this;
        }

        default public MllpComponentBuilder backlog(Integer backlog) {
            this.doSetProperty("backlog", backlog);
            return this;
        }

        default public MllpComponentBuilder bindRetryInterval(int bindRetryInterval) {
            this.doSetProperty("bindRetryInterval", bindRetryInterval);
            return this;
        }

        default public MllpComponentBuilder bindTimeout(int bindTimeout) {
            this.doSetProperty("bindTimeout", bindTimeout);
            return this;
        }

        default public MllpComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public MllpComponentBuilder lenientBind(boolean lenientBind) {
            this.doSetProperty("lenientBind", lenientBind);
            return this;
        }

        default public MllpComponentBuilder maxConcurrentConsumers(int maxConcurrentConsumers) {
            this.doSetProperty("maxConcurrentConsumers", maxConcurrentConsumers);
            return this;
        }

        default public MllpComponentBuilder reuseAddress(Boolean reuseAddress) {
            this.doSetProperty("reuseAddress", reuseAddress);
            return this;
        }

        default public MllpComponentBuilder exchangePattern(ExchangePattern exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public MllpComponentBuilder connectTimeout(int connectTimeout) {
            this.doSetProperty("connectTimeout", connectTimeout);
            return this;
        }

        default public MllpComponentBuilder idleTimeoutStrategy(MllpIdleTimeoutStrategy idleTimeoutStrategy) {
            this.doSetProperty("idleTimeoutStrategy", idleTimeoutStrategy);
            return this;
        }

        default public MllpComponentBuilder keepAlive(Boolean keepAlive) {
            this.doSetProperty("keepAlive", keepAlive);
            return this;
        }

        default public MllpComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public MllpComponentBuilder tcpNoDelay(Boolean tcpNoDelay) {
            this.doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }

        default public MllpComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public MllpComponentBuilder defaultCharset(String defaultCharset) {
            this.doSetProperty("defaultCharset", defaultCharset);
            return this;
        }

        default public MllpComponentBuilder logPhi(Boolean logPhi) {
            this.doSetProperty("logPhi", logPhi);
            return this;
        }

        default public MllpComponentBuilder logPhiMaxBytes(Integer logPhiMaxBytes) {
            this.doSetProperty("logPhiMaxBytes", logPhiMaxBytes);
            return this;
        }

        default public MllpComponentBuilder readTimeout(int readTimeout) {
            this.doSetProperty("readTimeout", readTimeout);
            return this;
        }

        default public MllpComponentBuilder receiveBufferSize(Integer receiveBufferSize) {
            this.doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }

        default public MllpComponentBuilder receiveTimeout(int receiveTimeout) {
            this.doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }

        default public MllpComponentBuilder sendBufferSize(Integer sendBufferSize) {
            this.doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }

        default public MllpComponentBuilder idleTimeout(Integer idleTimeout) {
            this.doSetProperty("idleTimeout", idleTimeout);
            return this;
        }
    }
}

