/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cometd;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cometd.CometdBinding;
import org.apache.camel.component.cometd.CometdComponent;
import org.apache.camel.component.cometd.CometdConsumer;
import org.apache.camel.component.cometd.CometdProducer;
import org.apache.camel.component.cometd.CometdProducerConsumer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.0.0", scheme="cometd,cometds", title="CometD", syntax="cometd:host:port/channelName", category={Category.NETWORKING, Category.MESSAGING}, headersClass=CometdBinding.class)
public class CometdEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    private CometdComponent component;
    private URI uri;
    @UriPath(description="Hostname")
    @Metadata(required=true)
    private String host;
    @UriPath(description="Host port number")
    @Metadata(required=true)
    private int port;
    @UriPath(description="The channelName represents a topic that can be subscribed to by the Camel endpoints.")
    @Metadata(required=true)
    private String channelName;
    @UriParam
    private String baseResource;
    @UriParam(defaultValue="240000")
    private int timeout = 240000;
    @UriParam
    private int interval;
    @UriParam(defaultValue="30000")
    private int maxInterval = 30000;
    @UriParam(defaultValue="1500")
    private int multiFrameInterval = 1500;
    @UriParam(defaultValue="true")
    private boolean jsonCommented = true;
    @UriParam(label="consumer")
    private boolean sessionHeadersEnabled;
    @UriParam(defaultValue="1", enums="0,1,2")
    private int logLevel = 1;
    @UriParam
    private boolean crossOriginFilterOn;
    @UriParam(defaultValue="*")
    private String allowedOrigins;
    @UriParam
    private String filterPath;
    @UriParam(label="producer")
    private boolean disconnectLocalSession;

    public CometdEndpoint(CometdComponent component, String uri, String remaining) {
        super(uri, (Component)component);
        this.component = component;
        try {
            this.uri = new URI(uri);
            this.host = this.uri.getHost();
            this.port = this.uri.getPort();
            this.channelName = remaining;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getServiceUrl() {
        return this.getProtocol() + ":" + this.host + ":" + this.getPort();
    }

    public String getServiceProtocol() {
        return this.getProtocol();
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)((Object)this.component), (String)"component");
        return new CometdProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)((Object)this.component), (String)"component");
        CometdConsumer consumer = new CometdConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public void connect(CometdProducerConsumer prodcons) throws Exception {
        this.component.connect(prodcons);
    }

    public void disconnect(CometdProducerConsumer prodcons) throws Exception {
        this.component.disconnect(prodcons);
    }

    public CometdComponent getComponent() {
        return this.component;
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public int getPort() {
        if (this.uri.getPort() == -1) {
            if ("cometds".equals(this.getProtocol())) {
                return 443;
            }
            return 80;
        }
        return this.uri.getPort();
    }

    public String getProtocol() {
        return this.uri.getScheme();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getBaseResource() {
        return this.baseResource;
    }

    public void setBaseResource(String baseResource) {
        this.baseResource = baseResource;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public int getMaxInterval() {
        return this.maxInterval;
    }

    public void setMaxInterval(int maxInterval) {
        this.maxInterval = maxInterval;
    }

    public int getMultiFrameInterval() {
        return this.multiFrameInterval;
    }

    public void setMultiFrameInterval(int multiFrameInterval) {
        this.multiFrameInterval = multiFrameInterval;
    }

    public boolean isJsonCommented() {
        return this.jsonCommented;
    }

    public void setJsonCommented(boolean commented) {
        this.jsonCommented = commented;
    }

    public void setSessionHeadersEnabled(boolean enable) {
        this.sessionHeadersEnabled = enable;
    }

    public boolean isSessionHeadersEnabled() {
        return this.sessionHeadersEnabled;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public String getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(String allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public boolean isCrossOriginFilterOn() {
        return this.crossOriginFilterOn;
    }

    public void setCrossOriginFilterOn(boolean crossOriginFilterOn) {
        this.crossOriginFilterOn = crossOriginFilterOn;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public void setFilterPath(String filterPath) {
        this.filterPath = filterPath;
    }

    public boolean isDisconnectLocalSession() {
        return this.disconnectLocalSession;
    }

    public void setDisconnectLocalSession(boolean disconnectLocalSession) {
        this.disconnectLocalSession = disconnectLocalSession;
    }
}

