/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.coap;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.coap.CoAPEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.HostUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.CertificateAuthenticationMode;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.TcpConfig;
import org.eclipse.californium.elements.tcp.netty.TcpServerConnector;
import org.eclipse.californium.elements.tcp.netty.TlsServerConnector;
import org.eclipse.californium.scandium.DTLSConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="coap,coaps,coap+tcp,coaps+tcp")
public class CoAPComponent
extends DefaultComponent
implements RestConsumerFactory {
    static final int DEFAULT_PORT = 5684;
    private static final Logger LOG = LoggerFactory.getLogger(CoAPComponent.class);
    @Metadata
    private String configurationFile;
    final Map<Integer, CoapServer> servers = new ConcurrentHashMap<Integer, CoapServer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoapServer getServer(int port, CoAPEndpoint endpoint) throws IOException, GeneralSecurityException {
        this.lock.lock();
        try {
            CoapServer server = this.servers.get(port);
            if (server == null && port == -1) {
                server = this.getServer(5684, endpoint);
            }
            if (server == null) {
                CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
                Configuration config = this.loadConfiguration();
                builder.setConfiguration(config);
                InetSocketAddress address = new InetSocketAddress(port);
                if (CoAPEndpoint.enableDTLS(endpoint.getUri())) {
                    CoAPComponent.doEnableDTLS(endpoint, config, address, builder);
                } else if (CoAPEndpoint.enableTCP(endpoint.getUri())) {
                    this.doEnableTCP(endpoint, config, address, builder);
                } else {
                    builder.setInetSocketAddress(address);
                }
                server = new CoapServer();
                server.addEndpoint((org.eclipse.californium.core.network.Endpoint)builder.build());
                this.servers.put(port, server);
                if (this.isStarted()) {
                    server.start();
                }
            }
            CoapServer coapServer = server;
            return coapServer;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Configuration loadConfiguration() throws IOException {
        Configuration config;
        if (this.configurationFile != null) {
            InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)this.configurationFile);
            config = Configuration.createStandardFromStream((InputStream)is);
        } else {
            config = Configuration.createStandardWithoutFile();
        }
        return config;
    }

    private void doEnableTCP(CoAPEndpoint endpoint, Configuration config, InetSocketAddress address, CoapEndpoint.Builder coapBuilder) throws GeneralSecurityException, IOException {
        TcpServerConnector tcpConnector = endpoint.getUri().getScheme().startsWith("coaps") ? this.doEnableTLSTCP(endpoint, config, address) : new TcpServerConnector(address, config);
        coapBuilder.setConnector((Connector)tcpConnector);
    }

    private TcpServerConnector doEnableTLSTCP(CoAPEndpoint endpoint, Configuration config, InetSocketAddress address) throws GeneralSecurityException, IOException {
        SSLContext sslContext = endpoint.getSslContextParameters().createSSLContext(this.getCamelContext());
        if (endpoint.isClientAuthenticationRequired()) {
            config.set((BasicDefinition)TcpConfig.TLS_CLIENT_AUTHENTICATION_MODE, (Object)CertificateAuthenticationMode.NEEDED);
        } else if (endpoint.isClientAuthenticationWanted()) {
            config.set((BasicDefinition)TcpConfig.TLS_CLIENT_AUTHENTICATION_MODE, (Object)CertificateAuthenticationMode.WANTED);
        } else {
            config.set((BasicDefinition)TcpConfig.TLS_CLIENT_AUTHENTICATION_MODE, (Object)CertificateAuthenticationMode.NONE);
        }
        TlsServerConnector tcpConnector = new TlsServerConnector(sslContext, address, config);
        return tcpConnector;
    }

    private static void doEnableDTLS(CoAPEndpoint endpoint, Configuration config, InetSocketAddress address, CoapEndpoint.Builder coapBuilder) throws IOException {
        DTLSConnector connector = endpoint.createDTLSConnector(address, false, config);
        coapBuilder.setConnector((Connector)connector);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CoAPEndpoint endpoint = new CoAPEndpoint(uri, this);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        String contextPath;
        Object path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? (String)path + uriTemplate : (String)path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        RestConfiguration config = configuration;
        if (config == null) {
            config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), (String)"coap");
        }
        if (config.isEnableCORS()) {
            LOG.info("CORS configuration will be ignored as CORS is not supported by the CoAP component");
        }
        String host = CoAPComponent.doGetHost(config);
        HashMap map = new HashMap();
        if (config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        String scheme = config.getScheme() == null ? "coap" : config.getScheme();
        String query = URISupport.createQueryString(map);
        int port = 0;
        int num = config.getPort();
        if (num > 0) {
            port = num;
        }
        if (ObjectHelper.isNotEmpty((String)(contextPath = config.getContextPath()))) {
            contextPath = FileUtil.stripTrailingSeparator((String)contextPath);
            if (ObjectHelper.isNotEmpty((String)(contextPath = FileUtil.stripLeadingSeparator((String)contextPath)))) {
                path = contextPath + "/" + (String)path;
            }
        }
        String restrict = verb.toUpperCase(Locale.US);
        Object url = String.format("%s://%s:%d/%s?coapMethodRestrict=%s", scheme, host, port, path, restrict);
        if (!query.isEmpty()) {
            url = (String)url + "&" + query;
        }
        CoAPEndpoint endpoint = (CoAPEndpoint)camelContext.getEndpoint((String)url, parameters);
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(camelContext, consumer, config.getConsumerProperties());
        }
        return consumer;
    }

    private static String doGetHost(RestConfiguration config) throws UnknownHostException {
        String host = config.getHost();
        if (ObjectHelper.isEmpty((String)host)) {
            if (config.getHostNameResolver() == RestConfiguration.RestHostNameResolver.allLocalIp) {
                host = "0.0.0.0";
            } else if (config.getHostNameResolver() == RestConfiguration.RestHostNameResolver.localHostName) {
                host = HostUtils.getLocalHostName();
            } else if (config.getHostNameResolver() == RestConfiguration.RestHostNameResolver.localIp) {
                host = HostUtils.getLocalIp();
            }
        }
        return host;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public void setConfigurationFile(String configurationFile) {
        this.configurationFile = configurationFile;
    }

    protected void doStart() throws Exception {
        super.doStart();
        for (CoapServer s : this.servers.values()) {
            s.start();
        }
    }

    protected void doStop() throws Exception {
        for (CoapServer s : this.servers.values()) {
            s.stop();
        }
        super.doStop();
    }
}

