/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cloudevents.transformer;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.cloudevents.CloudEvent;
import org.apache.camel.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;
import org.apache.camel.support.MessageHelper;

@DataTypeTransformer(name="application-cloudevents+json", description="Adds default CloudEvent (JSon binding) headers to the Camel message (such as content-type, event source, event type etc.)")
public class CloudEventJsonDataTypeTransformer
extends Transformer {
    public static final String APPLICATION_CLOUDEVENTS_JSON = "application/cloudevents+json";
    public static final String APPLICATION_JSON = "application/json";

    public void transform(Message message, DataType fromType, DataType toType) {
        Map headers = message.getHeaders();
        String dataContentType = headers.getOrDefault("Content-Type", APPLICATION_JSON).toString();
        if (!APPLICATION_CLOUDEVENTS_JSON.equals(dataContentType)) {
            HashMap<String, Object> cloudEventAttributes = new HashMap<String, Object>();
            CloudEvents cloudEvent = CloudEvents.v1_0;
            for (CloudEvent.Attribute attribute : cloudEvent.attributes()) {
                if (!headers.containsKey(attribute.id())) continue;
                cloudEventAttributes.put(attribute.json(), headers.get(attribute.id()));
            }
            cloudEventAttributes.putIfAbsent(cloudEvent.mandatoryAttribute("CamelCloudEventVersion").json(), cloudEvent.version());
            cloudEventAttributes.putIfAbsent(cloudEvent.mandatoryAttribute("CamelCloudEventID").json(), message.getExchange().getExchangeId());
            cloudEventAttributes.putIfAbsent(cloudEvent.mandatoryAttribute("CamelCloudEventType").json(), "org.apache.camel.event");
            cloudEventAttributes.putIfAbsent(cloudEvent.mandatoryAttribute("CamelCloudEventSource").json(), "org.apache.camel");
            cloudEventAttributes.putIfAbsent(cloudEvent.mandatoryAttribute("CamelCloudEventTime").json(), cloudEvent.getEventTime(message.getExchange()));
            String body = MessageHelper.extractBodyAsString((Message)message);
            cloudEventAttributes.putIfAbsent("data", body);
            cloudEventAttributes.putIfAbsent(cloudEvent.mandatoryAttribute("CamelCloudEventDataContentType").json(), dataContentType);
            headers.put("Content-Type", APPLICATION_CLOUDEVENTS_JSON);
            message.setBody((Object)this.createCouldEventJsonObject(cloudEventAttributes));
            cloudEvent.attributes().stream().map(CloudEvent.Attribute::id).forEach(headers::remove);
        }
    }

    private String createCouldEventJsonObject(Map<String, Object> cloudEventAttributes) {
        StringBuilder builder = new StringBuilder("{");
        cloudEventAttributes.forEach((key, value) -> {
            if ("data".equals(key) && value instanceof String) {
                String data = (String)value;
                if (this.isJson(data)) {
                    builder.append(" ").append("\"").append((String)key).append("\"").append(":").append(data).append(",");
                } else {
                    builder.append(" ").append("\"").append((String)key).append("\"").append(":").append("\"").append(data).append("\"").append(",");
                }
            } else {
                builder.append(" ").append("\"").append((String)key).append("\"").append(":").append("\"").append(value).append("\"").append(",");
            }
        });
        if (!cloudEventAttributes.isEmpty()) {
            builder.deleteCharAt(builder.lastIndexOf(","));
        }
        return builder.append("}").toString();
    }

    private boolean isJson(String data) {
        if (data == null || data.isEmpty()) {
            return false;
        }
        return data.trim().startsWith("{") || data.trim().startsWith("[");
    }
}

