/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.CamelCatalogJSonSchemaResolver;
import org.apache.camel.catalog.DefaultRuntimeProvider;
import org.apache.camel.catalog.DefaultVersionManager;
import org.apache.camel.catalog.RuntimeProvider;
import org.apache.camel.catalog.VersionHelper;
import org.apache.camel.catalog.VersionManager;
import org.apache.camel.catalog.impl.AbstractCachingCamelCatalog;
import org.apache.camel.catalog.impl.CatalogHelper;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.DevConsoleModel;
import org.apache.camel.tooling.model.EipModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.MainModel;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.tooling.model.PojoBeanModel;
import org.apache.camel.tooling.model.ReleaseModel;
import org.apache.camel.tooling.model.TransformerModel;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

public class DefaultCamelCatalog
extends AbstractCachingCamelCatalog
implements CamelCatalog {
    private static final String MODELS_CATALOG = "org/apache/camel/catalog/models.properties";
    private static final String SCHEMAS_XML = "org/apache/camel/catalog/schemas";
    private static final String MAIN_DIR = "org/apache/camel/catalog/main";
    private static final String BASE_RESOURCE_DIR = "org/apache/camel/catalog";
    public static final String FIND_COMPONENT_NAMES = "findComponentNames";
    public static final String FIND_COMPONENT_LABELS = "findComponentLabels";
    public static final String LIST_COMPONENTS_AS_JSON = "listComponentsAsJson";
    public static final String FIND_DATA_FORMAT_NAMES = "findDataFormatNames";
    public static final String FIND_DATA_FORMAT_LABELS = "findDataFormatLabels";
    public static final String LIST_DATA_FORMATS_AS_JSON = "listDataFormatsAsJson";
    public static final String FIND_LANGUAGE_NAMES = "findLanguageNames";
    public static final String FIND_LANGUAGE_LABELS = "findLanguageLabels";
    public static final String LIST_LANGUAGES_AS_JSON = "listLanguagesAsJson";
    public static final String FIND_TRANSFORMER_NAMES = "findTransformerNames";
    public static final String LIST_TRANSFORMERS_AS_JSON = "listTransformersAsJson";
    public static final String FIND_CONSOLE_NAMES = "findConsoleNames";
    public static final String LIST_CONSOLES_AS_JSON = "listConsolesAsJson";
    public static final String FIND_MODEL_NAMES = "findModelNames";
    public static final String FIND_MODEL_LABELS = "findModelLabels";
    public static final String LIST_MODELS_AS_JSON = "listModelsAsJson";
    public static final String FIND_OTHER_NAMES = "findOtherNames";
    public static final String FIND_OTHER_LABELS = "findOtherLabels";
    public static final String LIST_OTHERS_AS_JSON = "listOthersAsJson";
    public static final String FIND_BEAN_NAMES = "findBeanNames";
    public static final String LIST_BEANS_AS_JSON = "listBeansAsJson";
    public static final String SUMMARY_AS_JSON = "summaryAsJson";
    private final VersionHelper version = new VersionHelper();
    private final Map<String, String> extraComponents = new HashMap<String, String>();
    private final Map<String, String> extraComponentsJSonSchema = new HashMap<String, String>();
    private final Map<String, String> extraDataFormats = new HashMap<String, String>();
    private final Map<String, String> extraDataFormatsJSonSchema = new HashMap<String, String>();
    private VersionManager versionManager = new DefaultVersionManager(this);
    private RuntimeProvider runtimeProvider = new DefaultRuntimeProvider(this);

    public DefaultCamelCatalog() {
        this(false);
    }

    public DefaultCamelCatalog(boolean caching) {
        super(caching);
        this.setJSonSchemaResolver(new CamelCatalogJSonSchemaResolver(this, this.extraComponents, this.extraComponentsJSonSchema, this.extraDataFormats, this.extraDataFormatsJSonSchema));
    }

    @Override
    public RuntimeProvider getRuntimeProvider() {
        return this.runtimeProvider;
    }

    @Override
    public void setRuntimeProvider(RuntimeProvider runtimeProvider) {
        this.runtimeProvider = runtimeProvider;
        this.runtimeProvider.setCamelCatalog(this);
        super.clearCache();
    }

    @Override
    public void enableCache() {
        super.setCaching(true);
    }

    @Override
    public boolean isCaching() {
        return super.isCaching();
    }

    @Override
    public void setVersionManager(VersionManager versionManager) {
        this.versionManager = versionManager;
    }

    @Override
    public VersionManager getVersionManager() {
        return this.versionManager;
    }

    @Override
    public void addComponent(String name, String className) {
        this.extraComponents.put(name, className);
        this.getCache().remove(FIND_COMPONENT_NAMES);
        this.getCache().remove(FIND_COMPONENT_LABELS);
        this.getCache().remove(LIST_COMPONENTS_AS_JSON);
        this.getCache().remove(SUMMARY_AS_JSON);
    }

    @Override
    public void addComponent(String name, String className, String jsonSchema) {
        this.addComponent(name, className);
        if (jsonSchema != null) {
            this.extraComponentsJSonSchema.put(name, jsonSchema);
        }
    }

    @Override
    public void addDataFormat(String name, String className) {
        this.extraDataFormats.put(name, className);
        this.getCache().remove(FIND_DATA_FORMAT_NAMES);
        this.getCache().remove(FIND_DATA_FORMAT_LABELS);
        this.getCache().remove(LIST_DATA_FORMATS_AS_JSON);
        this.getCache().remove(SUMMARY_AS_JSON);
    }

    @Override
    public void addDataFormat(String name, String className, String jsonSchema) {
        this.addDataFormat(name, className);
        if (jsonSchema != null) {
            this.extraDataFormatsJSonSchema.put(name, jsonSchema);
        }
    }

    @Override
    public String getCatalogVersion() {
        return this.version.getVersion();
    }

    @Override
    public boolean loadVersion(String version) {
        if (version.equals(this.versionManager.getLoadedVersion())) {
            return true;
        }
        if (this.versionManager.loadVersion(version)) {
            super.clearCache();
            return true;
        }
        return false;
    }

    @Override
    public String getLoadedVersion() {
        return this.versionManager.getLoadedVersion();
    }

    @Override
    public String getRuntimeProviderLoadedVersion() {
        return this.versionManager.getRuntimeProviderLoadedVersion();
    }

    @Override
    public boolean loadRuntimeProviderVersion(String groupId, String artifactId, String version) {
        return this.versionManager.loadRuntimeProviderVersion(groupId, artifactId, version);
    }

    @Override
    public List<String> findComponentNames() {
        return (List)this.cache(FIND_COMPONENT_NAMES, () -> Stream.of(this.runtimeProvider.findComponentNames(), this.extraComponents.keySet()).flatMap(Collection::stream).sorted().toList());
    }

    @Override
    public List<String> findDataFormatNames() {
        return (List)this.cache(FIND_DATA_FORMAT_NAMES, () -> Stream.of(this.runtimeProvider.findDataFormatNames(), this.extraDataFormats.keySet()).flatMap(Collection::stream).sorted().toList());
    }

    @Override
    public List<String> findLanguageNames() {
        return (List)this.cache(FIND_LANGUAGE_NAMES, this.runtimeProvider::findLanguageNames);
    }

    @Override
    public List<String> findTransformerNames() {
        return (List)this.cache(FIND_TRANSFORMER_NAMES, this.runtimeProvider::findTransformerNames);
    }

    @Override
    public List<String> findDevConsoleNames() {
        return (List)this.cache(FIND_CONSOLE_NAMES, this.runtimeProvider::findDevConsoleNames);
    }

    @Override
    public List<String> findModelNames() {
        return (List)this.cache(FIND_MODEL_NAMES, () -> {
            List list;
            block8: {
                InputStream is = this.versionManager.getResourceAsStream(MODELS_CATALOG);
                try {
                    list = CatalogHelper.loadLines((InputStream)is);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return Collections.emptyList();
                    }
                }
                is.close();
            }
            return list;
        });
    }

    @Override
    public List<String> findOtherNames() {
        return (List)this.cache(FIND_OTHER_NAMES, this.runtimeProvider::findOtherNames);
    }

    @Override
    public List<String> findBeansNames() {
        return (List)this.cache(FIND_BEAN_NAMES, this.runtimeProvider::findBeansNames);
    }

    @Override
    public List<String> findModelNames(String filter) {
        return this.findNames(filter, this::findModelNames, this::eipModel);
    }

    @Override
    public List<String> findComponentNames(String filter) {
        return this.findNames(filter, this::findComponentNames, this::componentModel);
    }

    @Override
    public List<String> findDataFormatNames(String filter) {
        return this.findNames(filter, this::findDataFormatNames, this::dataFormatModel);
    }

    @Override
    public List<String> findLanguageNames(String filter) {
        return this.findNames(filter, this::findLanguageNames, this::languageModel);
    }

    @Override
    public List<String> findOtherNames(String filter) {
        return this.findNames(filter, this::findOtherNames, this::otherModel);
    }

    private List<String> findNames(String filter, Supplier<List<String>> findNames, Function<String, ? extends BaseModel<?>> modelLoader) {
        ArrayList<String> answer = new ArrayList<String>();
        List<String> names = findNames.get();
        for (String name : names) {
            String[] parts;
            BaseModel<?> model = modelLoader.apply(name);
            if (model == null) continue;
            String label = model.getLabel();
            for (String part : parts = label.split(",")) {
                try {
                    if (!part.equalsIgnoreCase(filter) && !CatalogHelper.matchWildcard((String)part, (String)filter) && !part.matches(filter)) continue;
                    answer.add(name);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
        }
        return answer;
    }

    @Override
    public String modelJSonSchema(String name) {
        return (String)this.cache("eip-" + name, name, x$0 -> super.modelJSonSchema(x$0));
    }

    @Override
    public EipModel eipModel(String name) {
        return (EipModel)this.cache("eip-model-" + name, name, x$0 -> super.eipModel(x$0));
    }

    @Override
    public PojoBeanModel pojoBeanModel(String name) {
        return (PojoBeanModel)this.cache("pojo-bean-model-" + name, name, x$0 -> super.pojoBeanModel(x$0));
    }

    @Override
    public String componentJSonSchema(String name) {
        return (String)this.cache("component-" + name, name, x$0 -> super.componentJSonSchema(x$0));
    }

    @Override
    public ComponentModel componentModel(String name) {
        return (ComponentModel)this.cache("component-model-" + name, name, x$0 -> super.componentModel(x$0));
    }

    @Override
    public String dataFormatJSonSchema(String name) {
        return (String)this.cache("dataformat-" + name, name, x$0 -> super.dataFormatJSonSchema(x$0));
    }

    @Override
    public DataFormatModel dataFormatModel(String name) {
        return (DataFormatModel)this.cache("dataformat-model-" + name, name, x$0 -> super.dataFormatModel(x$0));
    }

    @Override
    public String languageJSonSchema(String name) {
        return (String)this.cache("language-" + name, name, x$0 -> super.languageJSonSchema(x$0));
    }

    @Override
    public String transformerJSonSchema(String name) {
        return (String)this.cache("transformer-" + name, name, x$0 -> super.transformerJSonSchema(x$0));
    }

    public String devConsoleJSonSchema(String name) {
        return (String)this.cache("dev-console-" + name, name, x$0 -> super.devConsoleJSonSchema(x$0));
    }

    @Override
    public LanguageModel languageModel(String name) {
        return (LanguageModel)this.cache("language-model-" + name, name, x$0 -> super.languageModel(x$0));
    }

    @Override
    public TransformerModel transformerModel(String name) {
        return (TransformerModel)this.cache("transformer-model-" + name, name, x$0 -> super.transformerModel(x$0));
    }

    @Override
    public DevConsoleModel devConsoleModel(String name) {
        return (DevConsoleModel)this.cache("dev-console-model-" + name, name, x$0 -> super.devConsoleModel(x$0));
    }

    @Override
    public String otherJSonSchema(String name) {
        return (String)this.cache("other-" + name, name, x$0 -> super.otherJSonSchema(x$0));
    }

    @Override
    public OtherModel otherModel(String name) {
        return (OtherModel)this.cache("other-model-" + name, name, x$0 -> super.otherModel(x$0));
    }

    public String mainJSonSchema() {
        return (String)this.cache("main", "main", k -> super.mainJSonSchema());
    }

    @Override
    public MainModel mainModel() {
        return (MainModel)this.cache("main-model", "main-model", k -> super.mainModel());
    }

    @Override
    public Set<String> findModelLabels() {
        return (Set)this.cache(FIND_MODEL_LABELS, () -> this.findLabels(this::findModelNames, this::eipModel));
    }

    @Override
    public Set<String> findComponentLabels() {
        return (Set)this.cache(FIND_COMPONENT_LABELS, () -> this.findLabels(this::findComponentNames, this::componentModel));
    }

    @Override
    public Set<String> findDataFormatLabels() {
        return (Set)this.cache(FIND_DATA_FORMAT_LABELS, () -> this.findLabels(this::findDataFormatNames, this::dataFormatModel));
    }

    @Override
    public Set<String> findLanguageLabels() {
        return (Set)this.cache(FIND_LANGUAGE_LABELS, () -> this.findLabels(this::findLanguageNames, this::languageModel));
    }

    @Override
    public Set<String> findOtherLabels() {
        return (Set)this.cache(FIND_OTHER_LABELS, () -> this.findLabels(this::findOtherNames, this::otherModel));
    }

    private SortedSet<String> findLabels(Supplier<List<String>> findNames, Function<String, ? extends BaseModel<?>> loadModel) {
        TreeSet<String> answer = new TreeSet<String>();
        List<String> names = findNames.get();
        for (String name : names) {
            BaseModel<?> model = loadModel.apply(name);
            if (model == null) continue;
            String label = model.getLabel();
            String[] parts = label.split(",");
            Collections.addAll(answer, parts);
        }
        return answer;
    }

    @Override
    public String springSchemaAsXml() {
        return (String)this.cache("org/apache/camel/catalog/schemas/camel-spring.xsd", this::loadResource);
    }

    @Override
    public String xmlIoSchemaAsXml() {
        return (String)this.cache("org/apache/camel/catalog/schemas/camel-xml-io.xsd", this::loadResource);
    }

    @Override
    public String mainJsonSchema() {
        return (String)this.cache("org/apache/camel/catalog/main/camel-main-configuration-metadata.json", this::loadResource);
    }

    @Override
    public String listComponentsAsJson() {
        return (String)this.cache(LIST_COMPONENTS_AS_JSON, () -> JsonMapper.serialize(this.findComponentNames().stream().map(this::componentJSonSchema).map(JsonMapper::deserialize).map(o -> o.get((Object)"component")).toList()));
    }

    @Override
    public String listDataFormatsAsJson() {
        return (String)this.cache(LIST_DATA_FORMATS_AS_JSON, () -> JsonMapper.serialize(this.findDataFormatNames().stream().map(this::dataFormatJSonSchema).map(JsonMapper::deserialize).map(o -> o.get((Object)"dataformat")).toList()));
    }

    @Override
    public String listLanguagesAsJson() {
        return (String)this.cache(LIST_LANGUAGES_AS_JSON, () -> JsonMapper.serialize(this.findLanguageNames().stream().map(this::languageJSonSchema).map(JsonMapper::deserialize).map(o -> o.get((Object)"language")).toList()));
    }

    @Override
    public String listTransformersAsJson() {
        return (String)this.cache(LIST_TRANSFORMERS_AS_JSON, () -> JsonMapper.serialize(this.findTransformerNames().stream().map(this::transformerJSonSchema).map(JsonMapper::deserialize).map(o -> o.get((Object)"transformer")).toList()));
    }

    @Override
    public String listDevConsolesAsJson() {
        return (String)this.cache(LIST_CONSOLES_AS_JSON, () -> JsonMapper.serialize(this.findDevConsoleNames().stream().map(this::devConsoleJSonSchema).map(JsonMapper::deserialize).map(o -> o.get((Object)"console")).toList()));
    }

    @Override
    public String listModelsAsJson() {
        return (String)this.cache(LIST_MODELS_AS_JSON, () -> JsonMapper.serialize(this.findModelNames().stream().map(this::modelJSonSchema).map(JsonMapper::deserialize).map(o -> o.get((Object)"model")).toList()));
    }

    @Override
    public String listOthersAsJson() {
        return (String)this.cache(LIST_OTHERS_AS_JSON, () -> JsonMapper.serialize(this.findOtherNames().stream().map(this::otherJSonSchema).map(JsonMapper::deserialize).map(o -> o.get((Object)"other")).toList()));
    }

    @Override
    public String summaryAsJson() {
        return (String)this.cache(SUMMARY_AS_JSON, () -> {
            JsonObject obj = new JsonObject();
            obj.put("version", this.getLoadedVersion());
            obj.put("models", this.findModelNames().size());
            obj.put("components", this.findComponentNames().size());
            obj.put("dataformats", this.findDataFormatNames().size());
            obj.put("languages", this.findLanguageNames().size());
            obj.put("others", this.findOtherNames().size());
            obj.put("beans", this.findBeansNames().size());
            obj.put("dev-consoles", this.findDevConsoleNames().size());
            obj.put("transformers", this.findTransformerNames().size());
            return JsonMapper.serialize((Object)obj);
        });
    }

    @Override
    public ArtifactModel<?> modelFromMavenGAV(String groupId, String artifactId, String version) {
        ComponentModel am;
        try {
            for (String name : this.findComponentNames()) {
                am = this.componentModel(name);
                if (!DefaultCamelCatalog.matchArtifact(am, groupId, artifactId, version)) continue;
                return am;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            for (String name : this.findDataFormatNames()) {
                am = this.dataFormatModel(name);
                if (!DefaultCamelCatalog.matchArtifact(am, groupId, artifactId, version)) continue;
                return am;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            for (String name : this.findLanguageNames()) {
                am = this.languageModel(name);
                if (!DefaultCamelCatalog.matchArtifact(am, groupId, artifactId, version)) continue;
                return am;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            for (String name : this.findOtherNames()) {
                am = this.otherModel(name);
                if (!DefaultCamelCatalog.matchArtifact(am, groupId, artifactId, version)) continue;
                return am;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            for (String name : this.findTransformerNames()) {
                am = this.transformerModel(name);
                if (!DefaultCamelCatalog.matchArtifact(am, groupId, artifactId, version)) continue;
                return am;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            for (String name : this.findDevConsoleNames()) {
                am = this.devConsoleModel(name);
                if (!DefaultCamelCatalog.matchArtifact(am, groupId, artifactId, version)) continue;
                return am;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            for (String name : this.findBeansNames()) {
                am = this.pojoBeanModel(name);
                if (!DefaultCamelCatalog.matchArtifact(am, groupId, artifactId, version)) continue;
                return am;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public InputStream loadResource(String kind, String name) {
        return this.versionManager.getResourceAsStream("org/apache/camel/catalog/" + kind + "/" + name);
    }

    @Override
    public List<ReleaseModel> camelReleases() {
        return this.camelReleases("camel-releases.json");
    }

    @Override
    public List<ReleaseModel> camelQuarkusReleases() {
        return this.camelReleases("camel-quarkus-releases.json");
    }

    private List<ReleaseModel> camelReleases(String file) {
        return (List)this.cache(file, () -> {
            try {
                ArrayList<ReleaseModel> answer = new ArrayList<ReleaseModel>();
                InputStream is = this.loadResource("releases", file);
                String json = CatalogHelper.loadText((InputStream)is);
                JsonArray arr = (JsonArray)Jsoner.deserialize((String)json);
                for (Object o : arr) {
                    JsonObject jo = (JsonObject)o;
                    answer.add(JsonMapper.generateReleaseModel((JsonObject)jo));
                }
                return answer;
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        });
    }

    private static boolean matchArtifact(ArtifactModel<?> am, String groupId, String artifactId, String version) {
        if (am == null) {
            return false;
        }
        return groupId.equals(am.getGroupId()) && artifactId.equals(am.getArtifactId()) && (version == null || version.isBlank() || version.equals(am.getVersion()));
    }

    private String loadResource(String file) {
        String string;
        block8: {
            InputStream is = this.versionManager.getResourceAsStream(file);
            try {
                String string2 = string = is != null ? CatalogHelper.loadText((InputStream)is) : null;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            is.close();
        }
        return string;
    }
}

