/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.rest;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.io.Console;
import org.apache.camel.catalog.rest.CamelCatalogRest;
import org.apache.camel.catalog.rest.CamelConnectorCatalogRest;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.swagger.Swagger2Feature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelCatalogRestMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelCatalogRestMain.class);
    private Server server;
    private CamelCatalogRest catalog;
    private CamelConnectorCatalogRest connectorCatalog;
    private int port = 8080;

    public static void main(String[] args) {
        CamelCatalogRestMain me = new CamelCatalogRestMain();
        me.run();
    }

    public void run() {
        LOGGER.info("Starting ...");
        this.catalog = new CamelCatalogRest();
        this.connectorCatalog = new CamelConnectorCatalogRest();
        JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
        sf.setResourceClasses(new Class[]{CamelCatalogRest.class, CamelConnectorCatalogRest.class});
        sf.setResourceProvider(CamelCatalogRest.class, (ResourceProvider)new SingletonResourceProvider((Object)this.catalog));
        sf.setResourceProvider(CamelConnectorCatalogRest.class, (ResourceProvider)new SingletonResourceProvider((Object)this.connectorCatalog));
        Swagger2Feature swagger = new Swagger2Feature();
        swagger.setBasePath("/");
        swagger.setScanAllResources(false);
        swagger.setPrettyPrint(Boolean.valueOf(true));
        swagger.setSupportSwaggerUi(true);
        swagger.setTitle("Camel Catalog and Connector Catalog REST Api");
        swagger.setDescription("REST Api for the Camel Catalog and Connector Catalog");
        swagger.setVersion(this.catalog.getCatalogVersion());
        swagger.setContact("Apache Camel");
        sf.getFeatures().add(swagger);
        sf.setProvider(JacksonJsonProvider.class);
        sf.setAddress("http://localhost:" + this.port);
        this.server = sf.create();
        this.server.start();
        LOGGER.info("CamelCatalog REST Api started");
        LOGGER.info("");
        LOGGER.info("\tRest API base path: http://localhost:{}/camel-catalog", (Object)this.port);
        LOGGER.info("\tRest API version: http://localhost:{}/camel-catalog/catalogVersion", (Object)this.port);
        LOGGER.info("");
        LOGGER.info("CamelConnectorCatalog REST Api started");
        LOGGER.info("");
        LOGGER.info("\tRest API base path: http://localhost:{}/camel-connector-catalog", (Object)this.port);
        LOGGER.info("");
        LOGGER.info("\tSwagger Doc: http://localhost:{}/swagger.json", (Object)this.port);
        LOGGER.info("\tSwagger UI: http://localhost:{}/api-docs?url=/swagger.json", (Object)this.port);
        LOGGER.info("");
        LOGGER.info("Press Enter to stop");
        Console console = System.console();
        console.readLine();
        LOGGER.info("Stopping ...");
        this.server.stop();
        this.server.destroy();
        LOGGER.info("CamelCatalog REST Api stopped");
        System.exit(0);
    }
}

