/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine.resume;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.camel.resume.cache.ResumeCache;
import org.apache.camel.util.ObjectHelper;

public class CaffeineCache<K>
implements ResumeCache<K> {
    private final Cache<K, Object> cache;
    private final long cacheSize;

    public CaffeineCache(long cacheSize) {
        this(Caffeine.newBuilder().maximumSize(cacheSize).build(), cacheSize);
    }

    public CaffeineCache(Cache<K, Object> cache, long cacheSize) {
        this.cache = cache;
        this.cacheSize = cacheSize;
    }

    public boolean contains(K key, Object entry) {
        ObjectHelper.notNull(key, (String)"key");
        Object cachedEntry = this.cache.getIfPresent(key);
        return entry.equals(cachedEntry);
    }

    public void add(K key, Object offsetValue) {
        this.cache.put(key, offsetValue);
    }

    public Object get(K key) {
        Object entry = this.cache.getIfPresent(key);
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.of(entry);
    }

    public <T> T get(K key, Class<T> clazz) {
        Object entry = this.cache.getIfPresent(key);
        if (entry != null) {
            return clazz.cast(entry);
        }
        return null;
    }

    public Object computeIfAbsent(K key, Function<? super K, ? super Object> mapping) {
        Object entry = this.cache.getIfPresent(key);
        if (entry == null) {
            entry = mapping.apply(key);
            this.cache.put(key, entry);
        }
        return entry;
    }

    public Object computeIfPresent(K key, BiFunction<? super K, ? super Object, ? super Object> remapping) {
        Object entry = this.cache.getIfPresent(key);
        if (entry != null) {
            entry = remapping.apply(key, entry);
            this.cache.put(key, entry);
        }
        return entry;
    }

    public boolean isFull() {
        return this.cache.estimatedSize() >= this.cacheSize;
    }

    public long capacity() {
        return this.cacheSize;
    }

    public void forEach(BiFunction<? super K, ? super Object, Boolean> action) {
        ConcurrentMap kObjectConcurrentMap = this.cache.asMap();
        for (Map.Entry entry : kObjectConcurrentMap.entrySet()) {
            boolean invalidate = action.apply(entry.getKey(), entry.getValue());
            if (!invalidate) continue;
            this.cache.invalidate(entry.getKey());
        }
    }
}

