/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.internal;

import com.box.sdk.BoxFile;
import com.box.sdk.BoxFileVersion;
import com.box.sdk.BoxSharedLink;
import com.box.sdk.Metadata;
import com.box.sdk.ProgressListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.camel.component.box.api.BoxFilesManager;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

public enum BoxFilesManagerApiMethod implements ApiMethod
{
    CHECK_UPLOAD(Void.TYPE, "checkUpload", ApiMethodArg.arg((String)"fileName", String.class), ApiMethodArg.arg((String)"parentFolderId", String.class), ApiMethodArg.arg((String)"size", Long.class)),
    COPY_FILE(BoxFile.class, "copyFile", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"destinationFolderId", String.class), ApiMethodArg.arg((String)"newName", String.class)),
    CREATE_FILE_METADATA(Metadata.class, "createFileMetadata", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"metadata", Metadata.class), ApiMethodArg.arg((String)"typeName", String.class)),
    CREATE_FILE_SHARED_LINK(BoxSharedLink.class, "createFileSharedLink", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"access", BoxSharedLink.Access.class), ApiMethodArg.arg((String)"unshareDate", Date.class), ApiMethodArg.arg((String)"permissions", BoxSharedLink.Permissions.class)),
    DELETE_FILE(Void.TYPE, "deleteFile", ApiMethodArg.arg((String)"fileId", String.class)),
    DELETE_FILE_METADATA(Void.TYPE, "deleteFileMetadata", ApiMethodArg.arg((String)"fileId", String.class)),
    DELETE_FILE_VERSION(Void.TYPE, "deleteFileVersion", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"version", Integer.class)),
    DOWNLOAD_FILE(OutputStream.class, "downloadFile", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"output", OutputStream.class), ApiMethodArg.arg((String)"rangeStart", Long.class), ApiMethodArg.arg((String)"rangeEnd", Long.class), ApiMethodArg.arg((String)"listener", ProgressListener.class)),
    DOWNLOAD_PREVIOUS_FILE_VERSION(OutputStream.class, "downloadPreviousFileVersion", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"version", Integer.class), ApiMethodArg.arg((String)"output", OutputStream.class), ApiMethodArg.arg((String)"listener", ProgressListener.class)),
    GET_DOWNLOAD_URL(URL.class, "getDownloadURL", ApiMethodArg.arg((String)"fileId", String.class)),
    GET_FILE_INFO(BoxFile.Info.class, "getFileInfo", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"fields", new String[0].getClass())),
    GET_FILE_METADATA(Metadata.class, "getFileMetadata", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"typeName", String.class)),
    GET_FILE_PREVIEW_LINK(URL.class, "getFilePreviewLink", ApiMethodArg.arg((String)"fileId", String.class)),
    GET_FILE_VERSIONS(Collection.class, "getFileVersions", ApiMethodArg.arg((String)"fileId", String.class)),
    MOVE_FILE(BoxFile.class, "moveFile", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"destinationFolderId", String.class), ApiMethodArg.arg((String)"newName", String.class)),
    PROMOTE_FILE_VERSION(BoxFileVersion.class, "promoteFileVersion", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"version", Integer.class)),
    RENAME_FILE(BoxFile.class, "renameFile", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"newFileName", String.class)),
    UPDATE_FILE_INFO(BoxFile.class, "updateFileInfo", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"info", BoxFile.Info.class)),
    UPDATE_FILE_METADATA(Metadata.class, "updateFileMetadata", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"metadata", Metadata.class)),
    UPLOAD_FILE(BoxFile.class, "uploadFile", ApiMethodArg.arg((String)"parentFolderId", String.class), ApiMethodArg.arg((String)"content", InputStream.class), ApiMethodArg.arg((String)"fileName", String.class), ApiMethodArg.arg((String)"created", Date.class), ApiMethodArg.arg((String)"modified", Date.class), ApiMethodArg.arg((String)"size", Long.class), ApiMethodArg.arg((String)"check", Boolean.class), ApiMethodArg.arg((String)"listener", ProgressListener.class)),
    UPLOAD_NEW_FILE_VERSION(BoxFile.class, "uploadNewFileVersion", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"fileContent", InputStream.class), ApiMethodArg.arg((String)"modified", Date.class), ApiMethodArg.arg((String)"fileSize", Long.class), ApiMethodArg.arg((String)"listener", ProgressListener.class));

    private final ApiMethod apiMethod;

    private BoxFilesManagerApiMethod(Class<?> resultType, String name, ApiMethodArg ... args) {
        this.apiMethod = new ApiMethodImpl(BoxFilesManager.class, resultType, name, args);
    }

    public String getName() {
        return this.apiMethod.getName();
    }

    public Class<?> getResultType() {
        return this.apiMethod.getResultType();
    }

    public List<String> getArgNames() {
        return this.apiMethod.getArgNames();
    }

    public List<String> getSetterArgNames() {
        return this.apiMethod.getSetterArgNames();
    }

    public List<Class<?>> getArgTypes() {
        return this.apiMethod.getArgTypes();
    }

    public Method getMethod() {
        return this.apiMethod.getMethod();
    }
}

