/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bonita.api;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bonita.api.model.CaseCreationResponse;
import org.apache.camel.component.bonita.api.model.ProcessDefinitionResponse;
import org.apache.camel.component.bonita.api.util.BonitaAPIConfig;
import org.apache.camel.component.bonita.api.util.BonitaAPIUtil;
import org.apache.camel.util.ObjectHelper;

public class BonitaAPI {
    private BonitaAPIConfig bonitaApiConfig;
    private WebTarget webTarget;

    protected BonitaAPI(BonitaAPIConfig bonitaApiConfig, WebTarget webTarget) {
        this.bonitaApiConfig = bonitaApiConfig;
        this.webTarget = webTarget;
    }

    private WebTarget getBaseResource() {
        return this.webTarget;
    }

    public ProcessDefinitionResponse getProcessDefinition(String processName) {
        if (ObjectHelper.isEmpty((String)processName)) {
            throw new IllegalArgumentException("processName is empty.");
        }
        WebTarget resource = this.getBaseResource().path("process").queryParam("s", new Object[]{processName});
        List listProcess = (List)resource.request().accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<ProcessDefinitionResponse>>(){});
        if (!listProcess.isEmpty()) {
            return (ProcessDefinitionResponse)listProcess.get(0);
        }
        throw new RuntimeCamelException("The process with name " + processName + " has not been retrieved");
    }

    public CaseCreationResponse startCase(ProcessDefinitionResponse processDefinition, Map<String, Serializable> rawInputs) throws Exception {
        if (processDefinition == null) {
            throw new IllegalArgumentException("ProcessDefinition is null");
        }
        if (rawInputs == null) {
            throw new IllegalArgumentException("The contract input is null");
        }
        Map<String, Serializable> inputs = BonitaAPIUtil.getInstance(this.bonitaApiConfig).prepareInputs(processDefinition, rawInputs);
        WebTarget resource = this.getBaseResource().path("process/{processId}/instantiation").resolveTemplate("processId", (Object)processDefinition.getId());
        return (CaseCreationResponse)resource.request().accept(new String[]{"application/json"}).post(Entity.entity(inputs, (String)"application/json"), CaseCreationResponse.class);
    }

    public BonitaAPIConfig getBonitaApiConfig() {
        return this.bonitaApiConfig;
    }

    public void setBonitaApiConfig(BonitaAPIConfig bonitaApiConfig) {
        this.bonitaApiConfig = bonitaApiConfig;
    }
}

