/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import java.math.BigInteger;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.AbstractNumberFormat;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;

public class BigIntegerFormatFactory
extends AbstractFormatFactory {
    private final BigIntegerFormat bigIntegerFormat = new BigIntegerFormat();

    public BigIntegerFormatFactory() {
        this.supportedClasses.add(BigInteger.class);
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return this.bigIntegerFormat;
    }

    private static class BigIntegerFormat
    extends AbstractNumberFormat<BigInteger> {
        private BigIntegerFormat() {
        }

        @Override
        public String format(BigInteger object) throws Exception {
            return object.toString();
        }

        @Override
        public BigInteger parse(String string) throws Exception {
            return new BigInteger(string);
        }
    }
}

