/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.beanio;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.WrappedFile;
import org.apache.camel.dataformat.beanio.BeanIOConfiguration;
import org.apache.camel.dataformat.beanio.BeanIOHelper;
import org.apache.camel.dataformat.beanio.BeanIOIterator;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.beanio.BeanReader;
import org.beanio.BeanReaderErrorHandler;
import org.beanio.StreamFactory;

public class BeanIOSplitter
implements Expression {
    private BeanIOConfiguration configuration = new BeanIOConfiguration();
    private StreamFactory factory;

    public BeanIOSplitter() throws Exception {
    }

    public BeanIOSplitter(BeanIOConfiguration configuration) {
        this.configuration = configuration;
    }

    public BeanIOSplitter(String mapping, String streamName) {
        this.setMapping(mapping);
        this.setStreamName(streamName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamFactory createStreamFactory(CamelContext camelContext) throws Exception {
        ObjectHelper.notNull((Object)this.getStreamName(), (String)"Stream name not configured.");
        StreamFactory answer = StreamFactory.newInstance();
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)this.getMapping());
        try {
            if (this.getProperties() != null) {
                answer.load(is, this.getProperties());
            } else {
                answer.load(is);
            }
        }
        finally {
            IOHelper.close((Closeable)is);
        }
        return answer;
    }

    public Object evaluate(Exchange exchange) throws Exception {
        Message msg = exchange.getIn();
        Object body = msg.getBody();
        if (this.factory == null) {
            this.factory = this.createStreamFactory(exchange.getContext());
        }
        BeanReader beanReader = null;
        if (body instanceof WrappedFile) {
            body = ((WrappedFile)body).getFile();
        }
        if (body instanceof File) {
            File file = (File)body;
            beanReader = this.factory.createReader(this.getStreamName(), file);
        }
        if (beanReader == null) {
            Reader reader = (Reader)msg.getMandatoryBody(Reader.class);
            beanReader = this.factory.createReader(this.getStreamName(), reader);
        }
        BeanIOIterator iterator = new BeanIOIterator(beanReader);
        BeanReaderErrorHandler errorHandler = BeanIOHelper.getOrCreateBeanReaderErrorHandler(this.configuration, exchange, null, iterator);
        beanReader.setErrorHandler(errorHandler);
        return iterator;
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        try {
            Object result = this.evaluate(exchange);
            return (T)exchange.getContext().getTypeConverter().convertTo(type, exchange, result);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public BeanIOConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(BeanIOConfiguration configuration) {
        this.configuration = configuration;
    }

    public StreamFactory getFactory() {
        return this.factory;
    }

    public void setFactory(StreamFactory factory) {
        this.factory = factory;
    }

    public String getMapping() {
        return this.configuration.getMapping();
    }

    public void setIgnoreUnexpectedRecords(boolean ignoreUnexpectedRecords) {
        this.configuration.setIgnoreUnexpectedRecords(ignoreUnexpectedRecords);
    }

    public void setProperties(Properties properties) {
        this.configuration.setProperties(properties);
    }

    public void setStreamName(String streamName) {
        this.configuration.setStreamName(streamName);
    }

    public boolean isIgnoreUnidentifiedRecords() {
        return this.configuration.isIgnoreUnidentifiedRecords();
    }

    public boolean isIgnoreInvalidRecords() {
        return this.configuration.isIgnoreInvalidRecords();
    }

    public void setIgnoreInvalidRecords(boolean ignoreInvalidRecords) {
        this.configuration.setIgnoreInvalidRecords(ignoreInvalidRecords);
    }

    public void setEncoding(Charset encoding) {
        this.configuration.setEncoding(encoding);
    }

    public boolean isIgnoreUnexpectedRecords() {
        return this.configuration.isIgnoreUnexpectedRecords();
    }

    public Properties getProperties() {
        return this.configuration.getProperties();
    }

    public String getStreamName() {
        return this.configuration.getStreamName();
    }

    public void setMapping(String mapping) {
        this.configuration.setMapping(mapping);
    }

    public void setIgnoreUnidentifiedRecords(boolean ignoreUnidentifiedRecords) {
        this.configuration.setIgnoreUnidentifiedRecords(ignoreUnidentifiedRecords);
    }

    public Charset getEncoding() {
        return this.configuration.getEncoding();
    }

    public BeanReaderErrorHandler getBeanReaderErrorHandler() {
        return this.configuration.getBeanReaderErrorHandler();
    }

    public void setBeanReaderErrorHandler(BeanReaderErrorHandler beanReaderErrorHandler) {
        this.configuration.setBeanReaderErrorHandler(beanReaderErrorHandler);
    }

    public String getBeanReaderErrorHandlerType() {
        return this.configuration.getBeanReaderErrorHandlerType();
    }

    public void setBeanReaderErrorHandlerType(String beanReaderErrorHandlerType) {
        this.configuration.setBeanReaderErrorHandlerType(beanReaderErrorHandlerType);
    }

    public void setBeanReaderErrorHandlerType(Class<?> beanReaderErrorHandlerType) {
        this.configuration.setBeanReaderErrorHandlerType(beanReaderErrorHandlerType);
    }
}

