/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.beanio;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.beanio.BeanIOConfiguration;
import org.apache.camel.dataformat.beanio.BeanIOErrorHandler;
import org.apache.camel.dataformat.beanio.BeanIOIterator;
import org.apache.camel.util.ObjectHelper;
import org.beanio.BeanReaderErrorHandler;

public final class BeanIOHelper {
    private BeanIOHelper() {
    }

    public static BeanReaderErrorHandler getOrCreateBeanReaderErrorHandler(BeanIOConfiguration configuration, Exchange exchange, List<Object> results, BeanIOIterator iterator) throws Exception {
        BeanIOErrorHandler answer = null;
        if (ObjectHelper.isNotEmpty((String)configuration.getBeanReaderErrorHandlerType())) {
            Class clazz = exchange.getContext().getClassResolver().resolveMandatoryClass(configuration.getBeanReaderErrorHandlerType());
            Object instance = exchange.getContext().getInjector().newInstance(clazz);
            answer = (BeanReaderErrorHandler)instance;
        }
        if (answer == null && ObjectHelper.isNotEmpty((Object)configuration.getBeanReaderErrorHandler())) {
            answer = configuration.getBeanReaderErrorHandler();
        }
        if (answer == null) {
            answer = new BeanIOErrorHandler();
        }
        if (answer instanceof BeanIOErrorHandler) {
            BeanIOErrorHandler eh = answer;
            eh.setConfiguration(configuration);
            eh.setExchange(exchange);
            eh.setResults(results);
            eh.setIterator(iterator);
            eh.init();
        }
        return answer;
    }
}

