/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.beanio;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.beanio.BeanReader;

public class BeanIOIterator
implements Iterator<Object>,
Closeable {
    private BeanReader reader;
    private transient Object next;
    private transient Object forceNext;

    public BeanIOIterator(BeanReader reader) {
        this.reader = reader;
        this.next = this.next();
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Object next() {
        Object answer = this.next;
        if (answer == null) {
            answer = this.reader.read();
            if (this.forceNext != null) {
                answer = this.forceNext;
                this.forceNext = null;
            }
        } else {
            this.next = this.reader.read();
            if (this.forceNext != null) {
                this.next = this.forceNext;
                this.forceNext = null;
            }
        }
        return answer;
    }

    @Override
    public void remove() {
    }

    public void setNext(Object next) {
        this.forceNext = next;
    }
}

