/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Collection;
import java.util.StringJoiner;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.bean.MethodInfo;

public class AmbiguousMethodCallException
extends RuntimeExchangeException {
    private final Collection<MethodInfo> methods;

    public AmbiguousMethodCallException(Exchange exchange, Collection<MethodInfo> methods) {
        super(AmbiguousMethodCallException.createMessage(methods), exchange);
        this.methods = methods;
    }

    public Collection<MethodInfo> getMethods() {
        return this.methods;
    }

    private static String createMessage(Collection<MethodInfo> methods) {
        Class<?> clazz = null;
        StringJoiner sj = new StringJoiner("\n\t");
        for (MethodInfo mi : methods) {
            if (clazz == null) {
                clazz = mi.getMethod().getDeclaringClass();
                sj.add("\tClass: " + clazz.getName());
            }
            sj.add("\t" + mi.getMethod().toGenericString());
        }
        return "Ambiguous method invocations possible:\n" + String.valueOf(sj) + "\n\n";
    }
}

