/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.AsyncCallback;
import org.apache.camel.BeanScope;
import org.apache.camel.Exchange;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBeanProcessor
extends AsyncProcessorSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBeanProcessor.class);
    private final BeanHolder beanHolder;
    private transient Processor processor;
    private transient Object bean;
    private transient boolean lookupProcessorDone;
    private final Lock lock = new ReentrantLock();
    private BeanScope scope;
    private String method;
    private boolean shorthandMethod;

    protected AbstractBeanProcessor(Object pojo, BeanInfo beanInfo) {
        this(new ConstantBeanHolder(pojo, beanInfo));
    }

    protected AbstractBeanProcessor(BeanHolder beanHolder) {
        this.beanHolder = beanHolder;
    }

    public String toString() {
        return "BeanProcessor[" + String.valueOf(this.beanHolder) + (String)(this.method != null ? "#" + this.method : "") + "]";
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Processor target;
        BeanInfo beanInfo;
        Object beanInstance;
        String explicitMethodName = this.method;
        try {
            beanInstance = this.beanHolder.getBean(exchange);
            beanInfo = this.doGetBeanInfo(beanInstance);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        if (this.allowProcessor(explicitMethodName, beanInfo) && (target = this.getCustomAdapter(exchange, beanInstance)) != null) {
            AbstractBeanProcessor.useCustomAdapter(exchange, callback, target);
            return true;
        }
        return AbstractBeanProcessor.useMethodInvocation(exchange, callback, explicitMethodName, beanInfo, beanInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean useMethodInvocation(Exchange exchange, AsyncCallback callback, String explicitMethodName, BeanInfo beanInfo, Object beanInstance) {
        MethodInvocation invocation;
        if (explicitMethodName != null) {
            exchange.setProperty("CamelBeanMethodName", (Object)explicitMethodName);
        }
        try {
            invocation = beanInfo.createInvocation(beanInstance, exchange, explicitMethodName);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            boolean bl = true;
            return bl;
        }
        finally {
            if (explicitMethodName != null) {
                exchange.removeProperty("CamelBeanMethodName");
            }
        }
        if (invocation == null) {
            exchange.setException((Throwable)new IllegalStateException("No method invocation could be created, no matching method could be found on: " + String.valueOf(beanInstance)));
            callback.done(true);
            return true;
        }
        return invocation.proceed(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Processor getCustomAdapter(Exchange exchange, Object beanTmp) {
        Processor target = this.getProcessor();
        if (target == null) {
            boolean allowCache;
            boolean bl = allowCache = this.scope == null || this.scope == BeanScope.Singleton;
            if (allowCache) {
                if (!this.lookupProcessorDone) {
                    this.lock.lock();
                    try {
                        this.lookupProcessorDone = true;
                        this.processor = target = (Processor)exchange.getContext().getTypeConverter().tryConvertTo(Processor.class, exchange, beanTmp);
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            } else {
                target = (Processor)exchange.getContext().getTypeConverter().tryConvertTo(Processor.class, exchange, beanTmp);
            }
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void useCustomAdapter(Exchange exchange, AsyncCallback callback, Processor target) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using a custom adapter as bean invocation: {}", (Object)target);
        }
        try {
            target.process(exchange);
        }
        catch (AssertionError | Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            callback.done(true);
        }
    }

    private BeanInfo doGetBeanInfo(Object beanTmp) {
        BeanInfo beanInfo = this.beanHolder.getBeanInfo(beanTmp);
        if (beanInfo == null) {
            beanInfo = this.beanHolder.getBeanInfo();
        }
        return beanInfo;
    }

    protected Processor getProcessor() {
        return this.processor;
    }

    protected BeanHolder getBeanHolder() {
        return this.beanHolder;
    }

    public Object getBean() {
        return this.beanHolder.getBean(null);
    }

    public String getMethod() {
        return this.method;
    }

    public BeanScope getScope() {
        return this.scope;
    }

    public void setScope(BeanScope scope) {
        this.scope = scope;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean isShorthandMethod() {
        return this.shorthandMethod;
    }

    public void setShorthandMethod(boolean shorthandMethod) {
        this.shorthandMethod = shorthandMethod;
    }

    protected void doInit() throws Exception {
        if (this.beanHolder.supportProcessor() && this.allowProcessor(this.method, this.beanHolder.getBeanInfo())) {
            this.processor = this.beanHolder.getProcessor();
            ServiceHelper.initService((Object)this.processor);
        } else if (this.beanHolder instanceof ConstantBeanHolder) {
            try {
                this.bean = this.beanHolder.getBean(null);
                ServiceHelper.initService((Object)this.bean);
            }
            catch (NoSuchBeanException noSuchBeanException) {
                // empty catch block
            }
        }
    }

    protected void doStart() throws Exception {
        if (this.processor != null) {
            ServiceHelper.startService((Object)this.processor);
        } else if (this.bean != null) {
            ServiceHelper.startService((Object)this.bean);
        }
    }

    protected void doStop() throws Exception {
        if (this.processor != null) {
            ServiceHelper.stopService((Object)this.processor);
        } else if (this.bean != null) {
            ServiceHelper.stopService((Object)this.bean);
        }
    }

    protected void doShutdown() throws Exception {
        if (this.processor != null) {
            ServiceHelper.stopAndShutdownService((Object)this.processor);
        } else if (this.bean != null) {
            ServiceHelper.stopAndShutdownService((Object)this.bean);
        }
    }

    private boolean allowProcessor(String explicitMethodName, BeanInfo info) {
        if (explicitMethodName != null) {
            return false;
        }
        return !info.hasAnyMethodHandlerAnnotation();
    }
}

