/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.annotations.PropertiesFunction;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.StringHelper;

@PropertiesFunction(value="bean")
public class BeanPropertiesFunction
implements org.apache.camel.spi.PropertiesFunction,
CamelContextAware {
    private CamelContext camelContext;

    public String getName() {
        return "bean";
    }

    public String apply(String remainder) {
        if (StringHelper.countChar((String)remainder, (char)'.') != 1 || remainder.startsWith(".") || remainder.endsWith(".")) {
            throw new IllegalArgumentException("BeanName and methodName should be separated by a dot.");
        }
        String[] beanNameAndMethodName = remainder.split("\\.");
        String beanName = beanNameAndMethodName[0];
        String methodName = beanNameAndMethodName[1];
        Object bean = CamelContextHelper.mandatoryLookup((CamelContext)this.camelContext, (String)beanName);
        Object answer = "";
        try {
            answer = (String)answer + (String)this.camelContext.getTypeConverter().convertTo(String.class, ObjectHelper.invokeMethodSafe((String)methodName, (Object)bean, (Object[])new Object[0]));
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }
}

