/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.Method;
import java.util.Objects;

public final class BeanInfoCacheKey {
    private final Class<?> type;
    private final Object instance;
    private final Method explicitMethod;

    public BeanInfoCacheKey(Class<?> type, Object instance, Method explicitMethod) {
        this.type = type;
        this.instance = instance;
        this.explicitMethod = explicitMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeanInfoCacheKey that = (BeanInfoCacheKey)o;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.instance, that.instance)) {
            return false;
        }
        return Objects.equals(this.explicitMethod, that.explicitMethod);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.instance != null ? this.instance.hashCode() : 0);
        result = 31 * result + (this.explicitMethod != null ? this.explicitMethod.hashCode() : 0);
        return result;
    }
}

