/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.event;

import org.apache.camel.CamelContext;
import org.apache.camel.DelegateProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.impl.event.CamelContextInitializedEvent;
import org.apache.camel.impl.event.CamelContextInitializingEvent;
import org.apache.camel.impl.event.CamelContextReloadFailureEvent;
import org.apache.camel.impl.event.CamelContextReloadedEvent;
import org.apache.camel.impl.event.CamelContextReloadingEvent;
import org.apache.camel.impl.event.CamelContextResumeFailureEvent;
import org.apache.camel.impl.event.CamelContextResumedEvent;
import org.apache.camel.impl.event.CamelContextResumingEvent;
import org.apache.camel.impl.event.CamelContextRoutesStartedEvent;
import org.apache.camel.impl.event.CamelContextRoutesStartingEvent;
import org.apache.camel.impl.event.CamelContextRoutesStoppedEvent;
import org.apache.camel.impl.event.CamelContextRoutesStoppingEvent;
import org.apache.camel.impl.event.CamelContextStartedEvent;
import org.apache.camel.impl.event.CamelContextStartingEvent;
import org.apache.camel.impl.event.CamelContextStartupFailureEvent;
import org.apache.camel.impl.event.CamelContextStopFailureEvent;
import org.apache.camel.impl.event.CamelContextStoppedEvent;
import org.apache.camel.impl.event.CamelContextStoppingEvent;
import org.apache.camel.impl.event.CamelContextSuspendedEvent;
import org.apache.camel.impl.event.CamelContextSuspendingEvent;
import org.apache.camel.impl.event.ExchangeAsyncProcessingStartedEvent;
import org.apache.camel.impl.event.ExchangeCompletedEvent;
import org.apache.camel.impl.event.ExchangeCreatedEvent;
import org.apache.camel.impl.event.ExchangeFailedEvent;
import org.apache.camel.impl.event.ExchangeFailureHandledEvent;
import org.apache.camel.impl.event.ExchangeFailureHandlingEvent;
import org.apache.camel.impl.event.ExchangeRedeliveryEvent;
import org.apache.camel.impl.event.ExchangeSendingEvent;
import org.apache.camel.impl.event.ExchangeSentEvent;
import org.apache.camel.impl.event.RouteAddedEvent;
import org.apache.camel.impl.event.RouteReloadedEvent;
import org.apache.camel.impl.event.RouteRemovedEvent;
import org.apache.camel.impl.event.RouteStartedEvent;
import org.apache.camel.impl.event.RouteStartingEvent;
import org.apache.camel.impl.event.RouteStoppedEvent;
import org.apache.camel.impl.event.RouteStoppingEvent;
import org.apache.camel.impl.event.ServiceStartupFailureEvent;
import org.apache.camel.impl.event.ServiceStopFailureEvent;
import org.apache.camel.impl.event.StepCompletedEvent;
import org.apache.camel.impl.event.StepFailedEvent;
import org.apache.camel.impl.event.StepStartedEvent;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventFactory;

public class DefaultEventFactory
implements EventFactory {
    private boolean timestampEnabled;

    public boolean isTimestampEnabled() {
        return this.timestampEnabled;
    }

    public void setTimestampEnabled(boolean timestampEnabled) {
        this.timestampEnabled = timestampEnabled;
    }

    public CamelEvent createCamelContextInitializingEvent(CamelContext context) {
        CamelContextInitializingEvent answer = new CamelContextInitializingEvent(context);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextInitializedEvent(CamelContext context) {
        CamelContextInitializedEvent answer = new CamelContextInitializedEvent(context);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextStartingEvent(CamelContext context) {
        CamelContextStartingEvent answer = new CamelContextStartingEvent(context);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextStartedEvent(CamelContext context) {
        CamelContextStartedEvent answer = new CamelContextStartedEvent(context);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextStoppingEvent(CamelContext context) {
        CamelContextStoppingEvent answer = new CamelContextStoppingEvent(context);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextStoppedEvent(CamelContext context) {
        CamelContextStoppedEvent answer = new CamelContextStoppedEvent(context);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextRoutesStartingEvent(CamelContext context) {
        CamelContextRoutesStartingEvent answer = new CamelContextRoutesStartingEvent(context);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextRoutesStartedEvent(CamelContext context) {
        CamelContextRoutesStartedEvent answer = new CamelContextRoutesStartedEvent(context);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextRoutesStoppingEvent(CamelContext context) {
        CamelContextRoutesStoppingEvent answer = new CamelContextRoutesStoppingEvent(context);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextRoutesStoppedEvent(CamelContext context) {
        CamelContextRoutesStoppedEvent answer = new CamelContextRoutesStoppedEvent(context);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextStartupFailureEvent(CamelContext context, Throwable cause) {
        CamelContextStartupFailureEvent answer = new CamelContextStartupFailureEvent(context, cause);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextStopFailureEvent(CamelContext context, Throwable cause) {
        CamelContextStopFailureEvent answer = new CamelContextStopFailureEvent(context, cause);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextReloading(CamelContext context, Object source) {
        CamelContextReloadingEvent answer = new CamelContextReloadingEvent(context, source);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextReloadFailure(CamelContext context, Object source, Throwable cause) {
        CamelContextReloadFailureEvent answer = new CamelContextReloadFailureEvent(context, source, cause);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextReloaded(CamelContext context, Object source) {
        CamelContextReloadedEvent answer = new CamelContextReloadedEvent(context, source);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createServiceStartupFailureEvent(CamelContext context, Object service, Throwable cause) {
        ServiceStartupFailureEvent answer = new ServiceStartupFailureEvent(context, service, cause);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createServiceStopFailureEvent(CamelContext context, Object service, Throwable cause) {
        ServiceStopFailureEvent answer = new ServiceStopFailureEvent(context, service, cause);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createRouteStartingEvent(Route route) {
        RouteStartingEvent answer = new RouteStartingEvent(route);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createRouteStartedEvent(Route route) {
        RouteStartedEvent answer = new RouteStartedEvent(route);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createRouteStoppingEvent(Route route) {
        RouteStoppingEvent answer = new RouteStoppingEvent(route);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createRouteStoppedEvent(Route route) {
        RouteStoppedEvent answer = new RouteStoppedEvent(route);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createRouteAddedEvent(Route route) {
        RouteAddedEvent answer = new RouteAddedEvent(route);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createRouteRemovedEvent(Route route) {
        RouteRemovedEvent answer = new RouteRemovedEvent(route);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createRouteReloaded(Route route, int index, int total) {
        RouteReloadedEvent answer = new RouteReloadedEvent(route, index, total);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createExchangeCreatedEvent(Exchange exchange) {
        ExchangeCreatedEvent answer = new ExchangeCreatedEvent(exchange);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createExchangeCompletedEvent(Exchange exchange) {
        ExchangeCompletedEvent answer = new ExchangeCompletedEvent(exchange);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createExchangeFailedEvent(Exchange exchange) {
        ExchangeFailedEvent answer = new ExchangeFailedEvent(exchange);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createExchangeFailureHandlingEvent(Exchange exchange, Processor failureHandler, boolean deadLetterChannel, String deadLetterUri) {
        Processor handler = failureHandler;
        if (handler instanceof DelegateProcessor) {
            handler = ((DelegateProcessor)handler).getProcessor();
        }
        ExchangeFailureHandlingEvent answer = new ExchangeFailureHandlingEvent(exchange, handler, deadLetterChannel, deadLetterUri);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createExchangeFailureHandledEvent(Exchange exchange, Processor failureHandler, boolean deadLetterChannel, String deadLetterUri) {
        Processor handler = failureHandler;
        if (handler instanceof DelegateProcessor) {
            handler = ((DelegateProcessor)handler).getProcessor();
        }
        ExchangeFailureHandledEvent answer = new ExchangeFailureHandledEvent(exchange, handler, deadLetterChannel, deadLetterUri);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createExchangeRedeliveryEvent(Exchange exchange, int attempt) {
        ExchangeRedeliveryEvent answer = new ExchangeRedeliveryEvent(exchange, attempt);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createExchangeSendingEvent(Exchange exchange, Endpoint endpoint) {
        ExchangeSendingEvent answer = new ExchangeSendingEvent(exchange, endpoint);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createExchangeSentEvent(Exchange exchange, Endpoint endpoint, long timeTaken) {
        ExchangeSentEvent answer = new ExchangeSentEvent(exchange, endpoint, timeTaken);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createStepStartedEvent(Exchange exchange, String stepId) {
        StepStartedEvent answer = new StepStartedEvent(exchange, stepId);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createStepCompletedEvent(Exchange exchange, String stepId) {
        StepCompletedEvent answer = new StepCompletedEvent(exchange, stepId);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createStepFailedEvent(Exchange exchange, String stepId) {
        StepFailedEvent answer = new StepFailedEvent(exchange, stepId);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextSuspendingEvent(CamelContext context) {
        CamelContextSuspendingEvent answer = new CamelContextSuspendingEvent(context);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextSuspendedEvent(CamelContext context) {
        CamelContextSuspendedEvent answer = new CamelContextSuspendedEvent(context);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextResumingEvent(CamelContext context) {
        CamelContextResumingEvent answer = new CamelContextResumingEvent(context);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextResumedEvent(CamelContext context) {
        CamelContextResumedEvent answer = new CamelContextResumedEvent(context);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelContextResumeFailureEvent(CamelContext context, Throwable cause) {
        CamelContextResumeFailureEvent answer = new CamelContextResumeFailureEvent(context, cause);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }

    public CamelEvent createCamelExchangeAsyncProcessingStartedEvent(Exchange exchange) {
        ExchangeAsyncProcessingStartedEvent answer = new ExchangeAsyncProcessingStartedEvent(exchange);
        if (this.timestampEnabled) {
            answer.setTimestamp(System.currentTimeMillis());
        }
        return answer;
    }
}

