/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.Converter;

@Converter(generateBulkLoader=true)
public final class CollectionConverter {
    private CollectionConverter() {
    }

    @Converter(order=1)
    public static Object[] toArray(Collection<?> value) {
        return value.toArray();
    }

    @Converter(order=2)
    public static List<Object> toList(Object[] array) {
        return Arrays.asList(array);
    }

    @Converter(order=3)
    public static <T> List<T> toList(Collection<T> collection) {
        return new ArrayList<T>(collection);
    }

    @Converter(order=4)
    public static <T> ArrayList<T> toArrayList(Iterator<T> it) {
        if (it instanceof ArrayList) {
            return (ArrayList)((Object)it);
        }
        ArrayList<T> list = new ArrayList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Converter(order=5)
    public static <T> ArrayList<T> toArrayList(Iterable<T> it) {
        if (it instanceof ArrayList) {
            return (ArrayList)it;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T value : it) {
            list.add(value);
        }
        return list;
    }

    @Converter(order=6)
    public static Set<Object> toSet(Object[] array) {
        return new HashSet<Object>(Arrays.asList(array));
    }

    @Converter(order=7)
    public static <T> Set<T> toSet(Collection<T> collection) {
        return new HashSet<T>(collection);
    }

    @Converter(order=8)
    public static <K, V> Set<Map.Entry<K, V>> toSet(Map<K, V> map) {
        return map.entrySet();
    }

    @Converter(order=9)
    public static <K, V> Collection<Map.Entry<K, V>> toCollection(Map<K, V> map) {
        return map.entrySet();
    }

    @Converter(order=10)
    public static Properties toProperties(Map<Object, Object> map) {
        Properties answer = new Properties();
        answer.putAll(map);
        return answer;
    }

    @Converter(order=11)
    public static <K, V> Hashtable<K, V> toHashtable(Map<? extends K, ? extends V> map) {
        return new Hashtable<K, V>(map);
    }

    @Converter(order=12)
    public static <K, V> HashMap<K, V> toHashMap(Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    @Converter(order=13)
    public static <T> List<T> toList(Iterable<T> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        LinkedList<T> result = new LinkedList<T>();
        for (T value : iterable) {
            result.add(value);
        }
        return result;
    }

    @Converter(order=14)
    public static <T> List<T> toList(Iterator<T> it) {
        if (it instanceof List) {
            return (List)((Object)it);
        }
        LinkedList<T> result = new LinkedList<T>();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }
}

