/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterExists;
import org.apache.camel.TypeConverterExistsException;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.converter.TypeConvertible;
import org.apache.camel.impl.converter.EnumTypeConverter;
import org.apache.camel.impl.converter.TypeResolverHelper;
import org.apache.camel.spi.BulkTypeConverters;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreTypeConverterRegistry
extends ServiceSupport
implements TypeConverter,
TypeConverterRegistry {
    protected static final TypeConverter MISS_CONVERTER = new TypeConverterSupport(){

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            return (T)MISS_VALUE;
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(CoreTypeConverterRegistry.class);
    protected final List<FallbackTypeConverter> fallbackConverters = new CopyOnWriteArrayList<FallbackTypeConverter>();
    protected final TypeConverter enumTypeConverter = new EnumTypeConverter();
    protected final TypeConverterRegistry.Statistics statistics = new UtilizationStatistics();
    protected final LongAdder noopCounter = new LongAdder();
    protected final LongAdder attemptCounter = new LongAdder();
    protected final LongAdder missCounter = new LongAdder();
    protected final LongAdder hitCounter = new LongAdder();
    protected final LongAdder failedCounter = new LongAdder();
    protected TypeConverterExists typeConverterExists = TypeConverterExists.Ignore;
    protected LoggingLevel typeConverterExistsLoggingLevel = LoggingLevel.DEBUG;
    private final Map<TypeConvertible<?, ?>, TypeConverter> converters = new ConcurrentHashMap(256);

    public boolean allowNull() {
        return false;
    }

    public void setInjector(Injector injector) {
        throw new UnsupportedOperationException();
    }

    public Injector getInjector() {
        throw new UnsupportedOperationException();
    }

    public void setCamelContext(CamelContext camelContext) {
        throw new UnsupportedOperationException();
    }

    public CamelContext getCamelContext() {
        throw new UnsupportedOperationException();
    }

    public List<FallbackTypeConverter> getFallbackConverters() {
        return this.fallbackConverters;
    }

    public <T> T convertTo(Class<T> type, Object value) {
        return this.convertTo(type, null, value);
    }

    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        if (value != null) {
            if (type.isInstance(value)) {
                return (T)value;
            }
            if (type == Boolean.TYPE) {
                Boolean answer = ObjectConverter.toBoolean(value);
                CoreTypeConverterRegistry.requireNonNullBoolean(type, value, answer);
                return (T)answer;
            }
            if (type == Boolean.class && value instanceof String) {
                Boolean parsedBoolean = CoreTypeConverterRegistry.customParseBoolean((String)value);
                if (parsedBoolean != null) {
                    return (T)parsedBoolean;
                }
            } else if (type.isPrimitive()) {
                Class<?> cls = value.getClass();
                if (cls == Integer.class || cls == Long.class) {
                    return (T)value;
                }
            } else if (type == String.class) {
                Class<?> cls = value.getClass();
                if (cls.isPrimitive() || cls == Boolean.class || cls == Integer.class || cls == Long.class) {
                    return (T)value.toString();
                }
            } else if (type.isEnum()) {
                try {
                    return (T)this.enumTypeConverter.convertTo(type, exchange, value);
                }
                catch (Exception e) {
                    throw this.createTypeConversionException(exchange, type, value, e);
                }
            }
        }
        return (T)this.doConvertToAndStat(type, exchange, value, false);
    }

    private static Boolean customParseBoolean(String str) {
        int len = str.length();
        if (len == 4) {
            if ("true".equals(str)) {
                return Boolean.TRUE;
            }
            if ("TRUE".equals(str.toUpperCase())) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (len == 5) {
            if ("false".equals(str)) {
                return Boolean.FALSE;
            }
            if ("FALSE".equals(str.toUpperCase())) {
                return Boolean.FALSE;
            }
            return null;
        }
        return null;
    }

    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws NoTypeConversionAvailableException {
        return this.mandatoryConvertTo(type, null, value);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws NoTypeConversionAvailableException {
        Object answer;
        if (value != null) {
            if (type.isInstance(value)) {
                return (T)value;
            }
            if (type == Boolean.TYPE) {
                Boolean answer2 = ObjectConverter.toBoolean(value);
                CoreTypeConverterRegistry.requireNonNullBoolean(type, value, answer2);
                return (T)answer2;
            }
            if (type == Boolean.class && value instanceof String) {
                Boolean parsedBoolean = CoreTypeConverterRegistry.customParseBoolean((String)value);
                if (parsedBoolean != null) {
                    return (T)parsedBoolean;
                }
            } else if (type.isPrimitive()) {
                cls = value.getClass();
                if (cls == Integer.class || cls == Long.class) {
                    return (T)value;
                }
            } else if (type == String.class) {
                cls = value.getClass();
                if (cls.isPrimitive() || cls == Boolean.class || cls == Integer.class || cls == Long.class) {
                    return (T)value.toString();
                }
            } else if (type.isEnum()) {
                try {
                    return (T)this.enumTypeConverter.convertTo(type, exchange, value);
                }
                catch (Exception e) {
                    throw this.createTypeConversionException(exchange, type, value, e);
                }
            }
        }
        if ((answer = this.doConvertToAndStat(type, exchange, value, false)) == null) {
            throw new NoTypeConversionAvailableException(value, type);
        }
        return (T)answer;
    }

    public <T> T tryConvertTo(Class<T> type, Object value) {
        return this.tryConvertTo(type, null, value);
    }

    public <T> T tryConvertTo(Class<T> type, Exchange exchange, Object value) {
        if (value != null) {
            if (type.isInstance(value)) {
                return (T)value;
            }
            if (type == Boolean.TYPE) {
                Boolean answer = ObjectConverter.toBoolean(value);
                CoreTypeConverterRegistry.requireNonNullBoolean(type, value, answer);
                return (T)answer;
            }
            if (type == Boolean.class && value instanceof String) {
                Boolean parsedBoolean = CoreTypeConverterRegistry.customParseBoolean((String)value);
                if (parsedBoolean != null) {
                    return (T)parsedBoolean;
                }
            } else if (type.isPrimitive()) {
                Class<?> cls = value.getClass();
                if (cls == Integer.class || cls == Long.class) {
                    return (T)value;
                }
            } else if (type == String.class) {
                Class<?> cls = value.getClass();
                if (cls.isPrimitive() || cls == Boolean.class || cls == Integer.class || cls == Long.class) {
                    return (T)value.toString();
                }
            } else if (type.isEnum()) {
                try {
                    return (T)this.enumTypeConverter.convertTo(type, exchange, value);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return (T)this.doConvertToAndStat(type, exchange, value, true);
    }

    private static <T> void requireNonNullBoolean(Class<T> type, Object value, Object answer) {
        if (answer == null) {
            throw new TypeConversionException(value, type, (Throwable)new IllegalArgumentException("Cannot convert type: " + value.getClass().getName() + " to boolean"));
        }
    }

    protected Object doConvertToAndStat(Class<?> type, Exchange exchange, Object value, boolean tryConvert) {
        boolean statisticsEnabled = !tryConvert && this.statistics.isStatisticsEnabled();
        Object answer = null;
        try {
            answer = this.doConvertTo(type, exchange, value, tryConvert);
        }
        catch (Exception e) {
            if (statisticsEnabled) {
                this.failedCounter.increment();
            }
            if (tryConvert) {
                return null;
            }
            this.wrapConversionException(type, exchange, value, e);
        }
        if (answer == TypeConverter.MISS_VALUE) {
            if (statisticsEnabled) {
                this.missCounter.increment();
            }
            return null;
        }
        if (statisticsEnabled) {
            this.hitCounter.increment();
        }
        return answer;
    }

    private void wrapConversionException(Class<?> type, Exchange exchange, Object value, Exception e) {
        boolean execution;
        boolean bl = execution = ObjectHelper.getException(ExecutionException.class, (Throwable)e) != null || ObjectHelper.getException(CamelExecutionException.class, (Throwable)e) != null;
        if (execution) {
            throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
        }
        throw this.createTypeConversionException(exchange, type, value, e);
    }

    private static Object nullToPrimitiveType(Class<?> type) {
        if (Boolean.TYPE == type) {
            return Boolean.FALSE;
        }
        if (Integer.TYPE == type) {
            return 0;
        }
        if (Long.TYPE == type) {
            return 0L;
        }
        if (Byte.TYPE == type) {
            return (byte)0;
        }
        if (Short.TYPE == type) {
            return (short)0;
        }
        if (Double.TYPE == type) {
            return 0.0;
        }
        if (Float.TYPE == type) {
            return Float.valueOf(0.0f);
        }
        if (Character.TYPE == type) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    protected Object doConvertTo(Class<?> type, Exchange exchange, Object value, boolean tryConvert) {
        boolean statisticsEnabled;
        boolean bl = statisticsEnabled = !tryConvert && this.statistics.isStatisticsEnabled();
        if (value == null) {
            if (statisticsEnabled) {
                this.noopCounter.increment();
            }
            if (type.isPrimitive()) {
                return CoreTypeConverterRegistry.nullToPrimitiveType(type);
            }
            return null;
        }
        if (type.isInstance(value)) {
            if (statisticsEnabled) {
                this.noopCounter.increment();
            }
            return value;
        }
        if (statisticsEnabled) {
            this.attemptCounter.increment();
        }
        Class aClass = type.isPrimitive() ? ObjectHelper.convertPrimitiveTypeToWrapperType(type) : type;
        TypeConvertible typeConvertible = new TypeConvertible(value.getClass(), aClass);
        Object ret = this.tryCachedConverters(type, exchange, value, typeConvertible);
        if (ret != null) {
            return ret;
        }
        Object fallBackRet = this.tryFallback(type, exchange, value, tryConvert);
        if (fallBackRet != null) {
            return fallBackRet;
        }
        TypeConverter assignableConverter = TypeResolverHelper.tryAssignableFrom(typeConvertible, this.converters);
        if (assignableConverter != null) {
            this.converters.put(typeConvertible, assignableConverter);
            return assignableConverter.convertTo(type, exchange, value);
        }
        TypeConverter objConverter = this.converters.get(new TypeConvertible(Object.class, type));
        if (objConverter != null) {
            this.converters.put(typeConvertible, objConverter);
            return objConverter.convertTo(type, exchange, value);
        }
        this.converters.put(typeConvertible, MISS_CONVERTER);
        return TypeConverter.MISS_VALUE;
    }

    private Object tryCachedConverters(Class<?> type, Exchange exchange, Object value, TypeConvertible<?, ?> typeConvertible) {
        Object ret;
        Object ret2;
        TypeConverter typeConverter = this.converters.get(typeConvertible);
        if (typeConverter != null && (ret2 = typeConverter.convertTo(type, exchange, value)) != null) {
            return ret2;
        }
        TypeConverter superConverterTc = TypeResolverHelper.tryMatch(typeConvertible, this.converters);
        if (superConverterTc != null && (ret = superConverterTc.convertTo(type, exchange, value)) != null) {
            this.converters.put(typeConvertible, superConverterTc);
            return ret;
        }
        return null;
    }

    private Object tryFallback(Class<?> type, Exchange exchange, Object value, boolean tryConvert) {
        for (FallbackTypeConverter fallback : this.fallbackConverters) {
            TypeConverter tc = fallback.getFallbackTypeConverter();
            Object rc = CoreTypeConverterRegistry.doConvert(type, exchange, value, tryConvert, tc);
            if (rc == null && tc.allowNull()) {
                return null;
            }
            if (rc == TypeConverter.MISS_VALUE) {
                return TypeConverter.MISS_VALUE;
            }
            if (rc == null) continue;
            if (fallback.isCanPromote()) {
                this.addTypeConverter(type, value.getClass(), fallback.getFallbackTypeConverter());
            }
            return rc;
        }
        return null;
    }

    private static Object doConvert(Exchange exchange, Object value, boolean tryConvert, Class<?> primitiveType, TypeConverter tc) {
        if (tryConvert) {
            return tc.tryConvertTo(primitiveType, exchange, value);
        }
        return tc.convertTo(primitiveType, exchange, value);
    }

    private static Object doConvert(Class<?> type, Exchange exchange, Object value, boolean tryConvert, TypeConverter converter) {
        if (tryConvert) {
            return converter.tryConvertTo(type, exchange, value);
        }
        return converter.convertTo(type, exchange, value);
    }

    public TypeConverter getTypeConverter(Class<?> toType, Class<?> fromType) {
        return this.converters.get(new TypeConvertible(fromType, toType));
    }

    public void addConverter(TypeConvertible<?, ?> typeConvertible, TypeConverter typeConverter) {
        this.converters.put(typeConvertible, typeConverter);
    }

    public void addBulkTypeConverters(BulkTypeConverters bulkTypeConverters) {
    }

    public void addTypeConverter(Class<?> toType, Class<?> fromType, TypeConverter typeConverter) {
        LOG.trace("Adding type converter: {}", (Object)typeConverter);
        TypeConvertible typeConvertible = new TypeConvertible(fromType, toType);
        TypeConverter converter = this.converters.get(typeConvertible);
        if (converter == MISS_CONVERTER) {
            this.converters.put(typeConvertible, typeConverter);
            return;
        }
        if (typeConverter != converter) {
            boolean add = true;
            if (converter != null) {
                if (this.typeConverterExists == TypeConverterExists.Override) {
                    CamelLogger logger = new CamelLogger(LOG, this.typeConverterExistsLoggingLevel);
                    logger.log("Overriding type converter from: " + converter + " to: " + typeConverter);
                } else if (this.typeConverterExists == TypeConverterExists.Ignore) {
                    CamelLogger logger = new CamelLogger(LOG, this.typeConverterExistsLoggingLevel);
                    logger.log("Ignoring duplicate type converter from: " + converter + " to: " + typeConverter);
                    add = false;
                } else {
                    throw new TypeConverterExistsException(toType, fromType);
                }
            }
            if (add) {
                this.converters.put(typeConvertible, typeConverter);
            }
        }
    }

    public boolean removeTypeConverter(Class<?> toType, Class<?> fromType) {
        LOG.trace("Removing type converter from: {} to: {}", fromType, toType);
        TypeConverter removed = this.converters.remove(new TypeConvertible(fromType, toType));
        return removed != null;
    }

    public void addTypeConverters(Object typeConverters) {
        throw new UnsupportedOperationException();
    }

    public void addFallbackTypeConverter(TypeConverter typeConverter, boolean canPromote) {
        LOG.trace("Adding fallback type converter: {} which can promote: {}", (Object)typeConverter, (Object)canPromote);
        this.fallbackConverters.add(0, new FallbackTypeConverter(typeConverter, canPromote));
    }

    public TypeConverter lookup(Class<?> toType, Class<?> fromType) {
        return this.doLookup(toType, fromType);
    }

    @Deprecated
    protected TypeConverter getOrFindTypeConverter(Class<?> toType, Class<?> fromType) {
        TypeConvertible typeConvertible = new TypeConvertible(fromType, toType);
        TypeConverter converter = this.converters.get(typeConvertible);
        if (converter == null && (converter = this.lookup(toType, fromType)) != null) {
            this.converters.put(typeConvertible, converter);
        }
        return converter;
    }

    protected TypeConverter doLookup(Class<?> toType, Class<?> fromType) {
        return TypeResolverHelper.doLookup(toType, fromType, this.converters);
    }

    protected TypeConversionException createTypeConversionException(Exchange exchange, Class<?> type, Object value, Throwable cause) {
        if (cause instanceof TypeConversionException && ((TypeConversionException)cause).getToType() == type) {
            return (TypeConversionException)cause;
        }
        Object body = exchange != null ? MessageHelper.extractValueForLogging((Object)value, (Message)exchange.getIn()) : value;
        return new TypeConversionException(body, type, cause);
    }

    public TypeConverterRegistry.Statistics getStatistics() {
        return this.statistics;
    }

    public int size() {
        return this.converters.size();
    }

    public LoggingLevel getTypeConverterExistsLoggingLevel() {
        return this.typeConverterExistsLoggingLevel;
    }

    public void setTypeConverterExistsLoggingLevel(LoggingLevel typeConverterExistsLoggingLevel) {
        this.typeConverterExistsLoggingLevel = typeConverterExistsLoggingLevel;
    }

    public TypeConverterExists getTypeConverterExists() {
        return this.typeConverterExists;
    }

    public void setTypeConverterExists(TypeConverterExists typeConverterExists) {
        this.typeConverterExists = typeConverterExists;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.statistics.isStatisticsEnabled()) {
            Object info = this.statistics.toString();
            AtomicInteger misses = new AtomicInteger();
            this.converters.forEach((k, v) -> {
                if (v == MISS_CONVERTER) {
                    misses.incrementAndGet();
                }
            });
            info = (String)info + String.format(" mappings[total=%s, misses=%s]", this.size(), misses);
            LOG.info((String)info);
        }
        this.statistics.reset();
    }

    private final class UtilizationStatistics
    implements TypeConverterRegistry.Statistics {
        private boolean statisticsEnabled;

        private UtilizationStatistics() {
        }

        public long getNoopCounter() {
            return CoreTypeConverterRegistry.this.noopCounter.longValue();
        }

        public long getAttemptCounter() {
            return CoreTypeConverterRegistry.this.attemptCounter.longValue();
        }

        public long getHitCounter() {
            return CoreTypeConverterRegistry.this.hitCounter.longValue();
        }

        public long getMissCounter() {
            return CoreTypeConverterRegistry.this.missCounter.longValue();
        }

        public long getFailedCounter() {
            return CoreTypeConverterRegistry.this.failedCounter.longValue();
        }

        public void reset() {
            CoreTypeConverterRegistry.this.noopCounter.reset();
            CoreTypeConverterRegistry.this.attemptCounter.reset();
            CoreTypeConverterRegistry.this.hitCounter.reset();
            CoreTypeConverterRegistry.this.missCounter.reset();
            CoreTypeConverterRegistry.this.failedCounter.reset();
        }

        public boolean isStatisticsEnabled() {
            return this.statisticsEnabled;
        }

        public void setStatisticsEnabled(boolean statisticsEnabled) {
            this.statisticsEnabled = statisticsEnabled;
        }

        public String toString() {
            return String.format("TypeConverterRegistry utilization[noop=%s, attempts=%s, hits=%s, misses=%s, failures=%s]", this.getNoopCounter(), this.getAttemptCounter(), this.getHitCounter(), this.getMissCounter(), this.getFailedCounter());
        }
    }

    public static class FallbackTypeConverter {
        private final boolean canPromote;
        private final TypeConverter fallbackTypeConverter;

        FallbackTypeConverter(TypeConverter fallbackTypeConverter, boolean canPromote) {
            this.canPromote = canPromote;
            this.fallbackTypeConverter = fallbackTypeConverter;
        }

        public boolean isCanPromote() {
            return this.canPromote;
        }

        public TypeConverter getFallbackTypeConverter() {
            return this.fallbackTypeConverter;
        }
    }
}

