/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.InputStreamIterator;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter(generateBulkLoader=true)
public final class IOConverter {
    private static final Logger LOG = LoggerFactory.getLogger(IOConverter.class);

    private IOConverter() {
    }

    @Converter(order=1)
    public static InputStream toInputStream(Stream stream, Exchange exchange) {
        Iterator it = stream.iterator();
        return new InputStreamIterator(exchange.getContext().getTypeConverter(), it);
    }

    @Converter(order=2)
    public static InputStream toInputStream(URL url) throws IOException {
        return IOHelper.buffered((InputStream)url.openStream());
    }

    @Converter(order=3)
    public static InputStream toInputStream(File file) throws IOException {
        return IOHelper.buffered((InputStream)new FileInputStream(file));
    }

    @Converter(order=4)
    public static BufferedReader toReader(File file, Exchange exchange) throws IOException {
        return IOHelper.toReader((File)file, (Charset)ExchangeHelper.getCharset((Exchange)exchange));
    }

    @Converter(order=5)
    public static OutputStream toOutputStream(File file) throws FileNotFoundException {
        return IOHelper.buffered((OutputStream)new FileOutputStream(file));
    }

    @Converter(order=6)
    public static BufferedWriter toWriter(File file, Exchange exchange) throws IOException {
        FileOutputStream os = new FileOutputStream(file, false);
        return IOHelper.toWriter((FileOutputStream)os, (Charset)ExchangeHelper.getCharset((Exchange)exchange));
    }

    @Converter(order=7)
    public static Reader toReader(InputStream in, Exchange exchange) throws IOException {
        return IOHelper.buffered((Reader)new InputStreamReader(in, ExchangeHelper.getCharset((Exchange)exchange)));
    }

    @Converter(order=8)
    public static Reader toReader(byte[] data, Exchange exchange) throws IOException {
        return IOConverter.toReader(new ByteArrayInputStream(data), exchange);
    }

    @Converter(order=9)
    public static Writer toWriter(OutputStream out, Exchange exchange) throws IOException {
        return IOHelper.buffered((Writer)new OutputStreamWriter(out, ExchangeHelper.getCharset((Exchange)exchange)));
    }

    @Converter(order=10)
    public static Reader toReader(String text) {
        return new StringReader(text);
    }

    @Converter(order=11)
    public static InputStream toInputStream(String text, Exchange exchange) throws IOException {
        return IOConverter.toInputStream(text.getBytes(ExchangeHelper.getCharset((Exchange)exchange)));
    }

    @Converter(order=12)
    public static InputStream toInputStream(StringBuffer buffer, Exchange exchange) throws IOException {
        return IOConverter.toInputStream(buffer.toString(), exchange);
    }

    @Converter(order=13)
    public static InputStream toInputStream(StringBuilder builder, Exchange exchange) throws IOException {
        return IOConverter.toInputStream(builder.toString(), exchange);
    }

    @Converter(order=14)
    public static InputStream toInputStream(BufferedReader buffer, Exchange exchange) throws IOException {
        return IOConverter.toInputStream(IOConverter.toString(buffer), exchange);
    }

    @Converter(order=15)
    public static String toString(byte[] data, Exchange exchange) throws IOException {
        return new String(data, ExchangeHelper.getCharset((Exchange)exchange));
    }

    @Converter(order=16)
    public static String toString(File file, Exchange exchange) throws IOException {
        return IOConverter.toString(IOConverter.toReader(file, exchange));
    }

    @Converter(order=17)
    public static byte[] toByteArray(File file) throws IOException {
        InputStream is = IOConverter.toInputStream(file);
        try {
            byte[] byArray = IOConverter.toBytes(is);
            return byArray;
        }
        finally {
            IOHelper.close((Closeable)is, (String)"file", (Logger)LOG);
        }
    }

    @Converter(order=18)
    public static byte[] toByteArray(BufferedReader reader, Exchange exchange) throws IOException {
        String s = IOConverter.toString(reader);
        return IOConverter.toByteArray(s, exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter(order=19)
    public static String toString(URL url, Exchange exchange) throws IOException {
        InputStream is = IOConverter.toInputStream(url);
        try {
            String string = IOConverter.toString(is, exchange);
            return string;
        }
        finally {
            IOHelper.close((Closeable)is, (String)"url", (Logger)LOG);
        }
    }

    @Converter(order=20)
    public static String toString(BufferedReader reader) throws IOException {
        return IOHelper.toString((BufferedReader)reader);
    }

    @Converter(order=21)
    public static String toString(Reader reader) throws IOException {
        return IOHelper.toString((Reader)reader);
    }

    @Converter(order=22)
    public static byte[] toByteArray(Reader reader, Exchange exchange) throws IOException {
        return IOConverter.toByteArray(IOHelper.buffered((Reader)reader), exchange);
    }

    @Converter(order=23)
    public static byte[] toByteArray(String value, Exchange exchange) throws IOException {
        return value.getBytes(ExchangeHelper.getCharset((Exchange)exchange));
    }

    @Converter(order=24)
    public static String toString(InputStream in, Exchange exchange) throws IOException {
        return IOConverter.toString(IOConverter.toReader(in, exchange));
    }

    @Converter(order=25)
    public static InputStream toInputStream(byte[] data) {
        return new ByteArrayInputStream(data);
    }

    @Converter(order=26)
    public static ObjectOutput toObjectOutput(OutputStream stream) throws IOException {
        if (stream instanceof ObjectOutput) {
            return (ObjectOutput)((Object)stream);
        }
        return new ObjectOutputStream(IOHelper.buffered((OutputStream)stream));
    }

    @Converter(order=27)
    public static ObjectInput toObjectInput(InputStream stream, final Exchange exchange) throws IOException {
        if (stream instanceof ObjectInput) {
            return (ObjectInput)((Object)stream);
        }
        return new ObjectInputStream(IOHelper.buffered((InputStream)stream)){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                Class answer = null;
                String name = objectStreamClass.getName();
                if (exchange != null) {
                    LOG.trace("Loading class {} using Camel ClassResolver", (Object)name);
                    answer = exchange.getContext().getClassResolver().resolveClass(name);
                }
                if (answer == null) {
                    LOG.trace("Loading class {} using JDK default implementation", (Object)name);
                    answer = super.resolveClass(objectStreamClass);
                }
                return answer;
            }
        };
    }

    @Converter(order=28)
    public static byte[] toBytes(InputStream stream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOHelper.copyAndCloseInput((InputStream)IOHelper.buffered((InputStream)stream), (OutputStream)bos);
        return bos.toByteArray();
    }

    @Converter(order=29)
    public static byte[] toByteArray(ByteArrayOutputStream os) {
        return os.toByteArray();
    }

    @Converter(order=30)
    public static ByteBuffer covertToByteBuffer(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)os);
        return ByteBuffer.wrap(os.toByteArray());
    }

    @Converter(order=31)
    public static String toString(ByteArrayOutputStream os, Exchange exchange) throws IOException {
        return os.toString(ExchangeHelper.getCharset((Exchange)exchange));
    }

    @Converter(order=32)
    public static InputStream toInputStream(ByteArrayOutputStream os) {
        return new ByteArrayInputStream(os.toByteArray());
    }

    @Converter(order=33)
    public static Properties toProperties(File file) throws IOException {
        return IOConverter.toProperties(new FileInputStream(file));
    }

    @Converter(order=34)
    public static Properties toProperties(InputStream is) throws IOException {
        Properties prop = new Properties();
        try {
            prop.load(is);
        }
        finally {
            IOHelper.close((Closeable)is);
        }
        return prop;
    }

    @Converter(order=35)
    public static Properties toProperties(Reader reader) throws IOException {
        Properties prop = new Properties();
        try {
            prop.load(reader);
        }
        finally {
            IOHelper.close((Closeable)reader);
        }
        return prop;
    }

    @Converter(order=36)
    public static Path toPath(File file) {
        return file.toPath();
    }

    @Converter(order=37)
    public static File toFile(Path path) {
        return path.toFile();
    }
}

