/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.HashSet;
import java.util.Set;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLookup;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertiesParser
implements PropertiesParser {
    private static final String UNRESOLVED_PREFIX_TOKEN = "@@[";
    private static final String UNRESOLVED_SUFFIX_TOKEN = "]@@";
    private static final String GET_OR_ELSE_TOKEN = ":";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private PropertiesComponent propertiesComponent;

    public DefaultPropertiesParser() {
    }

    public DefaultPropertiesParser(PropertiesComponent propertiesComponent) {
        this.propertiesComponent = propertiesComponent;
    }

    public PropertiesComponent getPropertiesComponent() {
        return this.propertiesComponent;
    }

    public void setPropertiesComponent(PropertiesComponent propertiesComponent) {
        this.propertiesComponent = propertiesComponent;
    }

    @Override
    public String parseUri(String text, PropertiesLookup properties, boolean defaultFallbackEnabled, boolean keepUnresolvedOptional) throws IllegalArgumentException {
        ParsingContext context = new ParsingContext(properties, defaultFallbackEnabled, keepUnresolvedOptional);
        String answer = context.parse(text);
        if (keepUnresolvedOptional && answer != null && answer.contains(UNRESOLVED_PREFIX_TOKEN)) {
            answer = StringHelper.replaceAll((String)answer, (String)UNRESOLVED_PREFIX_TOKEN, (String)"{{");
            answer = StringHelper.replaceAll((String)answer, (String)UNRESOLVED_SUFFIX_TOKEN, (String)"}}");
        }
        return answer;
    }

    @Override
    public String parseProperty(String key, String value, PropertiesLookup properties) {
        return value;
    }

    private static final class Property {
        private final int beginIndex;
        private final int endIndex;
        private final String key;
        private final String value;

        private Property(int beginIndex, int endIndex, String key, String value) {
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
            this.key = key;
            this.value = value;
        }

        public int getBeginIndex() {
            return this.beginIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    private final class ParsingContext {
        private final PropertiesLookup properties;
        private final boolean defaultFallbackEnabled;
        private final boolean keepUnresolvedOptional;

        ParsingContext(PropertiesLookup properties, boolean defaultFallbackEnabled, boolean keepUnresolvedOptional) {
            this.properties = properties;
            this.defaultFallbackEnabled = defaultFallbackEnabled;
            this.keepUnresolvedOptional = keepUnresolvedOptional;
        }

        public String parse(String input) {
            return this.doParse(input, new HashSet<String>());
        }

        private String doParse(String input, Set<String> replacedPropertyKeys) {
            Property property;
            if (input == null) {
                return null;
            }
            String answer = input;
            while ((property = this.readProperty(answer)) != null) {
                if (replacedPropertyKeys.contains(property.getKey())) {
                    boolean optional = property.getKey().startsWith("?");
                    if (optional) break;
                    throw new IllegalArgumentException("Circular reference detected with key [" + property.getKey() + "] from text: " + input);
                }
                HashSet<String> newReplaced = new HashSet<String>(replacedPropertyKeys);
                newReplaced.add(property.getKey());
                String before = answer.substring(0, property.getBeginIndex());
                String after = answer.substring(property.getEndIndex());
                String parsed = this.doParse(property.getValue(), newReplaced);
                if (parsed != null) {
                    answer = before + parsed + after;
                    continue;
                }
                if (property.getBeginIndex() == 0 && input.length() == property.getEndIndex()) {
                    answer = null;
                    break;
                }
                answer = before + after;
            }
            return answer;
        }

        private Property readProperty(String input) {
            int suffix = this.getSuffixIndex(input);
            if (suffix == -1) {
                if (this.getMatchingPrefixIndex(input, input.length()) != -1) {
                    throw new IllegalArgumentException(String.format("Missing %s from the text: %s", "}}", input));
                }
                return null;
            }
            int prefix = this.getMatchingPrefixIndex(input, suffix);
            if (prefix == -1) {
                throw new IllegalArgumentException(String.format("Missing %s from the text: %s", "{{", input));
            }
            String key = input.substring(prefix + "{{".length(), suffix);
            String value = this.getPropertyValue(key, input);
            return new Property(prefix, suffix + "}}".length(), key, value);
        }

        private int getSuffixIndex(String input) {
            int index = -1;
            while ((index = input.indexOf("}}", index + 1)) != -1 && this.isQuoted(input, index, "}}")) {
            }
            return index;
        }

        private int getMatchingPrefixIndex(String input, int suffixIndex) {
            int index = suffixIndex;
            while ((index = input.lastIndexOf("{{", index - 1)) != -1 && this.isQuoted(input, index, "{{")) {
            }
            return index;
        }

        private boolean isQuoted(String input, int index, String token) {
            int beforeIndex = index - 1;
            int afterIndex = index + token.length();
            if (beforeIndex >= 0 && afterIndex < input.length()) {
                char after;
                char before = input.charAt(beforeIndex);
                return before == (after = input.charAt(afterIndex)) && (before == '\'' || before == '\"');
            }
            return false;
        }

        private String getPropertyValue(String key, String input) {
            String value;
            boolean optional;
            if (DefaultPropertiesParser.this.propertiesComponent != null) {
                for (PropertiesFunction function : DefaultPropertiesParser.this.propertiesComponent.getFunctions().values()) {
                    String token = function.getName() + DefaultPropertiesParser.GET_OR_ELSE_TOKEN;
                    if (!key.startsWith(token)) continue;
                    String remainder = key.substring(token.length());
                    DefaultPropertiesParser.this.log.debug("Property with key [{}] is applied by function [{}]", (Object)key, (Object)function.getName());
                    String value2 = function.apply(remainder);
                    if (value2 == null) {
                        throw new IllegalArgumentException("Property with key [" + key + "] using function [" + function.getName() + "] returned null value which is not allowed, from input: " + input);
                    }
                    if (DefaultPropertiesParser.this.log.isDebugEnabled()) {
                        DefaultPropertiesParser.this.log.debug("Property with key [{}] applied by function [{}] -> {}", new Object[]{key, function.getName(), value2});
                    }
                    return value2;
                }
            }
            String defaultValue = null;
            if (this.defaultFallbackEnabled && key.contains(DefaultPropertiesParser.GET_OR_ELSE_TOKEN)) {
                defaultValue = StringHelper.after((String)key, (String)DefaultPropertiesParser.GET_OR_ELSE_TOKEN);
                key = StringHelper.before((String)key, (String)DefaultPropertiesParser.GET_OR_ELSE_TOKEN);
            }
            boolean bl = optional = key != null && key.startsWith("?");
            if (optional) {
                key = key.substring("?".length());
            }
            if ((value = this.doGetPropertyValue(key)) == null && defaultValue != null) {
                DefaultPropertiesParser.this.log.debug("Property with key [{}] not found, using default value: {}", (Object)key, (Object)defaultValue);
                value = defaultValue;
            }
            if (value == null) {
                if (!optional) {
                    StringBuilder esb = new StringBuilder();
                    esb.append("Property with key [").append(key).append("] ");
                    esb.append("not found in properties from text: ").append(input);
                    throw new IllegalArgumentException(esb.toString());
                }
                if (this.keepUnresolvedOptional) {
                    return "@@[?" + key + DefaultPropertiesParser.UNRESOLVED_SUFFIX_TOKEN;
                }
                return null;
            }
            return value;
        }

        private String doGetPropertyValue(String key) {
            String answer;
            int sysMode;
            if (ObjectHelper.isEmpty((Object)key)) {
                return DefaultPropertiesParser.this.parseProperty(key, null, this.properties);
            }
            String value = null;
            int envMode = DefaultPropertiesParser.this.propertiesComponent != null ? DefaultPropertiesParser.this.propertiesComponent.getEnvironmentVariableMode() : 1;
            int n = sysMode = DefaultPropertiesParser.this.propertiesComponent != null ? DefaultPropertiesParser.this.propertiesComponent.getSystemPropertiesMode() : 2;
            if (envMode == 2 && (value = IOHelper.lookupEnvironmentVariable((String)key)) != null) {
                DefaultPropertiesParser.this.log.debug("Found an OS environment property: {} with value: {} to be used.", (Object)key, (Object)value);
            }
            if (value == null && sysMode == 2 && (value = System.getProperty(key)) != null) {
                DefaultPropertiesParser.this.log.debug("Found a JVM system property: {} with value: {} to be used.", (Object)key, (Object)value);
            }
            if (value == null && this.properties != null && (value = this.properties.lookup(key)) != null) {
                DefaultPropertiesParser.this.log.debug("Found property: {} with value: {} to be used.", (Object)key, (Object)value);
            }
            if (value == null && envMode == 1 && (value = IOHelper.lookupEnvironmentVariable((String)key)) != null) {
                DefaultPropertiesParser.this.log.debug("Found an OS environment property: {} with value: {} to be used.", (Object)key, (Object)value);
            }
            if (value == null && sysMode == 1 && (value = System.getProperty(key)) != null) {
                DefaultPropertiesParser.this.log.debug("Found a JVM system property: {} with value: {} to be used.", (Object)key, (Object)value);
            }
            if ((answer = DefaultPropertiesParser.this.parseProperty(key, value, this.properties)) == null) {
                answer = value;
            }
            return answer;
        }
    }
}

