/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.engine.DefaultEndpointUtilizationStatistics;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public class DefaultRuntimeEndpointRegistry
extends EventNotifierSupport
implements CamelContextAware,
RuntimeEndpointRegistry {
    private CamelContext camelContext;
    private Map<String, Set<String>> inputs;
    private Map<String, Map<String, String>> outputs;
    private int limit = 1000;
    private boolean enabled = true;
    private volatile boolean extended;
    private EndpointUtilizationStatistics inputUtilization;
    private EndpointUtilizationStatistics outputUtilization;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getAllEndpoints(boolean includeInputs) {
        ArrayList answer = new ArrayList();
        if (includeInputs) {
            for (Map.Entry<String, Object> entry : this.inputs.entrySet()) {
                answer.addAll((Collection)entry.getValue());
            }
        }
        for (Map.Entry<String, Object> entry : this.outputs.entrySet()) {
            answer.addAll(((Map)entry.getValue()).keySet());
        }
        return Collections.unmodifiableList(answer);
    }

    public List<String> getEndpointsPerRoute(String routeId, boolean includeInputs) {
        Object uris;
        ArrayList answer = new ArrayList();
        if (includeInputs && (uris = this.inputs.get(routeId)) != null) {
            answer.addAll(uris);
        }
        if ((uris = this.outputs.get(routeId)) != null) {
            answer.addAll(uris.keySet());
        }
        return Collections.unmodifiableList(answer);
    }

    public List<RuntimeEndpointRegistry.Statistic> getEndpointStatistics() {
        String key;
        Long hits;
        String routeId;
        ArrayList<RuntimeEndpointRegistry.Statistic> answer = new ArrayList<RuntimeEndpointRegistry.Statistic>();
        for (Map.Entry<String, Set<String>> entry : this.inputs.entrySet()) {
            routeId = entry.getKey();
            for (String uri : entry.getValue()) {
                hits = 0L;
                if (this.extended && (key = DefaultRuntimeEndpointRegistry.asUtilizationKey(routeId, uri)) != null && (hits = (Long)this.inputUtilization.getStatistics().get(key)) == null) {
                    hits = 0L;
                }
                answer.add(new EndpointRuntimeStatistics(uri, routeId, "in", hits));
            }
        }
        for (Map.Entry<String, Object> entry : this.outputs.entrySet()) {
            routeId = entry.getKey();
            for (String uri : ((Map)entry.getValue()).keySet()) {
                hits = 0L;
                if (this.extended && (key = DefaultRuntimeEndpointRegistry.asUtilizationKey(routeId, uri)) != null && (hits = (Long)this.outputUtilization.getStatistics().get(key)) == null) {
                    hits = 0L;
                }
                answer.add(new EndpointRuntimeStatistics(uri, routeId, "out", hits));
            }
        }
        return answer;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void clear() {
        this.inputs.clear();
        this.outputs.clear();
        this.reset();
    }

    public void reset() {
        if (this.inputUtilization != null) {
            this.inputUtilization.clear();
        }
        if (this.outputUtilization != null) {
            this.outputUtilization.clear();
        }
    }

    public int size() {
        int total = this.inputs.values().size();
        return total += this.outputs.values().size();
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext", (Object)((Object)this));
        if (this.inputs == null) {
            this.inputs = new HashMap<String, Set<String>>();
        }
        if (this.outputs == null) {
            this.outputs = new HashMap<String, Map<String, String>>();
        }
        if (this.getCamelContext().getManagementStrategy() != null && this.getCamelContext().getManagementStrategy().getManagementAgent() != null) {
            this.extended = this.getCamelContext().getManagementStrategy().getManagementAgent().getStatisticsLevel().isExtended();
        }
        if (this.extended) {
            this.inputUtilization = new DefaultEndpointUtilizationStatistics(this.limit);
            this.outputUtilization = new DefaultEndpointUtilizationStatistics(this.limit);
        }
        if (this.extended) {
            this.log.info("Runtime endpoint registry is in extended mode gathering usage statistics of all incoming and outgoing endpoints (cache limit: {})", (Object)this.limit);
        } else {
            this.log.info("Runtime endpoint registry is in normal mode gathering information of all incoming and outgoing endpoints (cache limit: {})", (Object)this.limit);
        }
        ServiceHelper.startService((Object[])new Object[]{this.inputUtilization, this.outputUtilization});
    }

    protected void doStop() throws Exception {
        this.clear();
        ServiceHelper.stopService((Object[])new Object[]{this.inputUtilization, this.outputUtilization});
    }

    public void notify(CamelEvent event) throws Exception {
        if (event instanceof CamelEvent.RouteAddedEvent) {
            CamelEvent.RouteAddedEvent rse = (CamelEvent.RouteAddedEvent)event;
            Endpoint endpoint = rse.getRoute().getEndpoint();
            String routeId = rse.getRoute().getId();
            HashSet<String> uris = new HashSet<String>();
            uris.add(endpoint.getEndpointUri());
            this.inputs.put(routeId, uris);
            this.outputs.put(routeId, LRUCacheFactory.newLRUCache((int)this.limit));
        } else if (event instanceof CamelEvent.RouteRemovedEvent) {
            String uri;
            String key;
            CamelEvent.RouteRemovedEvent rse = (CamelEvent.RouteRemovedEvent)event;
            String routeId = rse.getRoute().getId();
            this.inputs.remove(routeId);
            this.outputs.remove(routeId);
            if (this.extended && (key = DefaultRuntimeEndpointRegistry.asUtilizationKey(routeId, uri = rse.getRoute().getEndpoint().getEndpointUri())) != null) {
                this.inputUtilization.remove(key);
            }
        } else if (this.extended && event instanceof CamelEvent.ExchangeCreatedEvent) {
            String uri;
            String routeId;
            String key;
            CamelEvent.ExchangeCreatedEvent ece = (CamelEvent.ExchangeCreatedEvent)event;
            Endpoint endpoint = ece.getExchange().getFromEndpoint();
            if (endpoint != null && (key = DefaultRuntimeEndpointRegistry.asUtilizationKey(routeId = ece.getExchange().getFromRouteId(), uri = endpoint.getEndpointUri())) != null) {
                this.inputUtilization.onHit(key);
            }
        } else if (event instanceof CamelEvent.ExchangeSendingEvent) {
            String key;
            CamelEvent.ExchangeSendingEvent ese = (CamelEvent.ExchangeSendingEvent)event;
            Endpoint endpoint = ese.getEndpoint();
            String routeId = this.getRouteId(ese.getExchange());
            String uri = endpoint.getEndpointUri();
            Map<String, String> uris = this.outputs.get(routeId);
            if (uris != null && !uris.containsKey(uri)) {
                uris.put(uri, uri);
            }
            if (this.extended && (key = DefaultRuntimeEndpointRegistry.asUtilizationKey(routeId, uri)) != null) {
                this.outputUtilization.onHit(key);
            }
        }
    }

    private String getRouteId(Exchange exchange) {
        RouteContext rc;
        String answer = null;
        UnitOfWork uow = exchange.getUnitOfWork();
        RouteContext routeContext = rc = uow != null ? uow.getRouteContext() : null;
        if (rc != null) {
            answer = rc.getRouteId();
        }
        if (answer == null) {
            answer = exchange.getFromRouteId();
        }
        return answer;
    }

    public boolean isDisabled() {
        return !this.enabled;
    }

    public boolean isEnabled(CamelEvent event) {
        return this.enabled && event instanceof CamelEvent.ExchangeCreatedEvent || event instanceof CamelEvent.ExchangeSendingEvent || event instanceof CamelEvent.RouteAddedEvent || event instanceof CamelEvent.RouteRemovedEvent;
    }

    private static String asUtilizationKey(String routeId, String uri) {
        if (routeId == null || uri == null) {
            return null;
        }
        return routeId + "|" + uri;
    }

    private static final class EndpointRuntimeStatistics
    implements RuntimeEndpointRegistry.Statistic {
        private final String uri;
        private final String routeId;
        private final String direction;
        private final long hits;

        private EndpointRuntimeStatistics(String uri, String routeId, String direction, long hits) {
            this.uri = uri;
            this.routeId = routeId;
            this.direction = direction;
            this.hits = hits;
        }

        public String getUri() {
            return this.uri;
        }

        public String getRouteId() {
            return this.routeId;
        }

        public String getDirection() {
            return this.direction;
        }

        public long getHits() {
            return this.hits;
        }
    }
}

