/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Map;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.processor.UnitOfWorkProducer;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.RouteContext;

public class DefaultProcessorFactory
implements ProcessorFactory {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/model/";

    public Processor createChildProcessor(RouteContext routeContext, NamedNode definition, boolean mandatory) throws Exception {
        String name = definition.getClass().getSimpleName();
        FactoryFinder finder = ((ExtendedCamelContext)routeContext.getCamelContext().adapt(ExtendedCamelContext.class)).getFactoryFinder(RESOURCE_PATH);
        try {
            Optional object;
            if (finder != null && (object = finder.newInstance(name)) instanceof ProcessorFactory) {
                ProcessorFactory pc = (ProcessorFactory)object;
                return pc.createChildProcessor(routeContext, definition, mandatory);
            }
        }
        catch (NoFactoryAvailableException noFactoryAvailableException) {
            // empty catch block
        }
        return null;
    }

    public Processor createProcessor(RouteContext routeContext, NamedNode definition) throws Exception {
        ProcessorFactory pc;
        String name = definition.getClass().getSimpleName();
        FactoryFinder finder = ((ExtendedCamelContext)routeContext.getCamelContext().adapt(ExtendedCamelContext.class)).getFactoryFinder(RESOURCE_PATH);
        if (finder != null && (pc = (ProcessorFactory)finder.newInstance(name, ProcessorFactory.class).orElse(null)) != null) {
            return pc.createProcessor(routeContext, definition);
        }
        return null;
    }

    public Processor createProcessor(CamelContext camelContext, String definitionName, Map<String, Object> args) throws Exception {
        SendDynamicProcessor answer = null;
        if ("SendDynamicProcessor".equals(definitionName)) {
            String uri = (String)args.get("uri");
            Expression expression = (Expression)args.get("expression");
            ExchangePattern exchangePattern = (ExchangePattern)args.get("exchangePattern");
            answer = new SendDynamicProcessor(uri, expression);
            answer.setCamelContext(camelContext);
            if (exchangePattern != null) {
                answer.setPattern(exchangePattern);
            }
        } else if ("UnitOfWorkProducer".equals(definitionName)) {
            Producer producer = (Producer)args.get("producer");
            return new UnitOfWorkProducer(producer);
        }
        return answer;
    }
}

