/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelDependencyInjectionAnnotationFactory;
import org.apache.camel.support.PluginHelper;

public class DefaultDependencyInjectionAnnotationFactory
implements CamelDependencyInjectionAnnotationFactory,
CamelContextAware {
    private CamelContext camelContext;

    public DefaultDependencyInjectionAnnotationFactory(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Runnable createBindToRegistryFactory(String id, Object bean, Class<?> beanType, String beanName, boolean beanPostProcess, String initMethod, String destroyMethod) {
        return () -> {
            if (beanPostProcess) {
                try {
                    CamelBeanPostProcessor beanPostProcessor = PluginHelper.getBeanPostProcessor((CamelContext)this.camelContext);
                    beanPostProcessor.postProcessBeforeInitialization(bean, beanName);
                    beanPostProcessor.postProcessAfterInitialization(bean, beanName);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                }
            }
            CamelContextAware.trySetCamelContext((Object)bean, (CamelContext)this.camelContext);
            if (bean instanceof Supplier) {
                Supplier sup = (Supplier)bean;
                this.camelContext.getRegistry().bind(id, beanType, sup);
            } else if (initMethod != null || destroyMethod != null) {
                this.camelContext.getRegistry().bind(id, bean, initMethod, destroyMethod);
            } else {
                this.camelContext.getRegistry().bind(id, bean);
            }
        };
    }
}

