/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RouteConfigurationsBuilder;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.Service;
import org.apache.camel.StaticService;
import org.apache.camel.spi.ExtendedRoutesBuilderLoader;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.ModelineFactory;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.RoutesBuilderLoader;
import org.apache.camel.spi.RoutesLoader;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.ResolverHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRoutesLoader
extends ServiceSupport
implements RoutesLoader,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRoutesLoader.class);
    public static final String ROUTES_LOADER_KEY_PREFIX = "routes-builder-loader-";
    private final Map<String, RoutesBuilderLoader> loaders;
    private CamelContext camelContext;
    private boolean ignoreLoadingError;

    public DefaultRoutesLoader() {
        this(null);
    }

    public DefaultRoutesLoader(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.loaders = new ConcurrentHashMap<String, RoutesBuilderLoader>();
    }

    public void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService(this.loaders.values());
        this.loaders.clear();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isIgnoreLoadingError() {
        return this.ignoreLoadingError;
    }

    public void setIgnoreLoadingError(boolean ignoreLoadingError) {
        this.ignoreLoadingError = ignoreLoadingError;
    }

    public Collection<RoutesBuilder> findRoutesBuilders(Collection<Resource> resources) throws Exception {
        return this.findRoutesBuilders(resources, false);
    }

    public Collection<RoutesBuilder> findRoutesBuilders(Collection<Resource> resources, boolean optional) throws Exception {
        List files;
        Object extLoader;
        ArrayList<RoutesBuilder> answer = new ArrayList<RoutesBuilder>(resources.size());
        ArrayList<Resource> sort = new ArrayList<Resource>(resources);
        sort.sort((o1, o2) -> {
            String ext1 = FileUtil.onlyExt((String)o1.getLocation(), (boolean)false);
            String ext2 = FileUtil.onlyExt((String)o2.getLocation(), (boolean)false);
            if ("java".equals(ext1)) {
                return -1;
            }
            if ("java".equals(ext2)) {
                return 1;
            }
            return 0;
        });
        LinkedHashMap<RoutesBuilderLoader, Object> groups = new LinkedHashMap<RoutesBuilderLoader, Object>();
        for (Resource resource : sort) {
            RoutesBuilderLoader routesBuilderLoader = this.resolveRoutesBuilderLoader(resource, optional);
            if (routesBuilderLoader == null) continue;
            List list = groups.getOrDefault(routesBuilderLoader, new ArrayList());
            list.add(resource);
            groups.put(routesBuilderLoader, list);
        }
        if (this.camelContext.isModeline().booleanValue()) {
            ModelineFactory factory = PluginHelper.getModelineFactory((CamelContext)this.camelContext);
            for (Map.Entry entry : groups.entrySet()) {
                for (Resource resource : (List)entry.getValue()) {
                    factory.parseModeline(resource);
                }
            }
        }
        for (Map.Entry entry : groups.entrySet()) {
            RoutesBuilderLoader routesBuilderLoader = (RoutesBuilderLoader)entry.getKey();
            if (routesBuilderLoader instanceof ExtendedRoutesBuilderLoader) {
                extLoader = (ExtendedRoutesBuilderLoader)routesBuilderLoader;
                files = (List)entry.getValue();
                try {
                    extLoader.preParseRoutes((Collection)files);
                    continue;
                }
                catch (Exception e) {
                    if (this.isIgnoreLoadingError()) {
                        LOG.warn("Loading resources error: {} due to: {}. This exception is ignored.", (Object)files, (Object)e.getMessage());
                        continue;
                    }
                    throw e;
                }
            }
            for (Resource resource : (List)entry.getValue()) {
                try {
                    routesBuilderLoader.preParseRoute(resource);
                }
                catch (Exception e) {
                    if (this.isIgnoreLoadingError()) {
                        LOG.warn("Loading resources error: {} due to: {}. This exception is ignored.", (Object)resource, (Object)e.getMessage());
                        continue;
                    }
                    throw e;
                }
            }
        }
        for (Map.Entry entry : groups.entrySet()) {
            RoutesBuilderLoader routesBuilderLoader = (RoutesBuilderLoader)entry.getKey();
            if (routesBuilderLoader instanceof ExtendedRoutesBuilderLoader) {
                extLoader = (ExtendedRoutesBuilderLoader)routesBuilderLoader;
                files = (List)entry.getValue();
                try {
                    Collection builders = extLoader.loadRoutesBuilders((Collection)files);
                    if (builders == null) continue;
                    answer.addAll(builders);
                    continue;
                }
                catch (Exception e) {
                    if (this.isIgnoreLoadingError()) {
                        LOG.warn("Loading resources error: {} due to: {}. This exception is ignored.", (Object)files, (Object)e.getMessage());
                        continue;
                    }
                    throw e;
                }
            }
            for (Resource resource : (List)entry.getValue()) {
                try {
                    RoutesBuilder builder = routesBuilderLoader.loadRoutesBuilder(resource);
                    if (builder == null) continue;
                    answer.add(builder);
                }
                catch (Exception e) {
                    if (this.isIgnoreLoadingError()) {
                        LOG.warn("Loading resources error: {} due to: {}. This exception is ignored.", (Object)resource, (Object)e.getMessage());
                        continue;
                    }
                    throw e;
                }
            }
        }
        return answer;
    }

    public void preParseRoute(Resource resource, boolean optional) throws Exception {
        RoutesBuilderLoader loader = this.resolveRoutesBuilderLoader(resource, optional);
        if (loader != null) {
            loader.preParseRoute(resource);
        }
    }

    public RoutesBuilderLoader getRoutesLoader(String extension) throws Exception {
        ObjectHelper.notNull((Object)extension, (String)"extension");
        RoutesBuilderLoader answer = (RoutesBuilderLoader)this.getCamelContext().getRegistry().lookupByNameAndType(ROUTES_LOADER_KEY_PREFIX + extension, RoutesBuilderLoader.class);
        if (answer == null) {
            answer = this.loaders.values().stream().filter(l -> l.isSupportedExtension(extension)).findFirst().orElse(this.loaders.computeIfAbsent(extension, this::resolveService));
        }
        return answer;
    }

    protected RoutesBuilderLoader resolveService(String extension) {
        CamelContext ecc = this.getCamelContext();
        for (RoutesBuilderLoader loader : ecc.getRegistry().findByType(RoutesBuilderLoader.class)) {
            if (!loader.isSupportedExtension(extension)) continue;
            return loader;
        }
        FactoryFinder finder = ecc.getCamelContextExtension().getBootstrapFactoryFinder("META-INF/services/org/apache/camel/routes-loader/");
        String sanitized = extension.replace(".", "-");
        RoutesBuilderLoader answer = ResolverHelper.resolveService((CamelContext)this.getCamelContext(), (FactoryFinder)finder, (String)sanitized, RoutesBuilderLoader.class).orElse(null);
        if (answer == null && extension.contains(".")) {
            String single = FileUtil.onlyExt((String)extension, (boolean)true);
            answer = ResolverHelper.resolveService((CamelContext)this.getCamelContext(), (FactoryFinder)finder, (String)single, RoutesBuilderLoader.class).orElse(null);
            if (answer != null && !answer.isSupportedExtension(extension)) {
                answer = null;
            }
        }
        if (answer != null) {
            CamelContextAware.trySetCamelContext((Object)answer, (CamelContext)this.getCamelContext());
            this.initRoutesBuilderLoader(answer);
            ServiceHelper.startService((Service)answer);
        }
        return answer;
    }

    public Set<String> updateRoutes(Collection<Resource> resources) throws Exception {
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        if (resources == null || resources.isEmpty()) {
            return answer;
        }
        Collection<RoutesBuilder> builders = this.findRoutesBuilders(resources);
        for (RoutesBuilder builder : builders) {
            if (!(builder instanceof RouteConfigurationsBuilder)) continue;
            RouteConfigurationsBuilder rcb = (RouteConfigurationsBuilder)builder;
            rcb.updateRouteConfigurationsToCamelContext(this.getCamelContext());
        }
        for (RoutesBuilder builder : builders) {
            Set ids = builder.updateRoutesToCamelContext(this.getCamelContext());
            answer.addAll(ids);
        }
        return answer;
    }

    protected RoutesBuilderLoader resolveRoutesBuilderLoader(Resource resource, boolean optional) throws Exception {
        String extension = FileUtil.onlyExt((String)resource.getLocation(), (boolean)false);
        if (ObjectHelper.isEmpty((String)extension)) {
            throw new IllegalArgumentException("Unable to determine file extension for resource: " + resource.getLocation());
        }
        RoutesBuilderLoader loader = this.getRoutesLoader(extension);
        if (!optional && loader == null) {
            throw new IllegalArgumentException("Cannot find RoutesBuilderLoader in classpath supporting file extension: " + extension);
        }
        return loader;
    }
}

