/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.BeanConfigInject;
import org.apache.camel.BeanInject;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consume;
import org.apache.camel.Consumer;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.IsSingleton;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.NoSuchBeanTypeException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.PropertyInject;
import org.apache.camel.ProxyInstantiationException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.engine.DefaultConsumerTemplate;
import org.apache.camel.impl.engine.DefaultFluentProducerTemplate;
import org.apache.camel.impl.engine.DefaultProducerTemplate;
import org.apache.camel.impl.engine.SubscribeMethodProcessor;
import org.apache.camel.spi.BeanProxyFactory;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelPostProcessorHelper
implements CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(CamelPostProcessorHelper.class);
    private CamelContext camelContext;

    public CamelPostProcessorHelper() {
    }

    public CamelPostProcessorHelper(CamelContext camelContext) {
        this.setCamelContext(camelContext);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void consumerInjection(Method method, Object bean, String beanName) {
        Consume consume = method.getAnnotation(Consume.class);
        if (consume != null) {
            LOG.debug("Creating a consumer for: {}", (Object)consume);
            this.subscribeMethod(method, bean, beanName, consume.value(), consume.property(), consume.predicate());
        }
    }

    public void subscribeMethod(Method method, Object bean, String beanName, String endpointUri, String endpointProperty, String predicate) {
        String injectionPointName = method.getName();
        Endpoint endpoint = this.getEndpointInjection(bean, endpointUri, endpointProperty, injectionPointName, true);
        if (endpoint != null) {
            boolean multipleConsumer = false;
            if (endpoint instanceof MultipleConsumersSupport) {
                multipleConsumer = ((MultipleConsumersSupport)endpoint).isMultipleConsumersSupported();
            }
            try {
                SubscribeMethodProcessor processor = this.getConsumerProcessor(endpoint);
                if (multipleConsumer || processor == null) {
                    processor = new SubscribeMethodProcessor(endpoint);
                    endpoint.getCamelContext().addService((Object)processor, true);
                    processor.addMethod(bean, method, endpoint, predicate);
                    Consumer consumer = endpoint.createConsumer((Processor)processor);
                    this.startService((Service)consumer, endpoint.getCamelContext(), bean, beanName);
                } else {
                    processor.addMethod(bean, method, endpoint, predicate);
                }
                if (predicate != null) {
                    LOG.debug("Subscribed method: {} to consume from endpoint: {} with predicate: {}", new Object[]{method, endpoint, predicate});
                } else {
                    LOG.debug("Subscribed method: {} to consume from endpoint: {}", (Object)method, (Object)endpoint);
                }
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    protected void startService(Service service, CamelContext camelContext, Object bean, String beanName) throws Exception {
        if (camelContext != null) {
            camelContext.deferStartService((Object)service, true);
        } else {
            ServiceHelper.startService((Service)service);
        }
        boolean singleton = this.isSingleton(bean, beanName);
        if (!singleton) {
            LOG.debug("Service is not singleton so you must remember to stop it manually {}", (Object)service);
        }
    }

    protected SubscribeMethodProcessor getConsumerProcessor(Endpoint endpoint) {
        Set processors = endpoint.getCamelContext().hasServices(SubscribeMethodProcessor.class);
        return processors.stream().filter(s -> s.getEndpoint() == endpoint).findFirst().orElse(null);
    }

    public Endpoint getEndpointInjection(Object bean, String uri, String propertyName, String injectionPointName, boolean mandatory) {
        Endpoint answer = org.apache.camel.util.ObjectHelper.isEmpty((String)uri) ? this.doGetEndpointInjection(bean, propertyName, injectionPointName) : this.doGetEndpointInjection(uri, injectionPointName, mandatory);
        if (answer instanceof DelegateEndpoint) {
            answer = ((DelegateEndpoint)answer).getEndpoint();
        }
        return answer;
    }

    private Endpoint doGetEndpointInjection(String uri, String injectionPointName, boolean mandatory) {
        return CamelContextHelper.getEndpointInjection((CamelContext)this.getCamelContext(), (String)uri, (String)injectionPointName, (boolean)mandatory);
    }

    private Endpoint doGetEndpointInjection(Object bean, String propertyName, String injectionPointName) {
        if (org.apache.camel.util.ObjectHelper.isEmpty((String)propertyName)) {
            propertyName = injectionPointName;
        }
        try {
            Object value = PluginHelper.getBeanIntrospection((CamelContext)this.getCamelContext()).getOrElseProperty(bean, propertyName, null, false);
            if (value == null) {
                value = PluginHelper.getBeanIntrospection((CamelContext)this.getCamelContext()).getOrElseProperty(bean, propertyName + "Endpoint", null, false);
            }
            if (value == null && propertyName.startsWith("on")) {
                propertyName = propertyName.substring(2);
                return this.doGetEndpointInjection(bean, propertyName, injectionPointName);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof Endpoint) {
                return (Endpoint)value;
            }
            String uriOrRef = (String)this.getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, value);
            return this.getCamelContext().getEndpoint(uriOrRef);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error getting property " + propertyName + " from bean " + bean + " due " + e.getMessage(), e);
        }
    }

    public Object getInjectionValue(Class<?> type, String endpointUri, String endpointProperty, String injectionPointName, Object bean, String beanName) {
        return this.getInjectionValue(type, endpointUri, endpointProperty, injectionPointName, bean, beanName, true);
    }

    public Object getInjectionValue(Class<?> type, String endpointUri, String endpointProperty, String injectionPointName, Object bean, String beanName, boolean binding) {
        if (type.isAssignableFrom(ProducerTemplate.class)) {
            return this.createInjectionProducerTemplate(endpointUri, endpointProperty, injectionPointName, bean);
        }
        if (type.isAssignableFrom(FluentProducerTemplate.class)) {
            return this.createInjectionFluentProducerTemplate(endpointUri, endpointProperty, injectionPointName, bean);
        }
        if (type.isAssignableFrom(ConsumerTemplate.class)) {
            return this.createInjectionConsumerTemplate(endpointUri, endpointProperty, injectionPointName);
        }
        Endpoint endpoint = this.getEndpointInjection(bean, endpointUri, endpointProperty, injectionPointName, true);
        if (endpoint != null) {
            if (type.isInstance(endpoint)) {
                return endpoint;
            }
            if (type.isAssignableFrom(Producer.class)) {
                return this.createInjectionProducer(endpoint, bean, beanName);
            }
            if (type.isAssignableFrom(PollingConsumer.class)) {
                return this.createInjectionPollingConsumer(endpoint, bean, beanName);
            }
            if (type.isInterface()) {
                try {
                    BeanProxyFactory factory = PluginHelper.getBeanProxyFactory((CamelContext)endpoint.getCamelContext());
                    return factory.createProxy(endpoint, binding, new Class[]{type});
                }
                catch (Exception e) {
                    throw this.createProxyInstantiationRuntimeException(type, endpoint, e);
                }
            }
            throw new IllegalArgumentException("Invalid type: " + type.getName() + " which cannot be injected via @EndpointInject/@Produce for: " + endpoint);
        }
        return null;
    }

    public Object getInjectionPropertyValue(Class<?> type, Type genericType, String propertyName, String propertyDefaultValue, String separator) {
        try {
            String prefix = "{{";
            String suffix = "}}";
            Object key = !propertyName.contains(prefix) ? prefix + propertyName + suffix : propertyName;
            String value = this.getCamelContext().resolvePropertyPlaceholders((String)key);
            if (value != null) {
                if (separator != null && !separator.isBlank()) {
                    Object values = CamelPostProcessorHelper.convertValueUsingSeparator(this.camelContext, type, genericType, value, separator);
                    return this.getCamelContext().getTypeConverter().mandatoryConvertTo(type, values);
                }
                return this.getCamelContext().getTypeConverter().mandatoryConvertTo(type, (Object)value);
            }
            return null;
        }
        catch (Exception e) {
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((String)propertyDefaultValue)) {
                try {
                    if (separator != null && !separator.isBlank()) {
                        Object values = CamelPostProcessorHelper.convertValueUsingSeparator(this.camelContext, type, genericType, propertyDefaultValue, separator);
                        return this.getCamelContext().getTypeConverter().mandatoryConvertTo(type, values);
                    }
                    return this.getCamelContext().getTypeConverter().mandatoryConvertTo(type, (Object)propertyDefaultValue);
                }
                catch (Exception e2) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e2);
                }
            }
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    private static Object convertValueUsingSeparator(CamelContext camelContext, Class<?> type, Type genericType, String value, String separator) throws NoTypeConversionAvailableException {
        if (type.isArray()) {
            return CamelPostProcessorHelper.convertArrayUsingSeparator(camelContext, type, value, separator);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return CamelPostProcessorHelper.convertCollectionUsingSeparator(camelContext, type, genericType, value, separator);
        }
        if (Map.class.isAssignableFrom(type)) {
            return CamelPostProcessorHelper.convertMapUsingSeparator(camelContext, genericType, value, separator);
        }
        return null;
    }

    private static Map<String, Object> convertMapUsingSeparator(CamelContext camelContext, Type genericType, String value, String separator) throws NoTypeConversionAvailableException {
        String[] arr;
        Class ct = Object.class;
        if (genericType != null) {
            Class clazz;
            String name = StringHelper.between((String)genericType.getTypeName(), (String)"<", (String)">");
            if ((name = StringHelper.afterLast((String)name, (String)",")) != null && (clazz = camelContext.getClassResolver().resolveClass(name.trim())) != null) {
                ct = clazz;
            }
        }
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (String s : arr = value.split(separator)) {
            String v = s.trim();
            if (!v.contains("=")) continue;
            String k = StringHelper.before((String)v, (String)"=").trim();
            String e = StringHelper.after((String)v, (String)"=").trim();
            values.put(k, camelContext.getTypeConverter().mandatoryConvertTo(ct, (Object)e));
        }
        return values;
    }

    private static Collection<?> convertCollectionUsingSeparator(CamelContext camelContext, Class<?> type, Type genericType, String value, String separator) throws NoTypeConversionAvailableException {
        String[] arr;
        boolean set;
        Class clazz;
        String name;
        Class ct = Object.class;
        if (genericType != null && (name = StringHelper.between((String)genericType.getTypeName(), (String)"<", (String)">")) != null && (clazz = camelContext.getClassResolver().resolveClass(name.trim())) != null) {
            ct = clazz;
        }
        AbstractCollection values = (set = type.isAssignableFrom(Set.class)) ? new LinkedHashSet() : new ArrayList();
        for (String s : arr = value.split(separator)) {
            String v = s.trim();
            values.add(camelContext.getTypeConverter().mandatoryConvertTo(ct, (Object)v));
        }
        return values;
    }

    private static Object[] convertArrayUsingSeparator(CamelContext camelContext, Class<?> type, String value, String separator) throws NoTypeConversionAvailableException {
        String[] arr = value.split(separator);
        Object[] values = new Object[arr.length];
        Class<?> ct = type.getComponentType();
        for (int i = 0; i < arr.length; ++i) {
            String v = arr[i].trim();
            values[i] = camelContext.getTypeConverter().mandatoryConvertTo(ct, (Object)v);
        }
        return values;
    }

    public Object getInjectionBeanValue(Class<?> type, String name) {
        if (org.apache.camel.util.ObjectHelper.isEmpty((String)name)) {
            Object found;
            if (this.getCamelContext() != null && type.isAssignableFrom(this.getCamelContext().getClass())) {
                return this.getCamelContext();
            }
            Object object = found = this.getCamelContext() != null ? this.getCamelContext().getRegistry().findSingleByType(type) : null;
            if (found == null) {
                if (this.getCamelContext() != null && type.isAssignableFrom(Registry.class)) {
                    return this.getCamelContext().getRegistry();
                }
                if (this.getCamelContext() != null && type.isAssignableFrom(TypeConverter.class)) {
                    return this.getCamelContext().getTypeConverter();
                }
                FluentProducerTemplate answer = null;
                if (this.getCamelContext() != null && type.isAssignableFrom(FluentProducerTemplate.class)) {
                    answer = this.getCamelContext().createFluentProducerTemplate();
                }
                if (this.getCamelContext() != null && type.isAssignableFrom(ProducerTemplate.class)) {
                    answer = this.getCamelContext().createProducerTemplate();
                }
                if (this.getCamelContext() != null && type.isAssignableFrom(ConsumerTemplate.class)) {
                    answer = this.getCamelContext().createConsumerTemplate();
                }
                if (answer != null) {
                    try {
                        this.getCamelContext().addService((Object)answer);
                    }
                    catch (Exception e) {
                        throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                    }
                    return answer;
                }
                throw new NoSuchBeanTypeException(type);
            }
            return found;
        }
        return CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)name, type);
    }

    public Object getInjectionBeanConfigValue(Class<?> type, String name) {
        String[] names;
        String rootKey;
        CamelContext ecc = this.getCamelContext();
        boolean mapType = false;
        Map<String, String> map = null;
        if (type.isAssignableFrom(Map.class)) {
            map = new LinkedHashMap();
            mapType = true;
        } else if (type.isAssignableFrom(Properties.class)) {
            map = new Properties();
            mapType = true;
        }
        Object bean = null;
        if (map == null && (bean = ecc.getRegistry().findSingleByType(type)) == null) {
            try {
                bean = ecc.getInjector().newInstance(type);
            }
            catch (Exception e) {
                return null;
            }
        }
        if ((rootKey = name).endsWith(".")) {
            rootKey = rootKey.substring(0, rootKey.length() - 1);
        }
        String uRootKey = rootKey.toUpperCase(Locale.US);
        Properties props = ecc.getPropertiesComponent().loadProperties();
        if (map == null) {
            map = new LinkedHashMap();
        }
        for (String key : props.stringPropertyNames()) {
            String uKey = key.toUpperCase(Locale.US);
            if (!uKey.startsWith(uRootKey)) continue;
            String sKey = key.substring(rootKey.length());
            if (sKey.startsWith(".")) {
                sKey = sKey.substring(1);
            }
            map.put(sKey, props.getProperty(key));
        }
        if (mapType) {
            return map;
        }
        PropertyConfigurer configurer = null;
        for (String n : names = new String[]{type.getName() + "-configurer", type.getSimpleName() + "-configurer", rootKey + "-configurer"}) {
            configurer = PluginHelper.getConfigurerResolver((CamelContext)ecc).resolvePropertyConfigurer(n, ecc);
            if (configurer != null) break;
        }
        new PropertyBindingSupport.Builder().withCamelContext(ecc).withIgnoreCase(true).withTarget(bean).withConfigurer(configurer).withProperties(map).bind();
        return bean;
    }

    public Object getInjectionBeanMethodValue(CamelContext context, Method method, Object bean, String beanName) {
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            throw new IllegalArgumentException("@BindToRegistry on class: " + method.getDeclaringClass() + " method: " + method.getName() + " with void return type is not allowed");
        }
        Object[] parameters = this.bindToRegistryParameterMapping(context, method);
        Object value = parameters != null ? ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])parameters) : ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[0]);
        return value;
    }

    private Object[] bindToRegistryParameterMapping(CamelContext context, Method method) {
        if (method.getParameterCount() == 0) {
            return null;
        }
        Object[] parameters = new Object[method.getParameterCount()];
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Class<Object> type = method.getParameterTypes()[i];
            Type genericType = method.getGenericParameterTypes()[i];
            if (type.isAssignableFrom(CamelContext.class)) {
                parameters[i] = context;
            } else if (type.isAssignableFrom(Registry.class)) {
                parameters[i] = context.getRegistry();
            } else if (type.isAssignableFrom(TypeConverter.class)) {
                parameters[i] = context.getTypeConverter();
            } else {
                Annotation[] anns = method.getParameterAnnotations()[i];
                if (anns.length == 1) {
                    Annotation ann = anns[0];
                    if (ann.annotationType() == PropertyInject.class) {
                        pi = (PropertyInject)ann;
                        parameters[i] = result = this.getInjectionPropertyValue(type, genericType, pi.value(), pi.defaultValue(), pi.separator());
                    } else if (ann.annotationType() == BeanConfigInject.class) {
                        pi = (BeanConfigInject)ann;
                        parameters[i] = result = this.getInjectionBeanConfigValue(type, pi.value());
                    } else if (ann.annotationType() == BeanInject.class) {
                        BeanInject bi = (BeanInject)ann;
                        parameters[i] = result = this.getInjectionBeanValue(type, bi.value());
                    }
                } else {
                    Set instances = context.getRegistry().findByType(type);
                    if (instances.size() == 1) {
                        parameters[i] = instances.iterator().next();
                    } else if (instances.size() > 1) {
                        throw new IllegalArgumentException("Multiple beans of the same type: " + type + " exists in the Camel registry. Specify the bean name on @BeanInject to bind to a single bean, at the method: " + method);
                    }
                }
            }
            if (parameters[i] != null) continue;
            int pos = i + 1;
            throw new IllegalArgumentException("@BindToProperty cannot bind parameter #" + pos + " on method: " + method);
        }
        return parameters;
    }

    protected ProducerTemplate createInjectionProducerTemplate(String endpointUri, String endpointProperty, String injectionPointName, Object bean) {
        Endpoint endpoint = this.getEndpointInjection(bean, endpointUri, endpointProperty, injectionPointName, false);
        CamelContext context = endpoint != null ? endpoint.getCamelContext() : this.getCamelContext();
        DefaultProducerTemplate answer = new DefaultProducerTemplate(context, endpoint);
        try {
            this.startService((Service)answer, context, bean, null);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    protected FluentProducerTemplate createInjectionFluentProducerTemplate(String endpointUri, String endpointProperty, String injectionPointName, Object bean) {
        Endpoint endpoint = this.getEndpointInjection(bean, endpointUri, endpointProperty, injectionPointName, false);
        CamelContext context = endpoint != null ? endpoint.getCamelContext() : this.getCamelContext();
        DefaultFluentProducerTemplate answer = new DefaultFluentProducerTemplate(context);
        answer.setDefaultEndpoint(endpoint);
        try {
            this.startService((Service)answer, context, bean, null);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    protected ConsumerTemplate createInjectionConsumerTemplate(String endpointUri, String endpointProperty, String injectionPointName) {
        DefaultConsumerTemplate answer = new DefaultConsumerTemplate(this.getCamelContext());
        try {
            this.startService((Service)answer, null, null, null);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    protected PollingConsumer createInjectionPollingConsumer(Endpoint endpoint, Object bean, String beanName) {
        try {
            PollingConsumer consumer = endpoint.createPollingConsumer();
            this.startService((Service)consumer, endpoint.getCamelContext(), bean, beanName);
            return consumer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    protected Producer createInjectionProducer(Endpoint endpoint, Object bean, String beanName) {
        try {
            return PluginHelper.getDeferServiceFactory((CamelContext)endpoint.getCamelContext()).createProducer(endpoint);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    protected RuntimeException createProxyInstantiationRuntimeException(Class<?> type, Endpoint endpoint, Exception e) {
        return new ProxyInstantiationException(type, endpoint, (Throwable)e);
    }

    protected boolean isSingleton(Object bean, String beanName) {
        if (bean instanceof IsSingleton) {
            IsSingleton singleton = (IsSingleton)bean;
            return singleton.isSingleton();
        }
        return true;
    }
}

