/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.TypeConverter;
import org.apache.camel.catalog.RuntimeCamelCatalog;
import org.apache.camel.console.DevConsoleRegistry;
import org.apache.camel.console.DevConsoleResolver;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckResolver;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.impl.engine.AbstractCamelContext;
import org.apache.camel.impl.engine.BaseExecutorServiceManager;
import org.apache.camel.impl.engine.DefaultAsyncProcessorAwaitManager;
import org.apache.camel.impl.engine.DefaultBeanIntrospection;
import org.apache.camel.impl.engine.DefaultCamelBeanPostProcessor;
import org.apache.camel.impl.engine.DefaultCamelContextNameStrategy;
import org.apache.camel.impl.engine.DefaultClassResolver;
import org.apache.camel.impl.engine.DefaultComponentNameResolver;
import org.apache.camel.impl.engine.DefaultComponentResolver;
import org.apache.camel.impl.engine.DefaultConfigurerResolver;
import org.apache.camel.impl.engine.DefaultDataFormatResolver;
import org.apache.camel.impl.engine.DefaultDependencyInjectionAnnotationFactory;
import org.apache.camel.impl.engine.DefaultDevConsoleResolver;
import org.apache.camel.impl.engine.DefaultEndpointRegistry;
import org.apache.camel.impl.engine.DefaultExchangeFactoryManager;
import org.apache.camel.impl.engine.DefaultFactoryFinderResolver;
import org.apache.camel.impl.engine.DefaultHeadersMapFactory;
import org.apache.camel.impl.engine.DefaultHealthCheckResolver;
import org.apache.camel.impl.engine.DefaultInflightRepository;
import org.apache.camel.impl.engine.DefaultInjector;
import org.apache.camel.impl.engine.DefaultInterceptEndpointFactory;
import org.apache.camel.impl.engine.DefaultLanguageResolver;
import org.apache.camel.impl.engine.DefaultManagementNameStrategy;
import org.apache.camel.impl.engine.DefaultMessageHistoryFactory;
import org.apache.camel.impl.engine.DefaultNodeIdFactory;
import org.apache.camel.impl.engine.DefaultPackageScanClassResolver;
import org.apache.camel.impl.engine.DefaultPackageScanResourceResolver;
import org.apache.camel.impl.engine.DefaultPeriodTaskResolver;
import org.apache.camel.impl.engine.DefaultPeriodTaskScheduler;
import org.apache.camel.impl.engine.DefaultReactiveExecutor;
import org.apache.camel.impl.engine.DefaultResourceLoader;
import org.apache.camel.impl.engine.DefaultRouteController;
import org.apache.camel.impl.engine.DefaultRouteFactory;
import org.apache.camel.impl.engine.DefaultRoutesLoader;
import org.apache.camel.impl.engine.DefaultShutdownStrategy;
import org.apache.camel.impl.engine.DefaultStreamCachingStrategy;
import org.apache.camel.impl.engine.DefaultTracer;
import org.apache.camel.impl.engine.DefaultTransformerRegistry;
import org.apache.camel.impl.engine.DefaultUnitOfWorkFactory;
import org.apache.camel.impl.engine.DefaultUriFactoryResolver;
import org.apache.camel.impl.engine.DefaultValidatorRegistry;
import org.apache.camel.impl.engine.DefaultVariableRepositoryFactory;
import org.apache.camel.impl.engine.PrototypeExchangeFactory;
import org.apache.camel.impl.engine.PrototypeProcessorExchangeFactory;
import org.apache.camel.impl.engine.TransformerKey;
import org.apache.camel.impl.engine.ValidatorKey;
import org.apache.camel.impl.engine.WebSpherePackageScanClassResolver;
import org.apache.camel.spi.AnnotationBasedProcessorFactory;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.BeanProcessorFactory;
import org.apache.camel.spi.BeanProxyFactory;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.apache.camel.spi.CamelDependencyInjectionAnnotationFactory;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.CliConnectorFactory;
import org.apache.camel.spi.ComponentNameResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.ConfigurerResolver;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.DeferServiceFactory;
import org.apache.camel.spi.DumpRoutesStrategy;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.ExchangeFactoryManager;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.InterceptEndpointFactory;
import org.apache.camel.spi.InternalProcessorFactory;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.ModelToXMLDumper;
import org.apache.camel.spi.ModelToYAMLDumper;
import org.apache.camel.spi.ModelineFactory;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.PeriodTaskResolver;
import org.apache.camel.spi.PeriodTaskScheduler;
import org.apache.camel.spi.ProcessorExchangeFactory;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.spi.RestBindingJaxbDataFormatFactory;
import org.apache.camel.spi.RestRegistryFactory;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RouteFactory;
import org.apache.camel.spi.RoutesLoader;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.Tracer;
import org.apache.camel.spi.TransformerRegistry;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.spi.UriFactoryResolver;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.spi.ValidatorRegistry;
import org.apache.camel.spi.VariableRepositoryFactory;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.DefaultUuidGenerator;
import org.apache.camel.support.NormalizedUri;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.ResolverHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCamelContext
extends AbstractCamelContext {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleCamelContext.class);

    public SimpleCamelContext() {
        this(true);
    }

    public SimpleCamelContext(boolean init) {
        super(init);
    }

    @Override
    public void disposeModel() {
    }

    @Override
    public void doBuild() throws Exception {
        super.doBuild();
        this.getCamelContextExtension().addContextPlugin(CliConnectorFactory.class, (Object)this.createCliConnectorFactory());
        this.getCamelContextExtension().addContextPlugin(ScheduledExecutorService.class, (Object)this.createErrorHandlerExecutorService());
    }

    @Override
    protected HealthCheckRegistry createHealthCheckRegistry() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"health-check/default-registry", HealthCheckRegistry.class);
        return result.orElse(null);
    }

    @Override
    protected DevConsoleRegistry createDevConsoleRegistry() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"dev-console/default-registry", DevConsoleRegistry.class);
        return result.orElse(null);
    }

    @Override
    protected TypeConverter createTypeConverter() {
        return new DefaultTypeConverter(this.getCamelContextReference(), PluginHelper.getPackageScanClassResolver((CamelContext)this), this.getInjector(), this.isLoadTypeConverters().booleanValue());
    }

    @Override
    protected TypeConverterRegistry createTypeConverterRegistry() {
        TypeConverter typeConverter = this.getTypeConverter();
        if (typeConverter == null) {
            typeConverter = this.createTypeConverter();
        }
        if (typeConverter instanceof TypeConverterRegistry) {
            return (TypeConverterRegistry)typeConverter;
        }
        return null;
    }

    @Override
    protected Injector createInjector() {
        FactoryFinder finder = this.getCamelContextExtension().getBootstrapFactoryFinder();
        Optional result = finder.newInstance("Injector", Injector.class);
        return result.orElseGet(() -> new DefaultInjector(this.getCamelContextReference()));
    }

    @Override
    protected PropertiesComponent createPropertiesComponent() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"properties-component-factory", PropertiesComponent.class);
        return result.orElseGet(org.apache.camel.component.properties.PropertiesComponent::new);
    }

    @Override
    protected CamelBeanPostProcessor createBeanPostProcessor() {
        return new DefaultCamelBeanPostProcessor(this.getCamelContextReference());
    }

    @Override
    protected CamelDependencyInjectionAnnotationFactory createDependencyInjectionAnnotationFactory() {
        return new DefaultDependencyInjectionAnnotationFactory(this.getCamelContextReference());
    }

    @Override
    protected ComponentResolver createComponentResolver() {
        return new DefaultComponentResolver();
    }

    @Override
    protected ComponentNameResolver createComponentNameResolver() {
        return new DefaultComponentNameResolver();
    }

    @Override
    protected Registry createRegistry() {
        return new DefaultRegistry();
    }

    @Override
    protected UuidGenerator createUuidGenerator() {
        return new DefaultUuidGenerator();
    }

    @Override
    protected ModelJAXBContextFactory createModelJAXBContextFactory() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"model-jaxbcontext-factory", ModelJAXBContextFactory.class);
        if (result.isPresent()) {
            return (ModelJAXBContextFactory)result.get();
        }
        throw new IllegalArgumentException("Cannot find ModelJAXBContextFactory on classpath. Add camel-xml-jaxb to classpath.");
    }

    @Override
    protected NodeIdFactory createNodeIdFactory() {
        return new DefaultNodeIdFactory();
    }

    @Override
    protected ModelineFactory createModelineFactory() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"dsl-modeline-factory", ModelineFactory.class);
        if (result.isPresent()) {
            return (ModelineFactory)result.get();
        }
        throw new IllegalArgumentException("Cannot find ModelineFactory on classpath. Add camel-dsl-modeline to classpath.");
    }

    @Override
    protected PeriodTaskResolver createPeriodTaskResolver() {
        FactoryFinder finder = PluginHelper.getFactoryFinderResolver((ExtendedCamelContext)this.getCamelContextExtension()).resolveBootstrapFactoryFinder(this.getClassResolver(), "META-INF/services/org/apache/camel/periodic-task/");
        return new DefaultPeriodTaskResolver(finder);
    }

    @Override
    protected PeriodTaskScheduler createPeriodTaskScheduler() {
        return new DefaultPeriodTaskScheduler();
    }

    @Override
    protected FactoryFinderResolver createFactoryFinderResolver() {
        return new DefaultFactoryFinderResolver();
    }

    @Override
    protected ClassResolver createClassResolver() {
        return new DefaultClassResolver(this.getCamelContextReference());
    }

    @Override
    protected ProcessorFactory createProcessorFactory() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"processor-factory", ProcessorFactory.class);
        if (result.isPresent()) {
            return (ProcessorFactory)result.get();
        }
        throw new IllegalArgumentException("Cannot find ProcessorFactory on classpath. Add camel-core-processor to classpath.");
    }

    @Override
    protected InternalProcessorFactory createInternalProcessorFactory() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"internal-processor-factory", InternalProcessorFactory.class);
        if (result.isPresent()) {
            return (InternalProcessorFactory)result.get();
        }
        throw new IllegalArgumentException("Cannot find InternalProcessorFactory on classpath. Add camel-core-processor to classpath.");
    }

    @Override
    protected InterceptEndpointFactory createInterceptEndpointFactory() {
        return new DefaultInterceptEndpointFactory();
    }

    @Override
    protected RouteFactory createRouteFactory() {
        return new DefaultRouteFactory();
    }

    @Override
    protected DataFormatResolver createDataFormatResolver() {
        return new DefaultDataFormatResolver();
    }

    @Override
    protected HealthCheckResolver createHealthCheckResolver() {
        return new DefaultHealthCheckResolver();
    }

    @Override
    protected DevConsoleResolver createDevConsoleResolver() {
        return new DefaultDevConsoleResolver();
    }

    @Override
    protected MessageHistoryFactory createMessageHistoryFactory() {
        return new DefaultMessageHistoryFactory();
    }

    @Override
    protected InflightRepository createInflightRepository() {
        return new DefaultInflightRepository();
    }

    @Override
    protected AsyncProcessorAwaitManager createAsyncProcessorAwaitManager() {
        return new DefaultAsyncProcessorAwaitManager();
    }

    @Override
    protected RouteController createRouteController() {
        return new DefaultRouteController(this.getCamelContextReference());
    }

    @Override
    protected ShutdownStrategy createShutdownStrategy() {
        return new DefaultShutdownStrategy(this.getCamelContextReference());
    }

    @Override
    protected PackageScanClassResolver createPackageScanClassResolver() {
        DefaultPackageScanClassResolver packageScanClassResolver;
        if (WebSpherePackageScanClassResolver.isWebSphereClassLoader(((Object)((Object)this)).getClass().getClassLoader())) {
            LOG.info("Using WebSphere specific PackageScanClassResolver");
            packageScanClassResolver = new WebSpherePackageScanClassResolver("META-INF/services/org/apache/camel/TypeConverter");
        } else {
            packageScanClassResolver = new DefaultPackageScanClassResolver();
        }
        return packageScanClassResolver;
    }

    @Override
    protected PackageScanResourceResolver createPackageScanResourceResolver() {
        return new DefaultPackageScanResourceResolver();
    }

    @Override
    protected UnitOfWorkFactory createUnitOfWorkFactory() {
        return new DefaultUnitOfWorkFactory();
    }

    @Override
    protected RuntimeCamelCatalog createRuntimeCamelCatalog() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"runtime-camelcatalog", RuntimeCamelCatalog.class);
        if (result.isPresent()) {
            return (RuntimeCamelCatalog)result.get();
        }
        throw new IllegalArgumentException("Cannot find RuntimeCamelCatalog on classpath. Add camel-core-catalog to classpath.");
    }

    @Override
    protected DumpRoutesStrategy createDumpRoutesStrategy() {
        DumpRoutesStrategy answer = (DumpRoutesStrategy)this.getCamelContextReference().hasService(DumpRoutesStrategy.class);
        if (answer != null) {
            return answer;
        }
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"dump-routes", DumpRoutesStrategy.class);
        if (result.isEmpty()) {
            result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"default-dump-routes", DumpRoutesStrategy.class);
        }
        if (result.isPresent()) {
            return (DumpRoutesStrategy)result.get();
        }
        throw new IllegalArgumentException("Cannot find DumpRoutesStrategy on classpath. Add camel-core-engine to classpath.");
    }

    @Override
    protected CamelContextNameStrategy createCamelContextNameStrategy() {
        return new DefaultCamelContextNameStrategy();
    }

    @Override
    protected ManagementNameStrategy createManagementNameStrategy() {
        return new DefaultManagementNameStrategy(this.getCamelContextReference());
    }

    @Override
    protected HeadersMapFactory createHeadersMapFactory() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"headers-map-factory", HeadersMapFactory.class);
        return result.orElseGet(DefaultHeadersMapFactory::new);
    }

    private CliConnectorFactory createCliConnectorFactory() {
        CliConnectorFactory ccf = (CliConnectorFactory)this.getCamelContextReference().getRegistry().findSingleByType(CliConnectorFactory.class);
        if (ccf != null) {
            return ccf;
        }
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"cli-connector-factory", CliConnectorFactory.class);
        return result.orElse(null);
    }

    @Override
    protected BeanProxyFactory createBeanProxyFactory() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"bean-proxy-factory", BeanProxyFactory.class);
        if (result.isPresent()) {
            return (BeanProxyFactory)result.get();
        }
        throw new IllegalArgumentException("Cannot find BeanProxyFactory on classpath. Add camel-bean to classpath.");
    }

    @Override
    protected AnnotationBasedProcessorFactory createAnnotationBasedProcessorFactory() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"annotation-processor-factory", AnnotationBasedProcessorFactory.class);
        if (result.isPresent()) {
            return (AnnotationBasedProcessorFactory)result.get();
        }
        throw new IllegalArgumentException("Cannot find AnnotationBasedProcessorFactory on classpath. Add camel-core-processor to classpath.");
    }

    @Override
    protected DeferServiceFactory createDeferServiceFactory() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"defer-service-factory", DeferServiceFactory.class);
        if (result.isPresent()) {
            return (DeferServiceFactory)result.get();
        }
        throw new IllegalArgumentException("Cannot find DeferServiceFactory on classpath. Add camel-core-processor to classpath.");
    }

    @Override
    protected BeanProcessorFactory createBeanProcessorFactory() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"bean-processor-factory", BeanProcessorFactory.class);
        if (result.isPresent()) {
            return (BeanProcessorFactory)result.get();
        }
        throw new IllegalArgumentException("Cannot find BeanProcessorFactory on classpath. Add camel-bean to classpath.");
    }

    @Override
    protected BeanIntrospection createBeanIntrospection() {
        return new DefaultBeanIntrospection();
    }

    @Override
    protected RoutesLoader createRoutesLoader() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"routes-loader", RoutesLoader.class);
        return result.orElseGet(DefaultRoutesLoader::new);
    }

    @Override
    protected ResourceLoader createResourceLoader() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"resource-loader", ResourceLoader.class);
        return result.orElseGet(DefaultResourceLoader::new);
    }

    @Override
    protected ModelToXMLDumper createModelToXMLDumper() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"modelxml-dumper", ModelToXMLDumper.class);
        if (result.isPresent()) {
            return (ModelToXMLDumper)result.get();
        }
        throw new IllegalArgumentException("Cannot find ModelToXMLDumper on classpath. Add camel-xml-io to classpath.");
    }

    @Override
    protected ModelToYAMLDumper createModelToYAMLDumper() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"modelyaml-dumper", ModelToYAMLDumper.class);
        if (result.isPresent()) {
            return (ModelToYAMLDumper)result.get();
        }
        throw new IllegalArgumentException("Cannot find ModelToYAMLDumper on classpath. Add camel-yaml-io to classpath.");
    }

    @Override
    protected RestBindingJaxbDataFormatFactory createRestBindingJaxbDataFormatFactory() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"rest-binding-jaxb-dataformat-factory", RestBindingJaxbDataFormatFactory.class);
        if (result.isPresent()) {
            return (RestBindingJaxbDataFormatFactory)result.get();
        }
        throw new IllegalArgumentException("Cannot find RestBindingJaxbDataFormatFactory on classpath. Add camel-jaxb to classpath.");
    }

    @Override
    protected Tracer createTracer() {
        Tracer tracer = null;
        if (this.getRegistry() != null) {
            tracer = (Tracer)this.getRegistry().findSingleByType(Tracer.class);
        }
        if (tracer == null) {
            tracer = (Tracer)this.getCamelContextExtension().getContextPlugin(Tracer.class);
        }
        if (tracer == null) {
            tracer = new DefaultTracer();
            tracer.setEnabled(this.isTracing().booleanValue());
            tracer.setStandby(this.isTracingStandby());
            boolean restOrTemplates = this.isTracingTemplates();
            tracer.setTraceTemplates(restOrTemplates);
            tracer.setTraceRests(restOrTemplates);
            this.getCamelContextExtension().addContextPlugin(Tracer.class, (Object)tracer);
        }
        return tracer;
    }

    @Override
    protected LanguageResolver createLanguageResolver() {
        return new DefaultLanguageResolver();
    }

    @Override
    protected ConfigurerResolver createConfigurerResolver() {
        return new DefaultConfigurerResolver();
    }

    @Override
    protected UriFactoryResolver createUriFactoryResolver() {
        return new DefaultUriFactoryResolver();
    }

    @Override
    protected RestRegistryFactory createRestRegistryFactory() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"rest-registry-factory", RestRegistryFactory.class);
        if (result.isPresent()) {
            return (RestRegistryFactory)result.get();
        }
        throw new IllegalArgumentException("Cannot find RestRegistryFactory on classpath. Add camel-rest to classpath.");
    }

    @Override
    protected EndpointRegistry<NormalizedUri> createEndpointRegistry(Map<NormalizedUri, Endpoint> endpoints) {
        return new DefaultEndpointRegistry(this.getCamelContextReference(), endpoints);
    }

    @Override
    protected StreamCachingStrategy createStreamCachingStrategy() {
        return new DefaultStreamCachingStrategy();
    }

    @Override
    protected ExchangeFactory createExchangeFactory() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"exchange-factory", ExchangeFactory.class);
        return result.orElseGet(PrototypeExchangeFactory::new);
    }

    @Override
    protected ExchangeFactoryManager createExchangeFactoryManager() {
        return new DefaultExchangeFactoryManager();
    }

    @Override
    protected ProcessorExchangeFactory createProcessorExchangeFactory() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"processor-exchange-factory", ProcessorExchangeFactory.class);
        return result.orElseGet(PrototypeProcessorExchangeFactory::new);
    }

    @Override
    protected ReactiveExecutor createReactiveExecutor() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContextReference(), (FactoryFinder)this.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"reactive-executor", ReactiveExecutor.class);
        return result.orElseGet(DefaultReactiveExecutor::new);
    }

    @Override
    protected ValidatorRegistry<ValidatorKey> createValidatorRegistry() {
        return new DefaultValidatorRegistry(this.getCamelContextReference());
    }

    @Override
    protected VariableRepositoryFactory createVariableRepositoryFactory() {
        return new DefaultVariableRepositoryFactory(this.getCamelContextReference());
    }

    @Override
    protected TransformerRegistry<TransformerKey> createTransformerRegistry() {
        return new DefaultTransformerRegistry(this.getCamelContextReference());
    }

    @Override
    protected ExecutorServiceManager createExecutorServiceManager() {
        return new BaseExecutorServiceManager(this.getCamelContextReference());
    }

    @Override
    public Processor createErrorHandler(Route route, Processor processor) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String addRouteFromTemplate(String routeId, String routeTemplateId, Map<String, Object> parameters) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String addRouteFromTemplate(String routeId, String routeTemplateId, String prefixId, Map<String, Object> parameters) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String addRouteFromTemplate(String routeId, String routeTemplateId, String prefixId, RouteTemplateContext routeTemplateContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void removeRouteTemplates(String pattern) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTestExcludeRoutes() {
        throw new UnsupportedOperationException();
    }
}

