/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.camel.impl.engine.DefaultPackageScanClassResolver;

public class WebSpherePackageScanClassResolver
extends DefaultPackageScanClassResolver {
    private final String resourcePath;

    public WebSpherePackageScanClassResolver(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public static boolean isWebSphereClassLoader(ClassLoader loader) {
        return loader != null && loader.getClass().getName().startsWith("com.ibm.");
    }

    @Override
    protected Enumeration<URL> getResources(ClassLoader loader, String packageName) throws IOException {
        Enumeration<URL> enumeration = super.getResources(loader, packageName);
        if (!enumeration.hasMoreElements()) {
            this.log.trace("Using WebSphere workaround to load the camel jars with the annotated converters.");
            enumeration = loader.getResources(this.resourcePath);
        }
        return enumeration;
    }
}

