/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Service;
import org.apache.camel.spi.BootstrapCloseable;
import org.apache.camel.spi.ConfigurerResolver;
import org.apache.camel.spi.ConfigurerStrategy;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.ProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceBootstrapCloseable
implements BootstrapCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServiceBootstrapCloseable.class);
    private final ExtendedCamelContext camelContext;

    public DefaultServiceBootstrapCloseable(CamelContext camelContext) {
        this.camelContext = (ExtendedCamelContext)camelContext;
    }

    public void close() {
        ConfigurerStrategy.clearBootstrapConfigurers();
        Set set = this.camelContext.getServices().stream().filter(s -> s instanceof BootstrapCloseable).collect(Collectors.toSet());
        for (Service service : set) {
            try {
                if (service instanceof BootstrapCloseable) {
                    ((BootstrapCloseable)service).close();
                }
                this.camelContext.removeService((Object)service);
            }
            catch (Exception e) {
                LOG.warn("Error during closing bootstrap service. This exception is ignored", (Throwable)e);
            }
        }
        ConfigurerResolver cr = this.camelContext.getBootstrapConfigurerResolver();
        if (cr instanceof BootstrapCloseable) {
            try {
                ((BootstrapCloseable)cr).close();
            }
            catch (Exception e) {
                LOG.warn("Error during closing bootstrap service. This exception is ignored", (Throwable)e);
            }
        }
        this.camelContext.setBootstrapConfigurerResolver(null);
        ProcessorFactory pf = this.camelContext.getProcessorFactory();
        if (pf instanceof BootstrapCloseable) {
            try {
                ((BootstrapCloseable)pf).close();
            }
            catch (Exception e) {
                LOG.warn("Error during closing bootstrap service. This exception is ignored", (Throwable)e);
            }
        }
        this.camelContext.setProcessorFactory(null);
        FactoryFinder ff = this.camelContext.getBootstrapFactoryFinder();
        if (ff instanceof BootstrapCloseable) {
            try {
                ((BootstrapCloseable)ff).close();
            }
            catch (Exception e) {
                LOG.warn("Error during closing bootstrap service. This exception is ignored", (Throwable)e);
            }
        }
        this.camelContext.setBootstrapFactoryFinder(null);
    }
}

