/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake.operations;

import com.azure.core.http.rest.Response;
import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.models.AccessTier;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.DownloadRetryOptions;
import com.azure.storage.file.datalake.models.FileRange;
import com.azure.storage.file.datalake.models.FileReadHeaders;
import com.azure.storage.file.datalake.models.FileReadResponse;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PathInfo;
import com.azure.storage.file.datalake.models.PathProperties;
import com.azure.storage.file.datalake.options.DataLakeFileAppendOptions;
import com.azure.storage.file.datalake.options.FileParallelUploadOptions;
import com.azure.storage.file.datalake.options.FileQueryOptions;
import com.azure.storage.file.datalake.sas.DataLakeServiceSasSignatureValues;
import com.azure.storage.file.datalake.sas.PathSasPermission;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfiguration;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfigurationOptionsProxy;
import org.apache.camel.component.azure.storage.datalake.DataLakeExchangeHeaders;
import org.apache.camel.component.azure.storage.datalake.DataLakeUtils;
import org.apache.camel.component.azure.storage.datalake.FileCommonRequestOptions;
import org.apache.camel.component.azure.storage.datalake.FileStreamAndLength;
import org.apache.camel.component.azure.storage.datalake.client.DataLakeFileClientWrapper;
import org.apache.camel.component.azure.storage.datalake.operations.DataLakeOperationResponse;
import org.apache.camel.util.ObjectHelper;

public class DataLakeFileOperations {
    private final DataLakeFileClientWrapper client;
    private final DataLakeConfigurationOptionsProxy configurationProxy;

    public DataLakeFileOperations(DataLakeConfiguration configuration, DataLakeFileClientWrapper client) {
        this.client = client;
        this.configurationProxy = new DataLakeConfigurationOptionsProxy(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataLakeOperationResponse getFile(Exchange exchange) throws IOException {
        Message message = DataLakeUtils.getInMessage(exchange);
        OutputStream outputStream = ObjectHelper.isEmpty((Object)message) ? null : (OutputStream)message.getBody(OutputStream.class);
        DataLakeFileClientWrapper fileClientWrapper = this.getFileClientWrapper(exchange);
        if (outputStream == null) {
            InputStream fileInputStream = fileClientWrapper.openInputStream();
            return new DataLakeOperationResponse(fileInputStream);
        }
        FileRange fileRange = this.configurationProxy.getFileRange(exchange);
        FileCommonRequestOptions fileCommonRequestOptions = this.getCommonRequestOptions(exchange);
        DownloadRetryOptions downloadRetryOptions = this.getDownloadRetryOptions(this.configurationProxy);
        try {
            FileReadResponse readResponse = fileClientWrapper.downloadWithResponse(outputStream, fileRange, downloadRetryOptions, (DataLakeRequestConditions)fileCommonRequestOptions.getRequestConditions(), fileCommonRequestOptions.getContentMD5() != null, fileCommonRequestOptions.getTimeout());
            DataLakeExchangeHeaders dataLakeExchangeHeaders = DataLakeExchangeHeaders.createDataLakeExchangeHeadersFromFileReadHeaders((FileReadHeaders)readResponse.getDeserializedHeaders()).httpHeaders(readResponse.getHeaders());
            DataLakeOperationResponse dataLakeOperationResponse = new DataLakeOperationResponse(outputStream, dataLakeExchangeHeaders.toMap());
            return dataLakeOperationResponse;
        }
        finally {
            if (Boolean.TRUE.equals(this.configurationProxy.getConfiguration().getCloseStreamAfterRead())) {
                outputStream.close();
            }
        }
    }

    public DataLakeOperationResponse downloadToFile(Exchange exchange) {
        String fileDir = this.configurationProxy.getFileDir(exchange);
        if (ObjectHelper.isEmpty((String)fileDir)) {
            throw new IllegalArgumentException("to download a file, you need to specify the fileDir in the URI");
        }
        DataLakeFileClientWrapper fileClientWrapper = this.getFileClientWrapper(exchange);
        File recieverFile = new File(fileDir, fileClientWrapper.getFileName());
        FileCommonRequestOptions commonRequestOptions = this.getCommonRequestOptions(exchange);
        FileRange fileRange = this.configurationProxy.getFileRange(exchange);
        ParallelTransferOptions parallelTransferOptions = this.configurationProxy.getParallelTransferOptions(exchange);
        DownloadRetryOptions downloadRetryOptions = this.getDownloadRetryOptions(this.configurationProxy);
        Set<OpenOption> openOptions = this.configurationProxy.getOpenOptions(exchange);
        Response<PathProperties> response = fileClientWrapper.downloadToFileWithResponse(recieverFile.toString(), fileRange, parallelTransferOptions, downloadRetryOptions, (DataLakeRequestConditions)commonRequestOptions.getRequestConditions(), commonRequestOptions.getContentMD5() != null, openOptions, commonRequestOptions.getTimeout());
        DataLakeExchangeHeaders exchangeHeaders = DataLakeExchangeHeaders.createDataLakeExchangeHeadersFromPathProperties((PathProperties)response.getValue()).httpHeaders(response.getHeaders()).fileName(recieverFile.toString());
        return new DataLakeOperationResponse(recieverFile, exchangeHeaders.toMap());
    }

    public DataLakeOperationResponse downloadLink(Exchange exchange) {
        OffsetDateTime offsetDateTimeToSet;
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        PathSasPermission sasPermission = new PathSasPermission().setReadPermission(true);
        Long expirationMillis = this.configurationProxy.getDownloadLinkExpiration(exchange);
        if (expirationMillis != null) {
            offsetDateTimeToSet = offsetDateTime.plusSeconds(expirationMillis / 1000L);
        } else {
            long defaultExpirationTime = 3600L;
            offsetDateTimeToSet = offsetDateTime.plusSeconds(3600L);
        }
        DataLakeServiceSasSignatureValues serviceSasSignatureValues = new DataLakeServiceSasSignatureValues(offsetDateTimeToSet, sasPermission);
        DataLakeFileClientWrapper fileClientWrapper = this.getFileClientWrapper(exchange);
        String url = fileClientWrapper.getFileUrl() + "?" + fileClientWrapper.generateSas(serviceSasSignatureValues);
        DataLakeExchangeHeaders headers = DataLakeExchangeHeaders.create().downloadLink(url);
        return new DataLakeOperationResponse(url, headers.toMap());
    }

    public DataLakeOperationResponse deleteFile(Exchange exchange) {
        FileCommonRequestOptions commonRequestOptions = this.getCommonRequestOptions(exchange);
        DataLakeFileClientWrapper fileClientWrapper = this.getFileClientWrapper(exchange);
        Response<Void> response = fileClientWrapper.delete((DataLakeRequestConditions)commonRequestOptions.getRequestConditions(), commonRequestOptions.getTimeout());
        DataLakeExchangeHeaders exchangeHeaders = DataLakeExchangeHeaders.create();
        exchangeHeaders.httpHeaders(response.getHeaders());
        return new DataLakeOperationResponse(true, exchangeHeaders.toMap());
    }

    public DataLakeOperationResponse appendToFile(Exchange exchange) throws IOException {
        FileCommonRequestOptions commonRequestOptions = this.getCommonRequestOptions(exchange);
        FileStreamAndLength fileStreamAndLength = FileStreamAndLength.createFileStreamAndLengthFromExchangeBody(exchange);
        DataLakeFileClientWrapper fileClientWrapper = this.getFileClientWrapper(exchange);
        Long fileOffset = this.configurationProxy.getFileOffset(exchange) == null ? fileClientWrapper.getFileSize() : this.configurationProxy.getFileOffset(exchange);
        DataLakeFileAppendOptions options = new DataLakeFileAppendOptions();
        options.setContentHash(commonRequestOptions.getContentMD5());
        options.setLeaseId(commonRequestOptions.getLeaseId());
        options.setFlush(this.configurationProxy.getFlush(exchange));
        Response<Void> response = fileClientWrapper.appendWithResponse(fileStreamAndLength.getInputStream(), fileOffset, fileStreamAndLength.getStreamLength(), commonRequestOptions.getTimeout(), options);
        DataLakeExchangeHeaders exchangeHeaders = DataLakeExchangeHeaders.create();
        exchangeHeaders.httpHeaders(response.getHeaders());
        return new DataLakeOperationResponse(true, exchangeHeaders.toMap());
    }

    public DataLakeOperationResponse flushToFile(Exchange exchange) {
        FileCommonRequestOptions commonRequestOptions = this.getCommonRequestOptions(exchange);
        Long position = this.configurationProxy.getPosition(exchange);
        Boolean retainUncommitedData = this.configurationProxy.retainUnCommitedData(exchange);
        Boolean close = this.configurationProxy.getClose(exchange);
        DataLakeFileClientWrapper fileClientWrapper = this.getFileClientWrapper(exchange);
        Response<PathInfo> response = fileClientWrapper.flushWithResponse(position + fileClientWrapper.getFileSize(), retainUncommitedData, close, commonRequestOptions.getPathHttpHeaders(), (DataLakeRequestConditions)commonRequestOptions.getRequestConditions(), commonRequestOptions.getTimeout());
        DataLakeExchangeHeaders exchangeHeaders = DataLakeExchangeHeaders.createDataLakeExchangeHeadersFromPathInfo((PathInfo)response.getValue()).httpHeaders(response.getHeaders());
        return new DataLakeOperationResponse(response.getValue(), exchangeHeaders.toMap());
    }

    public DataLakeOperationResponse uploadFromFile(Exchange exchange) {
        String path = this.configurationProxy.getPath(exchange);
        ParallelTransferOptions transferOptions = this.configurationProxy.getParallelTransferOptions(exchange);
        FileCommonRequestOptions commonRequestOptions = this.getCommonRequestOptions(exchange);
        DataLakeFileClientWrapper fileClientWrapper = this.getFileClientWrapper(exchange);
        fileClientWrapper.uploadFromFile(path, transferOptions, commonRequestOptions.getPathHttpHeaders(), commonRequestOptions.getMetadata(), (DataLakeRequestConditions)commonRequestOptions.getRequestConditions(), commonRequestOptions.getTimeout());
        return new DataLakeOperationResponse(true);
    }

    public DataLakeOperationResponse upload(Exchange exchange) throws Exception {
        FileCommonRequestOptions commonRequestOptions = this.getCommonRequestOptions(exchange);
        ParallelTransferOptions transferOptions = this.configurationProxy.getParallelTransferOptions(exchange);
        InputStream is = (InputStream)exchange.getMessage().getMandatoryBody(InputStream.class);
        String permission = this.configurationProxy.getPermission(exchange);
        String umask = this.configurationProxy.getUmask(exchange);
        FileParallelUploadOptions uploadOptions = new FileParallelUploadOptions(is).setHeaders(commonRequestOptions.getPathHttpHeaders()).setParallelTransferOptions(transferOptions).setMetadata(commonRequestOptions.getMetadata()).setPermissions(permission).setRequestConditions(commonRequestOptions.getRequestConditions()).setRequestConditions(commonRequestOptions.getRequestConditions()).setUmask(umask);
        DataLakeFileClientWrapper fileClientWrapper = this.getFileClientWrapper(exchange);
        Response<PathInfo> response = fileClientWrapper.uploadWithResponse(uploadOptions, commonRequestOptions.getTimeout());
        DataLakeExchangeHeaders exchangeHeaders = DataLakeExchangeHeaders.createDataLakeExchangeHeadersFromPathInfo((PathInfo)response.getValue()).httpHeaders(response.getHeaders());
        return new DataLakeOperationResponse(true, exchangeHeaders.toMap());
    }

    public DataLakeOperationResponse openQueryInputStream(Exchange exchange) {
        FileQueryOptions queryOptions = this.configurationProxy.getFileQueryOptions(exchange);
        DataLakeFileClientWrapper fileClientWrapper = this.getFileClientWrapper(exchange);
        Response<InputStream> response = fileClientWrapper.openQueryInputStreamWithResponse(queryOptions);
        DataLakeExchangeHeaders exchangeHeaders = DataLakeExchangeHeaders.create();
        exchangeHeaders.httpHeaders(response.getHeaders());
        return new DataLakeOperationResponse(response.getValue(), exchangeHeaders.toMap());
    }

    private FileCommonRequestOptions getCommonRequestOptions(Exchange exchange) {
        PathHttpHeaders httpHeaders = this.configurationProxy.getPathHttpHeaders(exchange);
        Map<String, String> metadata = this.configurationProxy.getMetadata(exchange);
        AccessTier accessTier = this.configurationProxy.getAccessTier(exchange);
        DataLakeRequestConditions dataLakeRequestConditions = this.configurationProxy.getDataLakeRequestConditions(exchange);
        Duration timeout = this.configurationProxy.getTimeout(exchange);
        byte[] contentMD5 = this.configurationProxy.getContentMd5(exchange);
        return new FileCommonRequestOptions(httpHeaders, metadata, accessTier, dataLakeRequestConditions, contentMD5, timeout);
    }

    private DownloadRetryOptions getDownloadRetryOptions(DataLakeConfigurationOptionsProxy proxy) {
        return new DownloadRetryOptions().setMaxRetryRequests(proxy.getMaxRetryRequests());
    }

    private DataLakeFileClientWrapper getFileClientWrapper(Exchange exchange) {
        DataLakeFileClient fileClient = this.configurationProxy.getFileClient(exchange);
        return null == fileClient ? this.client : new DataLakeFileClientWrapper(fileClient);
    }
}

