/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.messaging.servicebus.ServiceBusProcessorClient;
import com.azure.messaging.servicebus.ServiceBusSenderClient;
import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import com.azure.messaging.servicebus.models.ServiceBusReceiveMode;
import com.azure.messaging.servicebus.models.SubQueue;
import java.time.Duration;
import java.time.OffsetDateTime;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.azure.servicebus.CredentialType;
import org.apache.camel.component.azure.servicebus.ServiceBusHeaderFilterStrategy;
import org.apache.camel.component.azure.servicebus.ServiceBusProducerOperationDefinition;
import org.apache.camel.component.azure.servicebus.ServiceBusType;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class ServiceBusConfiguration
implements Cloneable,
HeaderFilterStrategyAware {
    @UriPath
    private String topicOrQueueName;
    @UriParam(label="common", defaultValue="queue")
    @Metadata(required=true)
    private ServiceBusType serviceBusType = ServiceBusType.queue;
    @UriParam(label="security", secret=true)
    private String connectionString;
    @UriParam(label="security")
    private String fullyQualifiedNamespace;
    @UriParam(label="security", secret=true)
    private TokenCredential tokenCredential;
    @UriParam(label="common")
    private ClientOptions clientOptions;
    @UriParam(label="common")
    private ProxyOptions proxyOptions;
    @UriParam(label="common")
    private AmqpRetryOptions amqpRetryOptions;
    @UriParam(label="common", defaultValue="AMQP")
    private AmqpTransportType amqpTransportType = AmqpTransportType.AMQP;
    @UriParam(label="common", description="To use a custom HeaderFilterStrategy to filter Service Bus application properties to and from Camel message headers.")
    private HeaderFilterStrategy headerFilterStrategy = new ServiceBusHeaderFilterStrategy();
    @UriParam(label="consumer")
    @Metadata(autowired=true)
    private ServiceBusProcessorClient processorClient;
    @UriParam(label="consumer")
    private String subscriptionName;
    @UriParam(label="consumer")
    private boolean enableDeadLettering;
    @UriParam(label="consumer", defaultValue="PEEK_LOCK")
    private ServiceBusReceiveMode serviceBusReceiveMode = ServiceBusReceiveMode.PEEK_LOCK;
    @UriParam(label="consumer", defaultValue="5m")
    private Duration maxAutoLockRenewDuration = Duration.ofMinutes(5L);
    @UriParam(label="consumer")
    private int prefetchCount;
    @UriParam(label="consumer")
    private SubQueue subQueue;
    @UriParam(label="consumer", defaultValue="1")
    private int maxConcurrentCalls = 1;
    @UriParam(label="producer", defaultValue="sendMessages")
    private ServiceBusProducerOperationDefinition producerOperation = ServiceBusProducerOperationDefinition.sendMessages;
    @UriParam(label="producer")
    @Metadata(autowired=true)
    private ServiceBusSenderClient senderClient;
    @UriParam(label="producer")
    private ServiceBusTransactionContext serviceBusTransactionContext;
    @UriParam(label="producer")
    private OffsetDateTime scheduledEnqueueTime;
    @UriParam(label="producer")
    private boolean binary;
    @UriParam(label="security", enums="AZURE_IDENTITY,CONNECTION_STRING,TOKEN_CREDENTIAL", defaultValue="CONNECTION_STRING")
    private CredentialType credentialType = CredentialType.CONNECTION_STRING;

    public String getTopicOrQueueName() {
        return this.topicOrQueueName;
    }

    public void setTopicOrQueueName(String topicOrQueueName) {
        this.topicOrQueueName = topicOrQueueName;
    }

    public ServiceBusType getServiceBusType() {
        return this.serviceBusType;
    }

    public void setServiceBusType(ServiceBusType serviceBusType) {
        this.serviceBusType = serviceBusType;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public void setClientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public void setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
    }

    public AmqpRetryOptions getAmqpRetryOptions() {
        return this.amqpRetryOptions;
    }

    public void setAmqpRetryOptions(AmqpRetryOptions amqpRetryOptions) {
        this.amqpRetryOptions = amqpRetryOptions;
    }

    public AmqpTransportType getAmqpTransportType() {
        return this.amqpTransportType;
    }

    public void setAmqpTransportType(AmqpTransportType amqpTransportType) {
        this.amqpTransportType = amqpTransportType;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public ServiceBusProcessorClient getProcessorClient() {
        return this.processorClient;
    }

    public void setProcessorClient(ServiceBusProcessorClient processorClient) {
        this.processorClient = processorClient;
    }

    public boolean isEnableDeadLettering() {
        return this.enableDeadLettering;
    }

    public void setEnableDeadLettering(boolean enableDeadLettering) {
        this.enableDeadLettering = enableDeadLettering;
    }

    public ServiceBusReceiveMode getServiceBusReceiveMode() {
        return this.serviceBusReceiveMode;
    }

    public void setServiceBusReceiveMode(ServiceBusReceiveMode serviceBusReceiveMode) {
        this.serviceBusReceiveMode = serviceBusReceiveMode;
    }

    public Duration getMaxAutoLockRenewDuration() {
        return this.maxAutoLockRenewDuration;
    }

    public void setMaxAutoLockRenewDuration(Duration maxAutoLockRenewDuration) {
        this.maxAutoLockRenewDuration = maxAutoLockRenewDuration;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public SubQueue getSubQueue() {
        return this.subQueue;
    }

    public void setSubQueue(SubQueue subQueue) {
        this.subQueue = subQueue;
    }

    public int getMaxConcurrentCalls() {
        return this.maxConcurrentCalls;
    }

    public void setMaxConcurrentCalls(int maxConcurrentCalls) {
        this.maxConcurrentCalls = maxConcurrentCalls;
    }

    public ServiceBusSenderClient getSenderClient() {
        return this.senderClient;
    }

    public void setSenderClient(ServiceBusSenderClient senderClient) {
        this.senderClient = senderClient;
    }

    public String getFullyQualifiedNamespace() {
        return this.fullyQualifiedNamespace;
    }

    public void setFullyQualifiedNamespace(String fullyQualifiedNamespace) {
        this.fullyQualifiedNamespace = fullyQualifiedNamespace;
    }

    public TokenCredential getTokenCredential() {
        return this.tokenCredential;
    }

    public void setTokenCredential(TokenCredential tokenCredential) {
        this.tokenCredential = tokenCredential;
    }

    public ServiceBusProducerOperationDefinition getProducerOperation() {
        return this.producerOperation;
    }

    public void setProducerOperation(ServiceBusProducerOperationDefinition producerOperation) {
        this.producerOperation = producerOperation;
    }

    public ServiceBusTransactionContext getServiceBusTransactionContext() {
        return this.serviceBusTransactionContext;
    }

    public void setServiceBusTransactionContext(ServiceBusTransactionContext serviceBusTransactionContext) {
        this.serviceBusTransactionContext = serviceBusTransactionContext;
    }

    public OffsetDateTime getScheduledEnqueueTime() {
        return this.scheduledEnqueueTime;
    }

    public void setScheduledEnqueueTime(OffsetDateTime scheduledEnqueueTime) {
        this.scheduledEnqueueTime = scheduledEnqueueTime;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public CredentialType getCredentialType() {
        return this.credentialType;
    }

    public void setCredentialType(CredentialType credentialType) {
        this.credentialType = credentialType;
    }

    public ServiceBusConfiguration copy() {
        try {
            return (ServiceBusConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

