/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus;

import com.azure.core.util.BinaryData;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.azure.servicebus.ServiceBusTypeConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class ServiceBusTypeConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        ServiceBusTypeConverterLoader.addTypeConverter(registry, BinaryData.class, String.class, true, (type, exchange, value) -> {
            Object answer = ServiceBusTypeConverter.toBinaryData((String)value);
            if (answer == null) {
                answer = Void.class;
            }
            return answer;
        });
        ServiceBusTypeConverterLoader.addTypeConverter(registry, String.class, BinaryData.class, true, (type, exchange, value) -> {
            Object answer = ServiceBusTypeConverter.toString((BinaryData)value);
            if (answer == null) {
                answer = Void.class;
            }
            return answer;
        });
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

