/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus;

import com.azure.core.util.BinaryData;
import com.azure.messaging.servicebus.ServiceBusMessage;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.camel.component.azure.servicebus.ServiceBusConfiguration;
import org.apache.camel.util.ObjectHelper;

public final class ServiceBusUtils {
    private ServiceBusUtils() {
    }

    public static ServiceBusMessage createServiceBusMessage(Object data, Map<String, Object> applicationProperties, String correlationId, String sessionId) {
        ServiceBusMessage serviceBusMessage;
        if (data instanceof String) {
            serviceBusMessage = new ServiceBusMessage((String)data);
        } else if (data instanceof byte[]) {
            serviceBusMessage = new ServiceBusMessage((byte[])data);
        } else if (data instanceof BinaryData) {
            serviceBusMessage = new ServiceBusMessage((BinaryData)data);
        } else {
            throw new IllegalArgumentException("Make sure your message data is in String, byte[] or BinaryData");
        }
        if (applicationProperties != null) {
            serviceBusMessage.getRawAmqpMessage().getApplicationProperties().putAll(applicationProperties);
        }
        if (ObjectHelper.isNotEmpty((String)correlationId)) {
            serviceBusMessage.setCorrelationId(correlationId);
        }
        if (ObjectHelper.isNotEmpty((String)sessionId)) {
            serviceBusMessage.setSessionId(sessionId);
        }
        return serviceBusMessage;
    }

    public static Iterable<ServiceBusMessage> createServiceBusMessages(Iterable<?> data, Map<String, Object> applicationProperties, String correlationId, String sessionId) {
        return StreamSupport.stream(data.spliterator(), false).map(obj -> ServiceBusUtils.createServiceBusMessage(obj, applicationProperties, correlationId, sessionId)).collect(Collectors.toList());
    }

    public static void validateConfiguration(ServiceBusConfiguration configuration, boolean isConsumer) {
        boolean customClientAbsent;
        boolean bl = isConsumer ? configuration.getProcessorClient() == null : (customClientAbsent = configuration.getSenderClient() == null);
        if (customClientAbsent && ServiceBusUtils.isConnectionStringOrFQNSAbsent(configuration)) {
            throw new IllegalArgumentException("Azure ServiceBus ConnectionString or FQNS must be specified.");
        }
    }

    static boolean isConnectionStringOrFQNSAbsent(ServiceBusConfiguration configuration) {
        return ObjectHelper.isEmpty((String)configuration.getConnectionString()) && ObjectHelper.isEmpty((String)configuration.getFullyQualifiedNamespace());
    }
}

