/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus;

import com.azure.core.util.BinaryData;
import com.azure.messaging.servicebus.ServiceBusSenderClient;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.azure.servicebus.ServiceBusConfiguration;
import org.apache.camel.component.azure.servicebus.ServiceBusConfigurationOptionsProxy;
import org.apache.camel.component.azure.servicebus.ServiceBusEndpoint;
import org.apache.camel.component.azure.servicebus.ServiceBusProducerOperationDefinition;
import org.apache.camel.component.azure.servicebus.ServiceBusUtils;
import org.apache.camel.component.azure.servicebus.operations.ServiceBusSenderOperations;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class ServiceBusProducer
extends DefaultProducer {
    private final Map<ServiceBusProducerOperationDefinition, Consumer<Exchange>> operationsToExecute = new EnumMap<ServiceBusProducerOperationDefinition, Consumer<Exchange>>(ServiceBusProducerOperationDefinition.class);
    private ServiceBusSenderClient client;
    private ServiceBusConfigurationOptionsProxy configurationOptionsProxy;
    private ServiceBusSenderOperations serviceBusSenderOperations;

    public ServiceBusProducer(Endpoint endpoint) {
        super(endpoint);
        this.bind(ServiceBusProducerOperationDefinition.sendMessages, this.sendMessages());
        this.bind(ServiceBusProducerOperationDefinition.scheduleMessages, this.scheduleMessages());
    }

    protected void doInit() throws Exception {
        super.doInit();
        ServiceBusUtils.validateConfiguration(this.getConfiguration(), false);
        this.configurationOptionsProxy = new ServiceBusConfigurationOptionsProxy(this.getConfiguration());
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.client = this.getConfiguration().getSenderClient() != null ? this.getConfiguration().getSenderClient() : this.getEndpoint().getServiceBusClientFactory().createServiceBusSenderClient(this.getConfiguration());
        this.serviceBusSenderOperations = new ServiceBusSenderOperations(this.client);
    }

    public void process(Exchange exchange) {
        ServiceBusProducerOperationDefinition operation = this.configurationOptionsProxy.getServiceBusProducerOperationDefinition(exchange);
        ServiceBusProducerOperationDefinition operationsToInvoke = ObjectHelper.isEmpty((Object)((Object)operation)) ? ServiceBusProducerOperationDefinition.sendMessages : operation;
        Consumer<Exchange> fnToInvoke = this.operationsToExecute.get((Object)operationsToInvoke);
        if (fnToInvoke == null) {
            throw new RuntimeCamelException("Operation not supported. Value: " + String.valueOf((Object)operationsToInvoke));
        }
        fnToInvoke.accept(exchange);
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        super.doStop();
    }

    public ServiceBusEndpoint getEndpoint() {
        return (ServiceBusEndpoint)super.getEndpoint();
    }

    public ServiceBusConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    private void bind(ServiceBusProducerOperationDefinition operation, Consumer<Exchange> fn) {
        this.operationsToExecute.put(operation, fn);
    }

    private Consumer<Exchange> sendMessages() {
        return exchange -> {
            Object inputBody = exchange.getMessage().getBody();
            HashMap<String, Object> applicationProperties = (HashMap<String, Object>)exchange.getMessage().getHeader("CamelAzureServiceBusApplicationProperties", Map.class);
            if (applicationProperties == null) {
                applicationProperties = new HashMap<String, Object>();
            }
            this.propagateHeaders((Exchange)exchange, (Map<String, Object>)applicationProperties);
            String correlationId = (String)exchange.getMessage().getHeader("CamelAzureServiceBusCorrelationId", String.class);
            String sessionId = this.getConfiguration().getSessionId();
            if (inputBody instanceof Iterable) {
                this.serviceBusSenderOperations.sendMessages(this.convertBodyToList((Iterable)inputBody), this.configurationOptionsProxy.getServiceBusTransactionContext((Exchange)exchange), (Map<String, Object>)applicationProperties, correlationId, sessionId);
            } else {
                Object convertedBody = inputBody instanceof BinaryData ? inputBody : (this.getConfiguration().isBinary() ? this.convertBodyToBinary((Exchange)exchange) : exchange.getMessage().getBody(String.class));
                this.serviceBusSenderOperations.sendMessages(convertedBody, this.configurationOptionsProxy.getServiceBusTransactionContext((Exchange)exchange), applicationProperties, correlationId, sessionId);
            }
        };
    }

    private Consumer<Exchange> scheduleMessages() {
        return exchange -> {
            Object inputBody = exchange.getMessage().getBody();
            HashMap<String, Object> applicationProperties = (HashMap<String, Object>)exchange.getMessage().getHeader("CamelAzureServiceBusApplicationProperties", Map.class);
            if (applicationProperties == null) {
                applicationProperties = new HashMap<String, Object>();
            }
            this.propagateHeaders((Exchange)exchange, (Map<String, Object>)applicationProperties);
            String correlationId = (String)exchange.getMessage().getHeader("CamelAzureServiceBusCorrelationId", String.class);
            String sessionId = this.getConfiguration().getSessionId();
            if (inputBody instanceof Iterable) {
                this.serviceBusSenderOperations.scheduleMessages(this.convertBodyToList((Iterable)inputBody), this.configurationOptionsProxy.getScheduledEnqueueTime((Exchange)exchange), this.configurationOptionsProxy.getServiceBusTransactionContext((Exchange)exchange), (Map<String, Object>)applicationProperties, correlationId, sessionId);
            } else {
                Object convertedBody = inputBody instanceof BinaryData ? inputBody : (this.getConfiguration().isBinary() ? this.convertBodyToBinary((Exchange)exchange) : exchange.getMessage().getBody(String.class));
                this.serviceBusSenderOperations.scheduleMessages(convertedBody, this.configurationOptionsProxy.getScheduledEnqueueTime((Exchange)exchange), this.configurationOptionsProxy.getServiceBusTransactionContext((Exchange)exchange), applicationProperties, correlationId, sessionId);
            }
        };
    }

    private List<?> convertBodyToList(Iterable<?> inputBody) {
        return StreamSupport.stream(inputBody.spliterator(), false).map(this::convertMessageBody).toList();
    }

    private Object convertBodyToBinary(Exchange exchange) {
        Object body = exchange.getMessage().getBody();
        if (body instanceof InputStream) {
            return BinaryData.fromStream((InputStream)((InputStream)body));
        }
        if (body instanceof Path) {
            return BinaryData.fromFile((Path)((Path)body));
        }
        if (body instanceof File) {
            return BinaryData.fromFile((Path)((File)body).toPath());
        }
        return BinaryData.fromBytes((byte[])((byte[])exchange.getMessage().getBody(byte[].class)));
    }

    private Object convertMessageBody(Object inputBody) {
        TypeConverter typeConverter = this.getEndpoint().getCamelContext().getTypeConverter();
        if (inputBody instanceof BinaryData) {
            return inputBody;
        }
        if (this.getConfiguration().isBinary()) {
            if (inputBody instanceof InputStream) {
                return BinaryData.fromStream((InputStream)((InputStream)inputBody));
            }
            if (inputBody instanceof Path) {
                return BinaryData.fromFile((Path)((Path)inputBody));
            }
            if (inputBody instanceof File) {
                return BinaryData.fromFile((Path)((File)inputBody).toPath());
            }
            return typeConverter.convertTo(byte[].class, inputBody);
        }
        return typeConverter.convertTo(String.class, inputBody);
    }

    private void propagateHeaders(Exchange exchange, Map<String, Object> applicationProperties) {
        HeaderFilterStrategy headerFilterStrategy = this.getConfiguration().getHeaderFilterStrategy();
        applicationProperties.putAll(exchange.getMessage().getHeaders().entrySet().stream().filter(entry -> !headerFilterStrategy.applyFilterToCamelHeaders((String)entry.getKey(), entry.getValue(), exchange)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }
}

