/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus;

import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import java.time.OffsetDateTime;
import java.util.function.Supplier;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.servicebus.ServiceBusConfiguration;
import org.apache.camel.component.azure.servicebus.ServiceBusProducerOperationDefinition;
import org.apache.camel.util.ObjectHelper;

public class ServiceBusConfigurationOptionsProxy {
    private final ServiceBusConfiguration configuration;

    public ServiceBusConfigurationOptionsProxy(ServiceBusConfiguration configuration) {
        this.configuration = configuration;
    }

    private static <T> T getObjectFromHeaders(Exchange exchange, String headerName, Class<T> classType) {
        return (T)exchange.getIn().getHeader(headerName, classType);
    }

    public ServiceBusConfiguration getConfiguration() {
        return this.configuration;
    }

    public ServiceBusTransactionContext getServiceBusTransactionContext(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureServiceBusServiceBusTransactionContext", this.configuration::getServiceBusTransactionContext, ServiceBusTransactionContext.class);
    }

    public OffsetDateTime getScheduledEnqueueTime(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureServiceBusScheduledEnqueueTime", this.configuration::getScheduledEnqueueTime, OffsetDateTime.class);
    }

    public ServiceBusProducerOperationDefinition getServiceBusProducerOperationDefinition(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureServiceBusProducerOperation", this.configuration::getProducerOperation, ServiceBusProducerOperationDefinition.class);
    }

    private <R> R getOption(Exchange exchange, String headerName, Supplier<R> fallbackFn, Class<R> type) {
        return ObjectHelper.isEmpty((Object)exchange) || ObjectHelper.isEmpty(ServiceBusConfigurationOptionsProxy.getObjectFromHeaders(exchange, headerName, type)) ? fallbackFn.get() : ServiceBusConfigurationOptionsProxy.getObjectFromHeaders(exchange, headerName, type);
    }
}

