/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.key.vault;

import com.azure.security.keyvault.secrets.SecretClient;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.azure.key.vault.CredentialType;
import org.apache.camel.component.azure.key.vault.KeyVaultOperation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class KeyVaultConfiguration
implements Cloneable {
    @UriPath
    private String vaultName;
    @UriParam
    @Metadata(autowired=true)
    private SecretClient secretClient;
    @UriParam(label="security", secret=true)
    private String clientId;
    @UriParam(label="security", secret=true)
    private String clientSecret;
    @UriParam(label="security", secret=true)
    private String tenantId;
    @UriParam(label="producer")
    private KeyVaultOperation operation = KeyVaultOperation.createSecret;
    @UriParam(label="common", enums="CLIENT_SECRET,AZURE_IDENTITY", defaultValue="CLIENT_SECRET")
    private CredentialType credentialType = CredentialType.CLIENT_SECRET;

    public SecretClient getSecretClient() {
        return this.secretClient;
    }

    public void setSecretClient(SecretClient secretClient) {
        this.secretClient = secretClient;
    }

    public String getVaultName() {
        return this.vaultName;
    }

    public void setVaultName(String vaultName) {
        this.vaultName = vaultName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public KeyVaultOperation getOperation() {
        return this.operation;
    }

    public void setOperation(KeyVaultOperation operation) {
        this.operation = operation;
    }

    public CredentialType getCredentialType() {
        return this.credentialType;
    }

    public void setCredentialType(CredentialType credentialType) {
        this.credentialType = credentialType;
    }

    public KeyVaultConfiguration copy() {
        try {
            return (KeyVaultConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

